/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.cluster.remote;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.common.utils.LoggerUtils;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.NodeState;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.cluster.remote.request.MemberReportRequest;
import com.alibaba.nacos.core.cluster.remote.response.MemberReportResponse;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.core.utils.Loggers;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class MemberReportHandler
extends RequestHandler<MemberReportRequest, MemberReportResponse> {
    private final ServerMemberManager memberManager;

    public MemberReportHandler(ServerMemberManager memberManager) {
        this.memberManager = memberManager;
    }

    @Override
    public MemberReportResponse handle(MemberReportRequest request, RequestMeta meta) throws NacosException {
        Member node = request.getNode();
        if (!node.check()) {
            MemberReportResponse result = new MemberReportResponse();
            result.setErrorInfo(400, "Node information is illegal");
            return result;
        }
        LoggerUtils.printIfDebugEnabled((Logger)Loggers.CLUSTER, (String)"node state report, receive info : {}", (Object[])new Object[]{node});
        node.setState(NodeState.UP);
        node.setFailAccessCnt(0);
        this.memberManager.update(node);
        return new MemberReportResponse(this.memberManager.getSelf());
    }
}

