/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.cluster;

import com.alibaba.nacos.api.ability.ServerAbilities;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.cluster.NodeState;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class Member
implements Comparable<Member>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -6061130045021268736L;
    private String ip;
    private int port = -1;
    private volatile NodeState state = NodeState.UP;
    private Map<String, Object> extendInfo = Collections.synchronizedMap(new TreeMap());
    private String address = "";
    private transient int failAccessCnt = 0;
    private ServerAbilities abilities = new ServerAbilities();

    public Member() {
        String prefix = "nacos.core.member.meta.";
        this.extendInfo.put("site", EnvUtil.getProperty((String)(prefix + "site"), (String)"unknow"));
        this.extendInfo.put("adWeight", EnvUtil.getProperty((String)(prefix + "adWeight"), (String)"0"));
        this.extendInfo.put("weight", EnvUtil.getProperty((String)(prefix + "weight"), (String)"1"));
    }

    public ServerAbilities getAbilities() {
        return this.abilities;
    }

    public void setAbilities(ServerAbilities abilities) {
        this.abilities = abilities;
    }

    public static MemberBuilder builder() {
        return new MemberBuilder();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public NodeState getState() {
        return this.state;
    }

    public void setState(NodeState state) {
        this.state = state;
    }

    public Map<String, Object> getExtendInfo() {
        return this.extendInfo;
    }

    public void setExtendInfo(Map<String, Object> extendInfo) {
        Map<String, Object> newExtendInfo = Collections.synchronizedMap(new TreeMap());
        newExtendInfo.putAll(extendInfo);
        this.extendInfo = newExtendInfo;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getAddress() {
        if (StringUtils.isBlank((CharSequence)this.address)) {
            this.address = this.ip + ":" + this.port;
        }
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Object getExtendVal(String key) {
        return this.extendInfo.get(key);
    }

    public void setExtendVal(String key, Object value) {
        this.extendInfo.put(key, value);
    }

    public void delExtendVal(String key) {
        this.extendInfo.remove(key);
    }

    public boolean check() {
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.ip, this.address}) && this.port != -1;
    }

    public int getFailAccessCnt() {
        return this.failAccessCnt;
    }

    public void setFailAccessCnt(int failAccessCnt) {
        this.failAccessCnt = failAccessCnt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member that = (Member)o;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.address, that.address})) {
            return this.port == that.port && StringUtils.equals((String)this.ip, (String)that.ip);
        }
        return StringUtils.equals((String)this.address, (String)that.address);
    }

    public String toString() {
        return "Member{ip='" + this.ip + '\'' + ", port=" + this.port + ", state=" + (Object)((Object)this.state) + ", extendInfo=" + this.extendInfo + '}';
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.port);
    }

    @Override
    public int compareTo(Member o) {
        return this.getAddress().compareTo(o.getAddress());
    }

    public Member copy() {
        Member copy = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            copy = (Member)ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            Loggers.CORE.warn("[Member copy] copy failed", (Throwable)e);
        }
        return copy;
    }

    public static final class MemberBuilder {
        private String ip;
        private int port;
        private NodeState state;
        private Map<String, String> extendInfo = Collections.synchronizedMap(new TreeMap());

        private MemberBuilder() {
        }

        public MemberBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public MemberBuilder port(int port) {
            this.port = port;
            return this;
        }

        public MemberBuilder state(NodeState state) {
            this.state = state;
            return this;
        }

        public MemberBuilder extendInfo(Map<String, String> extendInfo) {
            this.extendInfo.putAll(extendInfo);
            return this;
        }

        public Member build() {
            Member serverNode = new Member();
            if (Objects.nonNull(this.extendInfo)) {
                serverNode.extendInfo.putAll(this.extendInfo);
            }
            serverNode.state = this.state;
            serverNode.ip = this.ip;
            serverNode.port = this.port;
            serverNode.address = this.ip + ":" + this.port;
            return serverNode;
        }
    }
}

