/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.control.tps.nacos;

import com.alibaba.nacos.plugin.control.Loggers;
import com.alibaba.nacos.plugin.control.tps.TpsBarrier;
import com.alibaba.nacos.plugin.control.tps.request.BarrierCheckRequest;
import com.alibaba.nacos.plugin.control.tps.request.TpsCheckRequest;
import com.alibaba.nacos.plugin.control.tps.response.TpsCheckResponse;
import com.alibaba.nacos.plugin.control.tps.rule.RuleDetail;
import com.alibaba.nacos.plugin.control.tps.rule.TpsControlRule;

public class NacosTpsBarrier
extends TpsBarrier {
    public NacosTpsBarrier(String pointName) {
        super(pointName);
    }

    @Override
    public TpsCheckResponse applyTps(TpsCheckRequest tpsCheckRequest) {
        BarrierCheckRequest pointCheckRequest = new BarrierCheckRequest();
        pointCheckRequest.setCount(tpsCheckRequest.getCount());
        pointCheckRequest.setPointName(super.getPointName());
        pointCheckRequest.setTimestamp(tpsCheckRequest.getTimestamp());
        return super.getPointBarrier().applyTps(pointCheckRequest);
    }

    @Override
    public synchronized void applyRule(TpsControlRule newControlRule) {
        Loggers.CONTROL.info("Apply tps control rule start,pointName=[{}]  ", (Object)this.getPointName());
        if (newControlRule == null || newControlRule.getPointRule() == null) {
            Loggers.CONTROL.info("Clear all tps control rule ,pointName=[{}]  ", (Object)this.getPointName());
            super.getPointBarrier().clearLimitRule();
            return;
        }
        RuleDetail newPointRule = newControlRule.getPointRule();
        Loggers.CONTROL.info("Update  point  control rule ,pointName=[{}],original maxTps={}, new maxTps={},original monitorType={}, original monitorType={}, ", new Object[]{this.getPointName(), this.pointBarrier.getMaxCount(), newPointRule.getMaxCount(), this.pointBarrier.getMonitorType(), newPointRule.getMonitorType()});
        this.pointBarrier.applyRuleDetail(newPointRule);
        Loggers.CONTROL.info("Apply tps control rule end,pointName=[{}]  ", (Object)this.getPointName());
    }
}

