/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.notify;

import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.config.server.manager.TaskManager;
import com.alibaba.nacos.config.server.service.notify.HttpClientManager;
import com.alibaba.nacos.config.server.service.notify.NotifyTaskProcessor;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class NotifyService {
    public static final String NOTIFY_HEADER_LAST_MODIFIED = "lastModified";
    public static final String NOTIFY_HEADER_OP_HANDLE_IP = "opHandleIp";
    private TaskManager notifyTaskManager;

    @Autowired
    public NotifyService(ServerMemberManager memberManager) {
        this.notifyTaskManager = new TaskManager("com.alibaba.nacos.NotifyTaskManager");
        this.notifyTaskManager.setDefaultTaskProcessor(new NotifyTaskProcessor(memberManager));
    }

    protected NotifyService() {
    }

    public static RestResult<String> invokeURL(String url, List<String> headers, String encoding) throws Exception {
        Header header = Header.newInstance();
        header.addParam("Accept-Charset", encoding);
        if (CollectionUtils.isNotEmpty(headers)) {
            header.addAll(headers);
        }
        return HttpClientManager.getNacosRestTemplate().get(url, header, Query.EMPTY, String.class);
    }
}

