/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.model.app;

import com.alibaba.nacos.sys.utils.InetUtils;

public class ApplicationInfo {
    private static final long LOCK_EXPIRE_DURATION = 30000L;
    private static final long RECENTLY_DURATION = 86400000L;
    private String appName;
    private boolean isDynamicCollectDisabled = false;
    private long lastSubscribeInfoCollectedTime = 0L;
    private String subInfoCollectLockOwner = null;
    private long subInfoCollectLockExpireTime = 0L;

    public ApplicationInfo(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public boolean isDynamicCollectDisabled() {
        return this.isDynamicCollectDisabled;
    }

    public void setDynamicCollectDisabled(boolean isDynamicCollectDisabled) {
        this.isDynamicCollectDisabled = isDynamicCollectDisabled;
    }

    public long getLastSubscribeInfoCollectedTime() {
        return this.lastSubscribeInfoCollectedTime;
    }

    public void setLastSubscribeInfoCollectedTime(long lastSubscribeInfoCollectedTime) {
        this.lastSubscribeInfoCollectedTime = lastSubscribeInfoCollectedTime;
    }

    public String getSubInfoCollectLockOwner() {
        return this.subInfoCollectLockOwner;
    }

    public void setSubInfoCollectLockOwner(String subInfoCollectLockOwner) {
        this.subInfoCollectLockOwner = subInfoCollectLockOwner;
    }

    public long getSubInfoCollectLockExpireTime() {
        return this.subInfoCollectLockExpireTime;
    }

    public void setSubInfoCollectLockExpireTime(long subInfoCollectLockExpireTime) {
        this.subInfoCollectLockExpireTime = subInfoCollectLockExpireTime;
    }

    public boolean isSubInfoRecentlyCollected() {
        return System.currentTimeMillis() - this.lastSubscribeInfoCollectedTime < 86400000L;
    }

    public boolean canCurrentServerOwnTheLock() {
        boolean currentOwnerIsMe;
        boolean bl = currentOwnerIsMe = this.subInfoCollectLockOwner == null || InetUtils.getSelfIP().equals(this.subInfoCollectLockOwner);
        if (currentOwnerIsMe) {
            return true;
        }
        return System.currentTimeMillis() - this.subInfoCollectLockExpireTime > 30000L;
    }

    public String currentServer() {
        return InetUtils.getSelfIP();
    }
}

