/*
 * Decompiled with CFR 0.152.
 */
package com.yungouos.pay.wxpay;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yungouos.pay.common.PayException;
import com.yungouos.pay.config.WxPayApiConfig;
import com.yungouos.pay.entity.CodePayBiz;
import com.yungouos.pay.entity.FacePayBiz;
import com.yungouos.pay.entity.RefundOrder;
import com.yungouos.pay.entity.RefundSearch;
import com.yungouos.pay.entity.WxBillInfoBiz;
import com.yungouos.pay.entity.WxDownloadBillBiz;
import com.yungouos.pay.entity.WxOauthInfo;
import com.yungouos.pay.util.PaySignUtil;
import java.util.HashMap;

public class WxPay {
    public static CodePayBiz codePay(String out_trade_no, String total_fee, String mch_id, String body, String auth_code, String attach, String receipt, String notify_url, String config_no, String auto, String auto_node, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        CodePayBiz codePayBiz = null;
        try {
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(total_fee)) {
                throw new PayException("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(body)) {
                throw new PayException("\u5546\u54c1\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(auth_code)) {
                throw new PayException("\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u652f\u4ed8\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("out_trade_no", out_trade_no);
            params.put("total_fee", total_fee);
            params.put("mch_id", mch_id);
            params.put("body", body);
            params.put("auth_code", auth_code);
            String sign = PaySignUtil.createSign(params, key);
            if (StrUtil.isBlank(receipt)) {
                receipt = "0";
            }
            params.put("receipt", receipt);
            params.put("attach", attach);
            params.put("notify_url", notify_url);
            params.put("config_no", config_no);
            params.put("auto", auto);
            params.put("auto_node", auto_node);
            params.put("sign", sign);
            String result = HttpRequest.post(WxPayApiConfig.codePayUrl).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            JSONObject dataJson = jsonObject.getJSONObject("data");
            codePayBiz = JSON.toJavaObject(dataJson, CodePayBiz.class);
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return codePayBiz;
    }

    public static String nativePay(String out_trade_no, String total_fee, String mch_id, String body, String type, String attach, String notify_url, String return_url, String config_no, String auto, String auto_node, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String resultUrl = null;
        try {
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(total_fee)) {
                throw new PayException("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(body)) {
                throw new PayException("\u5546\u54c1\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u652f\u4ed8\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("out_trade_no", out_trade_no);
            params.put("total_fee", total_fee);
            params.put("mch_id", mch_id);
            params.put("body", body);
            String sign = PaySignUtil.createSign(params, key);
            if (StrUtil.isBlank(type)) {
                type = "2";
            }
            params.put("type", type);
            params.put("attach", attach);
            params.put("notify_url", notify_url);
            params.put("return_url", return_url);
            params.put("config_no", config_no);
            params.put("auto", auto);
            params.put("auto_node", auto_node);
            params.put("sign", sign);
            String result = HttpRequest.post(WxPayApiConfig.nativePayUrl).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            resultUrl = jsonObject.getString("data");
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return resultUrl;
    }

    public static String jsapiPay(String out_trade_no, String total_fee, String mch_id, String body, String openId, String attach, String notify_url, String return_url, String config_no, String auto, String auto_node, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String resultUrl = null;
        try {
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(total_fee)) {
                throw new PayException("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(body)) {
                throw new PayException("\u5546\u54c1\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(openId)) {
                throw new PayException("openId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u652f\u4ed8\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("out_trade_no", out_trade_no);
            params.put("total_fee", total_fee);
            params.put("mch_id", mch_id);
            params.put("body", body);
            params.put("openId", openId);
            String sign = PaySignUtil.createSign(params, key);
            params.put("attach", attach);
            params.put("notify_url", notify_url);
            params.put("return_url", return_url);
            params.put("config_no", config_no);
            params.put("auto", auto);
            params.put("auto_node", auto_node);
            params.put("sign", sign);
            String result = HttpRequest.post(WxPayApiConfig.jsapiUrl).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            resultUrl = jsonObject.getString("data");
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return resultUrl;
    }

    public static String cashierPay(String out_trade_no, String total_fee, String mch_id, String body, String attach, String notify_url, String return_url, String config_no, String auto, String auto_node, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String resultUrl = null;
        try {
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(total_fee)) {
                throw new PayException("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(body)) {
                throw new PayException("\u5546\u54c1\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u652f\u4ed8\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("out_trade_no", out_trade_no);
            params.put("total_fee", total_fee);
            params.put("mch_id", mch_id);
            params.put("body", body);
            String sign = PaySignUtil.createSign(params, key);
            params.put("attach", attach);
            params.put("notify_url", notify_url);
            params.put("return_url", return_url);
            params.put("config_no", config_no);
            params.put("auto", auto);
            params.put("auto_node", auto_node);
            params.put("sign", sign);
            String result = HttpRequest.post(WxPayApiConfig.cashierUrl).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            resultUrl = jsonObject.getString("data");
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return resultUrl;
    }

    public static JSONObject minAppPay(String out_trade_no, String total_fee, String mch_id, String body, String title, String attach, String notify_url, String config_no, String auto, String auto_node, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        JSONObject json = null;
        try {
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(total_fee)) {
                throw new PayException("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(body)) {
                throw new PayException("\u5546\u54c1\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u652f\u4ed8\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("out_trade_no", out_trade_no);
            params.put("total_fee", total_fee);
            params.put("mch_id", mch_id);
            params.put("body", body);
            String sign = PaySignUtil.createSign(params, key);
            params.put("title", title);
            params.put("attach", attach);
            params.put("notify_url", notify_url);
            params.put("config_no", config_no);
            params.put("auto", auto);
            params.put("auto_node", auto_node);
            params.put("sign", sign);
            json = (JSONObject)JSONObject.toJSON(params);
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return json;
    }

    public static JSONObject minAppPaySend(String openId, String out_trade_no, String total_fee, String mch_id, String body, String attach, String notify_url, String config_no, String auto, String auto_node, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        JSONObject json = null;
        try {
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(total_fee)) {
                throw new PayException("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(body)) {
                throw new PayException("\u5546\u54c1\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u652f\u4ed8\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("out_trade_no", out_trade_no);
            params.put("total_fee", total_fee);
            params.put("mch_id", mch_id);
            params.put("body", body);
            String sign = PaySignUtil.createSign(params, key);
            params.put("openId", openId);
            params.put("attach", attach);
            params.put("notify_url", notify_url);
            params.put("config_no", config_no);
            params.put("auto", auto);
            params.put("auto_node", auto_node);
            params.put("sign", sign);
            String result = HttpRequest.post(WxPayApiConfig.minAppPayUrl).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            json = jsonObject.getJSONObject("data");
            if (json == null) {
                throw new PayException("\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u53d1\u8d77\u5931\u8d25");
            }
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return json;
    }

    public static FacePayBiz facePay(String out_trade_no, String total_fee, String mch_id, String body, String openId, String face_code, String attach, String notify_url, String config_no, String auto, String auto_node, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        FacePayBiz facePayBiz = null;
        try {
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(total_fee)) {
                throw new PayException("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(body)) {
                throw new PayException("\u5546\u54c1\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(openId)) {
                throw new PayException("\u7528\u6237openId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(face_code)) {
                throw new PayException("\u4eba\u8138\u51ed\u8bc1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u652f\u4ed8\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("out_trade_no", out_trade_no);
            params.put("total_fee", total_fee);
            params.put("mch_id", mch_id);
            params.put("body", body);
            params.put("openId", openId);
            params.put("face_code", face_code);
            String sign = PaySignUtil.createSign(params, key);
            params.put("attach", attach);
            params.put("notify_url", notify_url);
            params.put("config_no", config_no);
            params.put("auto", auto);
            params.put("auto_node", auto_node);
            params.put("sign", sign);
            String result = HttpRequest.post(WxPayApiConfig.facePayUrl).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            JSONObject dataJson = jsonObject.getJSONObject("data");
            facePayBiz = JSON.toJavaObject(dataJson, FacePayBiz.class);
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return facePayBiz;
    }

    public static String H5Pay(String out_trade_no, String total_fee, String mch_id, String body, String attach, String notify_url, String return_url, String config_no, String auto, String auto_node, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String resultUrl = null;
        try {
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(total_fee)) {
                throw new PayException("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(body)) {
                throw new PayException("\u5546\u54c1\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u652f\u4ed8\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("out_trade_no", out_trade_no);
            params.put("total_fee", total_fee);
            params.put("mch_id", mch_id);
            params.put("body", body);
            String sign = PaySignUtil.createSign(params, key);
            params.put("attach", attach);
            params.put("notify_url", notify_url);
            params.put("return_url", return_url);
            params.put("config_no", config_no);
            params.put("auto", auto);
            params.put("auto_node", auto_node);
            params.put("sign", sign);
            String result = HttpRequest.post(WxPayApiConfig.wapPayUrl).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            resultUrl = jsonObject.getString("data");
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return resultUrl;
    }

    public static JSONObject appPay(String app_id, String out_trade_no, String total_fee, String mch_id, String body, String attach, String notify_url, String config_no, String auto, String auto_node, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        JSONObject resultJson = null;
        try {
            if (StrUtil.isBlank(app_id)) {
                throw new PayException("\u5fae\u4fe1\u5f00\u653e\u5e73\u53f0APPID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(total_fee)) {
                throw new PayException("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(body)) {
                throw new PayException("\u5546\u54c1\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u652f\u4ed8\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("app_id", app_id);
            params.put("out_trade_no", out_trade_no);
            params.put("total_fee", total_fee);
            params.put("mch_id", mch_id);
            params.put("body", body);
            String sign = PaySignUtil.createSign(params, key);
            params.put("attach", attach);
            params.put("notify_url", notify_url);
            params.put("config_no", config_no);
            params.put("auto", auto);
            params.put("auto_node", auto_node);
            params.put("sign", sign);
            String result = HttpRequest.post(WxPayApiConfig.appPayUrl).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            resultJson = jsonObject.getJSONObject("data");
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return resultJson;
    }

    public static CodePayBiz getCodePayResult(String out_trade_no, String mch_id, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        CodePayBiz codePayBiz = null;
        try {
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u652f\u4ed8\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("out_trade_no", out_trade_no);
            params.put("mch_id", mch_id);
            String sign = PaySignUtil.createSign(params, key);
            params.put("sign", sign);
            String result = HttpRequest.get(WxPayApiConfig.getCodePayResultUrl).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            JSONObject dataJson = jsonObject.getJSONObject("data");
            codePayBiz = JSON.toJavaObject(dataJson, CodePayBiz.class);
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return codePayBiz;
    }

    public static RefundOrder orderRefund(String out_trade_no, String mch_id, String money, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        RefundOrder refundOrder = null;
        try {
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(money)) {
                throw new PayException("\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u652f\u4ed8\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("out_trade_no", out_trade_no);
            params.put("mch_id", mch_id);
            params.put("money", money);
            String sign = PaySignUtil.createSign(params, key);
            params.put("sign", sign);
            String result = HttpRequest.post(WxPayApiConfig.refundOrderUrl).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            JSONObject json = jsonObject.getJSONObject("data");
            if (json == null) {
                throw new PayException("API\u7ed3\u679c\u6570\u636e\u8f6c\u6362\u9519\u8bef");
            }
            refundOrder = JSONObject.toJavaObject(json, RefundOrder.class);
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return refundOrder;
    }

    public static RefundSearch getRefundResult(String refund_no, String mch_id, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        RefundSearch refundSearch = null;
        try {
            if (StrUtil.isBlank(refund_no)) {
                throw new PayException("\u9000\u6b3e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u652f\u4ed8\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("refund_no", refund_no);
            params.put("mch_id", mch_id);
            String sign = PaySignUtil.createSign(params, key);
            params.put("sign", sign);
            String result = HttpRequest.get(WxPayApiConfig.getRefundResultUrl).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            JSONObject json = jsonObject.getJSONObject("data");
            if (json == null) {
                throw new PayException("API\u7ed3\u679c\u6570\u636e\u8f6c\u6362\u9519\u8bef");
            }
            refundSearch = JSONObject.toJavaObject(json, RefundSearch.class);
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return refundSearch;
    }

    public static WxBillInfoBiz getWxBillInfo(String mch_id, String date, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        WxBillInfoBiz wxBillInfoBiz = null;
        try {
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(date)) {
                throw new PayException("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u652f\u4ed8\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("mch_id", mch_id);
            params.put("date", date);
            String sign = PaySignUtil.createSign(params, key);
            params.put("sign", sign);
            String result = HttpRequest.get(WxPayApiConfig.getWxBillInfoUrl).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            JSONObject json = jsonObject.getJSONObject("data");
            if (json == null) {
                throw new PayException("API\u7ed3\u679c\u6570\u636e\u8f6c\u6362\u9519\u8bef");
            }
            wxBillInfoBiz = JSONObject.toJavaObject(json, WxBillInfoBiz.class);
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return wxBillInfoBiz;
    }

    public static WxDownloadBillBiz downloadBill(String mch_id, String date, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        WxDownloadBillBiz wxDownloadBillBiz = null;
        try {
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(date)) {
                throw new PayException("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u652f\u4ed8\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("mch_id", mch_id);
            params.put("date", date);
            String sign = PaySignUtil.createSign(params, key);
            params.put("sign", sign);
            String result = HttpRequest.get(WxPayApiConfig.getDownloadBillUrl).form(params).execute().body();
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            JSONObject dataJson = jsonObject.getJSONObject("data");
            if (dataJson == null) {
                return null;
            }
            wxDownloadBillBiz = JSON.toJavaObject(dataJson, WxDownloadBillBiz.class);
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return wxDownloadBillBiz;
    }

    public static void getComplaintList(String mch_id, String status, String order_no, String out_trade_no, String pay_no, String start_time, String end_time, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("mch_id", mch_id);
            String sign = PaySignUtil.createSign(params, key);
            params.put("sign", sign);
            if (!StrUtil.isBlank(status)) {
                params.put("status", status);
            }
            if (!StrUtil.isBlank(order_no)) {
                params.put("order_no", order_no);
            }
            if (!StrUtil.isBlank(out_trade_no)) {
                params.put("out_trade_no", out_trade_no);
            }
            if (!StrUtil.isBlank(pay_no)) {
                params.put("pay_no", pay_no);
            }
            if (!StrUtil.isBlank(start_time)) {
                params.put("start_time", start_time);
            }
            if (!StrUtil.isBlank(end_time)) {
                params.put("end_time", end_time);
            }
            String result = HttpRequest.get(WxPayApiConfig.getComplaintUrl).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            JSONObject jSONObject = jsonObject.getJSONObject("data");
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
    }

    public static String getWxOauthUrl(String param, String url) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String resultUrl = null;
        try {
            if (StrUtil.isBlank(url)) {
                throw new PayException("url\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("url", url);
            params.put("params", param);
            String result = HttpRequest.post(WxPayApiConfig.getWxOauthUrl).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            resultUrl = jsonObject.getString("data");
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return resultUrl;
    }

    public static WxOauthInfo getWxOauthInfo(String code) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        WxOauthInfo wxOauthInfo = null;
        try {
            if (StrUtil.isBlank(code)) {
                throw new PayException("code\u4e3a\u7a7a\uff01");
            }
            params.put("code", code);
            String result = HttpRequest.get(WxPayApiConfig.getWxOauthInfo).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer resultCode = jsonObject.getInteger("code");
            if (0 != resultCode) {
                throw new PayException(jsonObject.getString("msg"));
            }
            JSONObject json = jsonObject.getJSONObject("data");
            if (json == null) {
                throw new PayException("API\u7ed3\u679c\u6570\u636e\u8f6c\u6362\u9519\u8bef");
            }
            wxOauthInfo = JSONObject.toJavaObject(json, WxOauthInfo.class);
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return wxOauthInfo;
    }
}

