/*
 * Decompiled with CFR 0.152.
 */
package com.yungouos.pay.finance;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yungouos.pay.common.PayException;
import com.yungouos.pay.config.FinanceConfig;
import com.yungouos.pay.entity.AllocateResultBiz;
import com.yungouos.pay.entity.RePayBiz;
import com.yungouos.pay.util.PaySignUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Finance {
    public static String configV2(String mch_id, String appId, String reason, String channel, String openId, String receiver_mch_id, String name, String rate, String money, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String configNo = null;
        try {
            String result;
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(reason)) {
                throw new PayException("\u5206\u8d26\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(channel)) {
                throw new PayException("\u5206\u8d26\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            ArrayList<String> channelList = new ArrayList<String>();
            channelList.add("wxpay");
            channelList.add("alipay");
            if (!channelList.contains(channel)) {
                throw new PayException("\u5206\u8d26\u6e20\u9053\u53c2\u6570\u4e0d\u5408\u6cd5\uff01\u53c2\u8003\u503c\uff1a" + ((Object)channelList).toString());
            }
            if (StrUtil.isBlank(openId) && StrUtil.isBlank(receiver_mch_id)) {
                throw new PayException("\u5206\u8d26\u6536\u6b3e\u65b9openId\u3001\u6536\u6b3e\u5e10\u53f7\u3001\u6536\u6b3e\u5546\u6237\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
            }
            if (!StrUtil.isBlank(rate) && !NumberUtil.isNumber(rate)) {
                throw new PayException("\u5206\u8d26\u6bd4\u4f8b\u4e0d\u662f\u5408\u6cd5\u7684\u6570\u5b57\u7c7b\u578b\uff01");
            }
            if (!StrUtil.isBlank(money) && !NumberUtil.isNumber(money)) {
                throw new PayException("\u56fa\u5b9a\u5206\u8d26\u91d1\u989d\u4e0d\u662f\u5408\u6cd5\u7684\u6570\u5b57\u7c7b\u578b\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u5546\u6237\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("mch_id", mch_id);
            params.put("reason", reason);
            params.put("channel", channel);
            if (!StrUtil.isBlank(openId)) {
                params.put("openId", openId);
            }
            if (!StrUtil.isBlank(receiver_mch_id)) {
                params.put("receiver_mch_id", receiver_mch_id);
            }
            if (!StrUtil.isBlank(name)) {
                params.put("name", name);
            }
            if (!StrUtil.isBlank(rate)) {
                params.put("rate", rate);
            }
            if (!StrUtil.isBlank(money)) {
                params.put("money", money);
            }
            String sign = PaySignUtil.createSign(params, key);
            params.put("sign", sign);
            if (!StrUtil.isBlank(appId)) {
                params.put("appId", appId);
            }
            if (StrUtil.isBlank(result = HttpRequest.post(FinanceConfig.getConfigUrl).form(params).execute().body())) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            configNo = jsonObject.getString("data");
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return configNo;
    }

    @Deprecated
    public static String config(String mch_id, String reason, String channel, String openId, String account, String receiver_mch_id, String name, String rate, String money, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String configNo = null;
        try {
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(reason)) {
                throw new PayException("\u5206\u8d26\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(channel)) {
                throw new PayException("\u5206\u8d26\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            ArrayList<String> channelList = new ArrayList<String>();
            channelList.add("wxpay");
            channelList.add("alipay");
            if (!channelList.contains(channel)) {
                throw new PayException("\u5206\u8d26\u6e20\u9053\u53c2\u6570\u4e0d\u5408\u6cd5\uff01\u53c2\u8003\u503c\uff1a" + ((Object)channelList).toString());
            }
            if (StrUtil.isBlank(openId) && StrUtil.isBlank(account) && StrUtil.isBlank(receiver_mch_id)) {
                throw new PayException("\u5206\u8d26\u6536\u6b3e\u65b9openId\u3001\u6536\u6b3e\u5e10\u53f7\u3001\u6536\u6b3e\u5546\u6237\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
            }
            if (!StrUtil.isBlank(account) && StrUtil.isBlank(name)) {
                throw new PayException("\u5206\u8d26\u6536\u6b3e\u65b9\u4e3a\u5e10\u53f7\u7c7b\u578b\uff0c\u5206\u8d26\u6536\u6b3e\u65b9\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!StrUtil.isBlank(rate) && !NumberUtil.isNumber(rate)) {
                throw new PayException("\u5206\u8d26\u6bd4\u4f8b\u4e0d\u662f\u5408\u6cd5\u7684\u6570\u5b57\u7c7b\u578b\uff01");
            }
            if (!StrUtil.isBlank(money) && !NumberUtil.isNumber(money)) {
                throw new PayException("\u56fa\u5b9a\u5206\u8d26\u91d1\u989d\u4e0d\u662f\u5408\u6cd5\u7684\u6570\u5b57\u7c7b\u578b\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u5546\u6237\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("mch_id", mch_id);
            params.put("reason", reason);
            params.put("channel", channel);
            if (!StrUtil.isBlank(openId)) {
                params.put("openId", openId);
            }
            if (!StrUtil.isBlank(account)) {
                params.put("account", account);
            }
            if (!StrUtil.isBlank(receiver_mch_id)) {
                params.put("receiver_mch_id", receiver_mch_id);
            }
            if (!StrUtil.isBlank(name)) {
                params.put("name", name);
            }
            if (!StrUtil.isBlank(rate)) {
                params.put("rate", rate);
            }
            if (!StrUtil.isBlank(money)) {
                params.put("money", money);
            }
            String sign = PaySignUtil.createSign(params, key);
            params.put("sign", sign);
            String result = HttpRequest.post(FinanceConfig.getConfigUrl).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            configNo = jsonObject.getString("data");
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return configNo;
    }

    public static List<String> createBill(String mch_id, String out_trade_no, String config_no, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        List list = null;
        try {
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u5546\u6237\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("mch_id", mch_id);
            params.put("out_trade_no", out_trade_no);
            String sign = PaySignUtil.createSign(params, key);
            params.put("config_no", config_no);
            params.put("sign", sign);
            String result = HttpRequest.post(FinanceConfig.getCreateBillUrl).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            JSONArray jsonArray = jsonObject.getJSONArray("data");
            if (jsonArray != null) {
                list = JSONObject.toJavaObject(jsonArray, List.class);
            }
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return list;
    }

    public static boolean sendPay(String mch_id, String ps_no, String description, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        boolean falg = false;
        try {
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(ps_no)) {
                throw new PayException("\u5206\u8d26\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(description)) {
                throw new PayException("\u5206\u8d26\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("mch_id", mch_id);
            params.put("ps_no", ps_no);
            params.put("description", description);
            String sign = PaySignUtil.createSign(params, key);
            params.put("sign", sign);
            String result = HttpRequest.post(FinanceConfig.getSendPayUrl).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            falg = true;
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return falg;
    }

    public static AllocateResultBiz getPayResult(String mch_id, String ps_no, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        AllocateResultBiz allocateResultBiz = null;
        try {
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(ps_no)) {
                throw new PayException("\u5206\u8d26\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("mch_id", mch_id);
            params.put("ps_no", ps_no);
            String sign = PaySignUtil.createSign(params, key);
            params.put("sign", sign);
            String result = HttpRequest.get(FinanceConfig.getPayResultUrl).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            JSONObject json = (JSONObject)jsonObject.get("data");
            if (json == null) {
                throw new PayException("\u67e5\u8be2\u7ed3\u679c\u8f6c\u6362\u5931\u8d25\uff01");
            }
            allocateResultBiz = JSONObject.toJavaObject(json, AllocateResultBiz.class);
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return allocateResultBiz;
    }

    public static boolean finish(String mch_id, String out_trade_no, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        boolean flag = false;
        try {
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u5546\u6237\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("mch_id", mch_id);
            params.put("out_trade_no", out_trade_no);
            String sign = PaySignUtil.createSign(params, key);
            params.put("sign", sign);
            String result = HttpRequest.post(FinanceConfig.getFinishUrl).form(params).execute().body();
            System.out.println(result);
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            flag = true;
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return flag;
    }

    public static RePayBiz rePayWxPay(String merchant_id, String out_trade_no, String account, String account_name, String money, String desc, String mch_id, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        RePayBiz rePayBiz = null;
        try {
            String result;
            if (StrUtil.isBlank(merchant_id)) {
                throw new PayException("YunGouOS\u5546\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u5546\u6237\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(account)) {
                throw new PayException("\u6536\u6b3e\u8d26\u6237openid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(money)) {
                throw new PayException("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(desc)) {
                throw new PayException("\u4ed8\u6b3e\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("merchant_id", merchant_id);
            params.put("out_trade_no", out_trade_no);
            params.put("account", account);
            params.put("money", money);
            params.put("desc", desc);
            String sign = PaySignUtil.createSign(params, key);
            params.put("sign", sign);
            if (!StrUtil.isBlank(account_name)) {
                params.put("account_name", account_name);
            }
            if (!StrUtil.isBlank(mch_id)) {
                params.put("mch_id", mch_id);
            }
            if (StrUtil.isBlank(result = HttpRequest.post(FinanceConfig.getRePayWxPayUrl).form(params).execute().body())) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (code == null || 0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            JSONObject json = (JSONObject)jsonObject.get("data");
            if (json == null) {
                throw new PayException("\u67e5\u8be2\u7ed3\u679c\u8f6c\u6362\u5931\u8d25\uff01");
            }
            rePayBiz = JSONObject.toJavaObject(json, RePayBiz.class);
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return rePayBiz;
    }

    public static RePayBiz rePayAliPay(String merchant_id, String out_trade_no, String account, String account_name, String money, String desc, String mch_id, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        RePayBiz rePayBiz = null;
        try {
            String result;
            if (StrUtil.isBlank(merchant_id)) {
                throw new PayException("YunGouOS\u5546\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u5546\u6237\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(account)) {
                throw new PayException("\u6536\u6b3e\u652f\u4ed8\u5b9d\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(account_name)) {
                throw new PayException("\u6536\u6b3e\u652f\u4ed8\u5b9d\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(money)) {
                throw new PayException("\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(desc)) {
                throw new PayException("\u4ed8\u6b3e\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("merchant_id", merchant_id);
            params.put("out_trade_no", out_trade_no);
            params.put("account", account);
            params.put("account_name", account_name);
            params.put("money", money);
            params.put("desc", desc);
            String sign = PaySignUtil.createSign(params, key);
            params.put("sign", sign);
            if (!StrUtil.isBlank(mch_id)) {
                params.put("mch_id", mch_id);
            }
            if (StrUtil.isBlank(result = HttpRequest.post(FinanceConfig.getRePayAliPayUrl).form(params).execute().body())) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (code == null || 0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            JSONObject json = (JSONObject)jsonObject.get("data");
            if (json == null) {
                throw new PayException("\u67e5\u8be2\u7ed3\u679c\u8f6c\u6362\u5931\u8d25\uff01");
            }
            rePayBiz = JSONObject.toJavaObject(json, RePayBiz.class);
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return rePayBiz;
    }
}

