/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.impl;

import com.google.common.collect.Maps;
import com.querydsl.jpa.BatooTemplates;
import com.querydsl.jpa.DataNucleusTemplates;
import com.querydsl.jpa.EclipseLinkTemplates;
import com.querydsl.jpa.HQLTemplates;
import com.querydsl.jpa.Hibernate5Templates;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.OpenJPATemplates;
import java.util.Map;
import javax.persistence.EntityManager;

public final class JPAProvider {
    private static final Map<Class<?>, JPQLTemplates> mappings;
    private static final Map<String, JPQLTemplates> templatesByName;

    private static void addMapping(String className, JPQLTemplates templates) {
        try {
            mappings.put(Class.forName(className), templates);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static JPQLTemplates getTemplates(EntityManager em) {
        for (Map.Entry<Class<?>, JPQLTemplates> entry : mappings.entrySet()) {
            Class<?> entityManagerClass = entry.getKey();
            try {
                if (!entityManagerClass.isInstance(em.unwrap(entityManagerClass))) continue;
                return entry.getValue();
            }
            catch (Exception e) {
                if (!entityManagerClass.isAssignableFrom(em.getDelegate().getClass())) continue;
                return entry.getValue();
            }
        }
        for (String key : em.getEntityManagerFactory().getProperties().keySet()) {
            key = key.toLowerCase();
            for (Map.Entry<String, JPQLTemplates> entry : templatesByName.entrySet()) {
                if (!key.contains(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return JPQLTemplates.DEFAULT;
    }

    private JPAProvider() {
    }

    static {
        boolean hibernate5;
        mappings = Maps.newHashMap();
        templatesByName = Maps.newHashMap();
        try {
            String version = Class.forName("org.hibernate.Session").getPackage().getImplementationVersion();
            String[] versionParts = version.split("\\.");
            int major = Integer.parseInt(versionParts[0]);
            hibernate5 = major >= 5;
        }
        catch (ClassNotFoundException e) {
            hibernate5 = false;
        }
        HQLTemplates hibernateTemplates = hibernate5 ? Hibernate5Templates.DEFAULT : HQLTemplates.DEFAULT;
        JPAProvider.addMapping("org.batoo.jpa.core.impl.manager.EntityManagerImpl", BatooTemplates.DEFAULT);
        JPAProvider.addMapping("org.hibernate.Session", hibernateTemplates);
        JPAProvider.addMapping("org.hibernate.ejb.HibernateEntityManager", hibernateTemplates);
        JPAProvider.addMapping("org.hibernate.jpa.HibernateEntityManager", hibernateTemplates);
        JPAProvider.addMapping("org.eclipse.persistence.jpa.JpaEntityManager", EclipseLinkTemplates.DEFAULT);
        JPAProvider.addMapping("org.apache.openjpa.persistence.OpenJPAEntityManager", OpenJPATemplates.DEFAULT);
        JPAProvider.addMapping("org.datanucleus.jpa.EntityManagerImpl", DataNucleusTemplates.DEFAULT);
        JPAProvider.addMapping("org.datanucleus.ObjectManager", DataNucleusTemplates.DEFAULT);
        JPAProvider.addMapping("org.datanucleus.ObjectManagerImpl", DataNucleusTemplates.DEFAULT);
        templatesByName.put("batoo", BatooTemplates.DEFAULT);
        templatesByName.put("eclipselink", EclipseLinkTemplates.DEFAULT);
        templatesByName.put("hibernate", HQLTemplates.DEFAULT);
        templatesByName.put("hibernate5", Hibernate5Templates.DEFAULT);
        templatesByName.put("openjpa", OpenJPATemplates.DEFAULT);
        templatesByName.put("datanucleus", DataNucleusTemplates.DEFAULT);
    }
}

