/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaolyuh.cache.config;

import com.github.xiaolyuh.aspect.LayeringAspect;
import com.github.xiaolyuh.cache.properties.LayeringCacheProperties;
import com.github.xiaolyuh.cache.properties.LayeringCacheRedisProperties;
import com.github.xiaolyuh.manager.CacheManager;
import com.github.xiaolyuh.manager.LayeringCacheManager;
import com.github.xiaolyuh.redis.clinet.RedisClient;
import com.github.xiaolyuh.redis.clinet.RedisProperties;
import com.github.xiaolyuh.redis.serializer.AbstractRedisSerializer;
import com.github.xiaolyuh.redis.serializer.RedisSerializer;
import com.github.xiaolyuh.redis.serializer.StringRedisSerializer;
import com.github.xiaolyuh.stats.extend.CacheStatsReportService;
import com.github.xiaolyuh.stats.extend.DefaultCacheStatsReportServiceImpl;
import com.github.xiaolyuh.util.GlobalConfig;
import com.github.xiaolyuh.util.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@EnableAspectJAutoProxy
@EnableConfigurationProperties(value={LayeringCacheProperties.class, LayeringCacheRedisProperties.class})
public class LayeringCacheAutoConfig {
    @Value(value="${spring.application.name:}")
    private String applicationName;

    @Bean
    @ConditionalOnMissingBean(value={CacheManager.class})
    public CacheManager layeringCacheManager(RedisClient layeringCacheRedisClient, CacheStatsReportService cacheStatsReportService, LayeringCacheProperties layeringCacheProperties) {
        LayeringCacheManager layeringCacheManager = new LayeringCacheManager(layeringCacheRedisClient);
        layeringCacheManager.setStats(layeringCacheProperties.isStats());
        layeringCacheManager.setCacheStatsReportService(cacheStatsReportService);
        GlobalConfig.setNamespace((String)(StringUtils.isBlank((CharSequence)layeringCacheProperties.getNamespace()) ? this.applicationName : layeringCacheProperties.getNamespace()));
        return layeringCacheManager;
    }

    @Bean
    @ConditionalOnMissingBean(value={CacheStatsReportService.class})
    public CacheStatsReportService cacheStatsReportService() {
        return new DefaultCacheStatsReportServiceImpl();
    }

    @Bean
    public LayeringAspect layeringAspect() {
        return new LayeringAspect();
    }

    @Bean
    public RedisProperties redisProperties(LayeringCacheRedisProperties layeringCacheRedisProperties) {
        RedisProperties redisProperties = new RedisProperties();
        redisProperties.setDatabase(layeringCacheRedisProperties.getDatabase());
        redisProperties.setHost(layeringCacheRedisProperties.getHost());
        redisProperties.setCluster(layeringCacheRedisProperties.getCluster());
        redisProperties.setPassword(StringUtils.isBlank((CharSequence)layeringCacheRedisProperties.getPassword()) ? null : layeringCacheRedisProperties.getPassword());
        redisProperties.setPort(layeringCacheRedisProperties.getPort());
        redisProperties.setSerializer(layeringCacheRedisProperties.getSerializer());
        return redisProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisClient.class})
    public RedisClient layeringCacheRedisClient(RedisProperties redisProperties) throws Exception {
        AbstractRedisSerializer valueRedisSerializer = (AbstractRedisSerializer)Class.forName(redisProperties.getSerializer()).newInstance();
        StringRedisSerializer keyRedisSerializer = new StringRedisSerializer();
        RedisClient redisClient = RedisClient.getInstance((RedisProperties)redisProperties);
        redisClient.setKeySerializer((RedisSerializer)keyRedisSerializer);
        redisClient.setValueSerializer((RedisSerializer)valueRedisSerializer);
        return redisClient;
    }
}

