/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.heaps;

import com.carrotsearch.hppcrt.AbstractIntCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractShortCollection;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.IntContainer;
import com.carrotsearch.hppcrt.IntLookupContainer;
import com.carrotsearch.hppcrt.IntShortAssociativeContainer;
import com.carrotsearch.hppcrt.IntShortMap;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.IntCursor;
import com.carrotsearch.hppcrt.cursors.IntShortCursor;
import com.carrotsearch.hppcrt.cursors.ShortCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.IntPredicate;
import com.carrotsearch.hppcrt.predicates.IntShortPredicate;
import com.carrotsearch.hppcrt.predicates.ShortPredicate;
import com.carrotsearch.hppcrt.procedures.IntProcedure;
import com.carrotsearch.hppcrt.procedures.IntShortProcedure;
import com.carrotsearch.hppcrt.procedures.ShortProcedure;
import com.carrotsearch.hppcrt.strategies.ShortComparator;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortIndexedHeapPriorityQueue
implements IntShortMap,
Cloneable {
    public short[] buffer;
    public int[] pq;
    protected int[] qp;
    protected int elementsCount;
    protected ShortComparator comparator;
    protected short defaultValue = 0;
    protected final IteratorPool<IntShortCursor, EntryIterator> entryIteratorPool;

    public ShortIndexedHeapPriorityQueue(ShortComparator comp, int initialCapacity) {
        this.comparator = comp;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

            @Override
            public EntryIterator create() {
                return new EntryIterator();
            }

            @Override
            public void initialize(EntryIterator obj) {
                obj.cursor.index = 0;
                EntryIterator.access$002(obj, ShortIndexedHeapPriorityQueue.this.buffer);
                obj.size = ShortIndexedHeapPriorityQueue.this.elementsCount;
                EntryIterator.access$202(obj, ShortIndexedHeapPriorityQueue.this.qp);
            }

            @Override
            public void reset(EntryIterator obj) {
                EntryIterator.access$202(obj, null);
                EntryIterator.access$002(obj, null);
            }
        });
    }

    public ShortIndexedHeapPriorityQueue(ShortComparator comp) {
        this(comp, 8);
    }

    public ShortIndexedHeapPriorityQueue() {
        this(null, 8);
    }

    public ShortIndexedHeapPriorityQueue(int initialCapacity) {
        this(null, initialCapacity);
    }

    public ShortIndexedHeapPriorityQueue(IntShortAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    public static ShortIndexedHeapPriorityQueue from(IntShortAssociativeContainer container) {
        return new ShortIndexedHeapPriorityQueue(container);
    }

    public static ShortIndexedHeapPriorityQueue from(int[] keys, short[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortIndexedHeapPriorityQueue heap = new ShortIndexedHeapPriorityQueue(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            heap.put(keys[i], values[i]);
        }
        return heap;
    }

    @Override
    public void clear() {
        Arrays.fill(this.pq, 0);
        this.elementsCount = 0;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public int capacity() {
        return this.buffer.length - 1;
    }

    @Override
    public <T extends IntShortProcedure> T forEach(T procedure) {
        short[] buffer = this.buffer;
        int[] qp = this.qp;
        int size = this.elementsCount;
        for (int pos = 1; pos <= size; ++pos) {
            procedure.apply(qp[pos], buffer[pos]);
        }
        return procedure;
    }

    @Override
    public <T extends IntShortPredicate> T forEach(T predicate) {
        short[] buffer = this.buffer;
        int[] qp = this.qp;
        int size = this.elementsCount;
        for (int pos = 1; pos <= size && predicate.apply(qp[pos], buffer[pos]); ++pos) {
        }
        return predicate;
    }

    @Override
    public boolean isEmpty() {
        return this.elementsCount == 0;
    }

    @Override
    public int removeAll(IntContainer container) {
        int before = this.elementsCount;
        for (IntCursor cursor : container) {
            this.remove(cursor.value);
        }
        return before - this.elementsCount;
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        int[] pq = this.pq;
        int size = this.pq.length;
        int initialSize = this.elementsCount;
        for (int key = 0; key < size; ++key) {
            if (pq[key] <= 0 || !predicate.apply(key)) continue;
            this.remove(key);
        }
        return initialSize - this.elementsCount;
    }

    @Override
    public int removeAll(IntShortPredicate predicate) {
        short[] buffer = this.buffer;
        int[] pq = this.pq;
        int size = this.elementsCount;
        int initialSize = this.elementsCount;
        for (int key = 0; key < size; ++key) {
            int pos = pq[key];
            if (pos <= 0 || !predicate.apply(key, buffer[pos])) continue;
            this.remove(key);
        }
        return initialSize - this.elementsCount;
    }

    @Override
    public boolean putIfAbsent(int key, short value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public int putAll(IntShortAssociativeContainer container) {
        return this.putAll((Iterable<? extends IntShortCursor>)container);
    }

    @Override
    public int putAll(Iterable<? extends IntShortCursor> iterable) {
        int count = this.elementsCount;
        for (IntShortCursor intShortCursor : iterable) {
            this.put(intShortCursor.key, intShortCursor.value);
        }
        return this.elementsCount - count;
    }

    @Override
    public short put(int key, short element) {
        assert (key >= 0) : "Keys must be >= 0, but is " + key;
        if (key < this.pq.length && this.pq[key] > 0) {
            short previousValue = this.buffer[this.pq[key]];
            this.buffer[this.pq[key]] = element;
            this.sink(this.pq[key]);
            this.swim(this.pq[key]);
            return previousValue;
        }
        this.ensureBufferSpace(key);
        ++this.elementsCount;
        int count = this.elementsCount;
        this.buffer[count] = element;
        this.pq[key] = count;
        this.qp[count] = key;
        this.swim(count);
        return this.defaultValue;
    }

    @Override
    public short putOrAdd(int key, short putValue, short incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue = (short)(putValue + incrementValue);
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public short addTo(int key, short incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    public short top() {
        short elem = this.defaultValue;
        if (this.elementsCount > 0) {
            elem = this.buffer[1];
        }
        return elem;
    }

    public int topKey() {
        int key = -1;
        if (this.elementsCount > 0) {
            key = this.qp[1];
        }
        return key;
    }

    public short popTop() {
        short elem = this.defaultValue;
        if (this.elementsCount > 0) {
            elem = this.buffer[1];
            this.remove(this.qp[1]);
        }
        return elem;
    }

    @Override
    public short get(int key) {
        short elem = this.defaultValue;
        if (key < this.pq.length && this.pq[key] > 0) {
            elem = this.buffer[this.pq[key]];
        }
        return elem;
    }

    @Override
    public short remove(int key) {
        short deletedElement = this.defaultValue;
        int[] qp = this.qp;
        int[] pq = this.pq;
        short[] buffer = this.buffer;
        if (key < pq.length && pq[key] > 0) {
            int deletedPos = pq[key];
            deletedElement = buffer[deletedPos];
            if (deletedPos == this.elementsCount) {
                pq[key] = 0;
                --this.elementsCount;
            } else {
                int lastElementIndex = qp[this.elementsCount];
                buffer[deletedPos] = buffer[this.elementsCount];
                pq[lastElementIndex] = deletedPos;
                qp[deletedPos] = lastElementIndex;
                pq[key] = 0;
                --this.elementsCount;
                if (this.elementsCount > 1) {
                    this.sink(pq[lastElementIndex]);
                    this.swim(pq[lastElementIndex]);
                }
            }
        }
        return deletedElement;
    }

    public void updatePriority(int key) {
        if (key < this.pq.length && this.pq[key] > 0) {
            this.swim(this.pq[key]);
            this.sink(this.pq[key]);
        }
    }

    public void updateTopPriority() {
        if (this.elementsCount > 1) {
            this.sink(1);
        }
    }

    @Override
    public boolean containsKey(int key) {
        return key < this.pq.length && this.pq[key] > 0;
    }

    public int hashCode() {
        int h = 1;
        int size = this.pq.length;
        short[] buffer = this.buffer;
        int[] pq = this.pq;
        for (int index = 0; index < size; ++index) {
            if (pq[index] <= 0) continue;
            h = 31 * h + BitMixer.mix(index);
            h = 31 * h + BitMixer.mix(buffer[pq[index]]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ShortIndexedHeapPriorityQueue other = (ShortIndexedHeapPriorityQueue)obj;
            if (other.size() != this.size()) {
                return false;
            }
            if (!(this.comparator == null && other.comparator == null || this.comparator != null && this.comparator.equals(other.comparator))) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                IntShortCursor c = (IntShortCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                short mineValue = c.value;
                short otherValue = other.get(c.key);
                if (mineValue == otherValue) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public ShortIndexedHeapPriorityQueue clone() {
        ShortIndexedHeapPriorityQueue cloned = new ShortIndexedHeapPriorityQueue(this.comparator, 8);
        cloned.buffer = (short[])this.buffer.clone();
        cloned.pq = (int[])this.pq.clone();
        cloned.qp = (int[])this.qp.clone();
        cloned.defaultValue = this.defaultValue;
        cloned.elementsCount = this.elementsCount;
        return cloned;
    }

    public void updatePriorities() {
        if (this.comparator == null) {
            for (int k = this.elementsCount >> 1; k >= 1; --k) {
                this.sinkComparable(k);
            }
        } else {
            for (int k = this.elementsCount >> 1; k >= 1; --k) {
                this.sinkComparator(k);
            }
        }
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public String toString() {
        short[] buffer = this.buffer;
        int[] pq = this.pq;
        StringBuilder buff = new StringBuilder();
        buff.append("[");
        boolean first = true;
        for (int i = 0; i < pq.length; ++i) {
            if (pq[i] <= 0) continue;
            if (!first) {
                buff.append(", ");
            }
            buff.append(i);
            buff.append("=>");
            buff.append(buffer[pq[i]]);
            first = false;
        }
        buff.append("]");
        return buff.toString();
    }

    @Override
    public short getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(short defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ShortComparator comparator() {
        return this.comparator;
    }

    protected void ensureBufferSpace(int index) {
        int pqLen;
        int n = pqLen = this.pq == null ? 0 : this.pq.length;
        if (index > pqLen - 1) {
            int newPQSize = Math.max(index + 8, (int)((double)index * 1.5));
            try {
                int[] newPQIndex = new int[newPQSize];
                short[] newBuffer = new short[newPQSize + 1];
                int[] newQPIndex = new int[newPQSize + 1];
                if (pqLen > 0) {
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                    System.arraycopy(this.pq, 0, newPQIndex, 0, this.pq.length);
                    System.arraycopy(this.qp, 0, newQPIndex, 0, this.qp.length);
                }
                this.buffer = newBuffer;
                this.pq = newPQIndex;
                this.qp = newQPIndex;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, pqLen, newPQSize);
            }
        }
    }

    private void sinkComparable(int k) {
        int N = this.elementsCount;
        short[] buffer = this.buffer;
        int[] pq = this.pq;
        int[] qp = this.qp;
        while (k << 1 <= N) {
            int child = k << 1;
            if (child < N && buffer[child] > buffer[child + 1]) {
                ++child;
            }
            if (buffer[k] <= buffer[child]) break;
            short tmp = buffer[k];
            buffer[k] = buffer[child];
            buffer[child] = tmp;
            int indexK = qp[k];
            int indexChild = qp[child];
            pq[indexK] = child;
            pq[indexChild] = k;
            qp[k] = indexChild;
            qp[child] = indexK;
            k = child;
        }
    }

    private void sinkComparator(int k) {
        int N = this.elementsCount;
        short[] buffer = this.buffer;
        int[] pq = this.pq;
        int[] qp = this.qp;
        ShortComparator comp = this.comparator;
        while (k << 1 <= N) {
            int child = k << 1;
            if (child < N && comp.compare(buffer[child], buffer[child + 1]) > 0) {
                ++child;
            }
            if (comp.compare(buffer[k], buffer[child]) <= 0) break;
            short tmp = buffer[k];
            buffer[k] = buffer[child];
            buffer[child] = tmp;
            int indexK = qp[k];
            int indexChild = qp[child];
            pq[indexK] = child;
            pq[indexChild] = k;
            qp[k] = indexChild;
            qp[child] = indexK;
            k = child;
        }
    }

    private void swimComparable(int k) {
        short[] buffer = this.buffer;
        int[] pq = this.pq;
        int[] qp = this.qp;
        while (k > 1 && buffer[k >> 1] > buffer[k]) {
            int parent = k >> 1;
            short tmp = buffer[k];
            buffer[k] = buffer[parent];
            buffer[parent] = tmp;
            int indexK = qp[k];
            int indexParent = qp[parent];
            pq[indexK] = parent;
            pq[indexParent] = k;
            qp[k] = indexParent;
            qp[parent] = indexK;
            k = parent;
        }
    }

    private void swimComparator(int k) {
        short[] buffer = this.buffer;
        int[] pq = this.pq;
        int[] qp = this.qp;
        ShortComparator comp = this.comparator;
        while (k > 1 && comp.compare(buffer[k >> 1], buffer[k]) > 0) {
            int parent = k >> 1;
            short tmp = buffer[k];
            buffer[k] = buffer[parent];
            buffer[parent] = tmp;
            int indexK = qp[k];
            int indexParent = qp[parent];
            pq[indexK] = parent;
            pq[indexParent] = k;
            qp[k] = indexParent;
            qp[parent] = indexK;
            k = parent;
        }
    }

    private void swim(int k) {
        if (this.comparator == null) {
            this.swimComparable(k);
        } else {
            this.swimComparator(k);
        }
    }

    private void sink(int k) {
        if (this.comparator == null) {
            this.sinkComparable(k);
        } else {
            this.sinkComparator(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeAllInternal(ShortPredicate predicate) {
        int deleted = 0;
        short[] buffer = this.buffer;
        int[] qp = this.qp;
        int[] pq = this.pq;
        int lastElementIndex = -1;
        int elementsCount = this.elementsCount;
        int pos = 1;
        try {
            while (pos <= elementsCount) {
                if (predicate.apply(buffer[pos])) {
                    lastElementIndex = qp[elementsCount];
                    buffer[pos] = buffer[elementsCount];
                    pq[lastElementIndex] = pos;
                    pq[qp[pos]] = 0;
                    qp[pos] = lastElementIndex;
                    --elementsCount;
                    ++deleted;
                    continue;
                }
                ++pos;
            }
        }
        finally {
            this.elementsCount = elementsCount;
            this.updatePriorities();
        }
        return deleted;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<ShortCursor> {
        public final ShortCursor cursor = new ShortCursor();
        private short[] buffer;
        private int size;

        public ValuesIterator() {
            this.cursor.index = 0;
            this.buffer = ShortIndexedHeapPriorityQueue.this.buffer;
            this.size = ShortIndexedHeapPriorityQueue.this.size();
        }

        @Override
        protected ShortCursor fetch() {
            if (this.cursor.index == this.size) {
                return (ShortCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }

        static /* synthetic */ short[] access$602(ValuesIterator x0, short[] x1) {
            x0.buffer = x1;
            return x1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractShortCollection {
        private final ShortIndexedHeapPriorityQueue owner;
        private short currentOccurenceToBeRemoved;
        private final ShortPredicate removeAllOccurencesPredicate;
        protected final IteratorPool<ShortCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = ShortIndexedHeapPriorityQueue.this;
            this.removeAllOccurencesPredicate = new ShortPredicate(){

                public final boolean apply(short value) {
                    return value == ValuesCollection.this.currentOccurenceToBeRemoved;
                }
            };
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = 0;
                    ValuesIterator.access$602(obj, ShortIndexedHeapPriorityQueue.this.buffer);
                    obj.size = ShortIndexedHeapPriorityQueue.this.size();
                }

                @Override
                public void reset(ValuesIterator obj) {
                    ValuesIterator.access$602(obj, null);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(short value) {
            short[] buffer = this.owner.buffer;
            int size = this.owner.elementsCount;
            for (int pos = 1; pos <= size; ++pos) {
                if (buffer[pos] != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            short[] buffer = this.owner.buffer;
            int size = this.owner.elementsCount;
            for (int pos = 1; pos <= size; ++pos) {
                procedure.apply(buffer[pos]);
            }
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            short[] buffer = this.owner.buffer;
            int size = this.owner.elementsCount;
            for (int pos = 1; pos <= size && predicate.apply(buffer[pos]); ++pos) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(short e) {
            this.currentOccurenceToBeRemoved = e;
            return this.owner.removeAllInternal(this.removeAllOccurencesPredicate);
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            return this.owner.removeAllInternal(predicate);
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public short[] toArray(short[] target) {
            System.arraycopy(this.owner.buffer, 1, target, 0, this.owner.elementsCount);
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<IntCursor> {
        public final IntCursor cursor = new IntCursor();
        private int[] pq;

        public KeysIterator() {
            this.cursor.value = -1;
            this.pq = ShortIndexedHeapPriorityQueue.this.pq;
        }

        @Override
        protected IntCursor fetch() {
            int i;
            for (i = this.cursor.value + 1; i < this.pq.length && this.pq[i] <= 0; ++i) {
            }
            if (i == this.pq.length) {
                return (IntCursor)this.done();
            }
            this.cursor.value = i;
            this.cursor.index = this.pq[i];
            return this.cursor;
        }

        static /* synthetic */ int[] access$302(KeysIterator x0, int[] x1) {
            x0.pq = x1;
            return x1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final ShortIndexedHeapPriorityQueue owner;
        protected final IteratorPool<IntCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = ShortIndexedHeapPriorityQueue.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.value = -1;
                    KeysIterator.access$302(obj, ShortIndexedHeapPriorityQueue.this.pq);
                }

                @Override
                public void reset(KeysIterator obj) {
                    KeysIterator.access$302(obj, null);
                }
            });
        }

        @Override
        public boolean contains(int e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            int[] qp = this.owner.qp;
            int size = this.owner.elementsCount;
            for (int pos = 1; pos <= size; ++pos) {
                procedure.apply(qp[pos]);
            }
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            int[] qp = this.owner.qp;
            int size = this.owner.elementsCount;
            for (int pos = 1; pos <= size && predicate.apply(qp[pos]); ++pos) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(int e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public int[] toArray(int[] target) {
            int count = 0;
            int[] pq = this.owner.pq;
            int size = this.owner.pq.length;
            for (int key = 0; key < size; ++key) {
                if (pq[key] <= 0) continue;
                target[count] = key;
                ++count;
            }
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<IntShortCursor> {
        public final IntShortCursor cursor = new IntShortCursor();
        private short[] buffer;
        private int size;
        private int[] qp;

        public EntryIterator() {
            this.cursor.index = 0;
            this.buffer = ShortIndexedHeapPriorityQueue.this.buffer;
            this.size = ShortIndexedHeapPriorityQueue.this.size();
            this.qp = ShortIndexedHeapPriorityQueue.this.qp;
        }

        @Override
        protected IntShortCursor fetch() {
            if (this.cursor.index == this.size) {
                return (IntShortCursor)this.done();
            }
            this.cursor.key = this.qp[++this.cursor.index];
            this.cursor.value = this.buffer[this.cursor.index];
            return this.cursor;
        }

        static /* synthetic */ short[] access$002(EntryIterator x0, short[] x1) {
            x0.buffer = x1;
            return x1;
        }

        static /* synthetic */ int[] access$202(EntryIterator x0, int[] x1) {
            x0.qp = x1;
            return x1;
        }
    }
}

