/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.toolkit;

import com.anwen.mongo.domain.InitMongoCollectionException;
import com.anwen.mongo.logging.Log;
import com.anwen.mongo.logging.LogFactory;
import com.anwen.mongo.model.BaseProperty;
import com.anwen.mongo.toolkit.IPAddressUtil;
import com.anwen.mongo.toolkit.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class UrlJoint {
    private static final Log log = LogFactory.getLog(UrlJoint.class);
    private final BaseProperty baseProperty;
    StringBuilder uri = new StringBuilder("mongodb://");

    public UrlJoint(BaseProperty baseProperty) {
        this.baseProperty = baseProperty;
    }

    public String jointMongoUrl() {
        String mongodbUrl;
        if (StringUtils.isNotBlank(this.baseProperty.getUrl())) {
            return this.baseProperty.getUrl();
        }
        if (StringUtils.isNotBlank(this.baseProperty.getUsername()) && StringUtils.isNotBlank(this.baseProperty.getPassword())) {
            try {
                this.baseProperty.setUsername(URLEncoder.encode(this.baseProperty.getUsername(), "UTF-8"));
                this.baseProperty.setPassword(URLEncoder.encode(this.baseProperty.getPassword(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage());
                throw new RuntimeException(e);
            }
            this.uri.append(this.baseProperty.getUsername()).append(":").append(this.baseProperty.getPassword()).append("@");
        }
        if (StringUtils.isNotBlank(this.baseProperty.getHost()) && StringUtils.isNotBlank(this.baseProperty.getPort())) {
            if (this.baseProperty.getHost().contains(",")) {
                String[] portArray;
                String[] hostArray = this.baseProperty.getHost().split(",");
                if (hostArray.length != (portArray = this.baseProperty.getPort().split(",")).length && portArray.length > 1) {
                    throw new InitMongoCollectionException("Host and port do not match");
                }
                for (int i = 0; i < hostArray.length; ++i) {
                    String host = hostArray[i];
                    this.uri.append(host).append(":").append(portArray.length > 1 ? portArray[i] : portArray[0]).append(",");
                }
                this.uri.deleteCharAt(this.uri.length() - 1);
            } else {
                this.uri.append(this.baseProperty.getHost()).append(":").append(this.baseProperty.getPort());
            }
            this.uri.append("/");
            if (StringUtils.isNotBlank(this.baseProperty.getAuthenticationDatabase())) {
                this.uri.append(this.baseProperty.getAuthenticationDatabase());
            }
        }
        if (this.baseProperty.getMinPoolSize() != null) {
            this.uri.append("?minPoolSize=").append(this.baseProperty.getMinPoolSize());
        }
        if (this.baseProperty.getMaxPoolSize() != null) {
            this.uri.append("&maxPoolSize=").append(this.baseProperty.getMaxPoolSize());
        }
        if (this.baseProperty.getWaitQueueTimeoutMS() != null) {
            this.uri.append("&waitQueueTimeoutMS=").append(this.baseProperty.getWaitQueueTimeoutMS());
        }
        if (this.baseProperty.getServerSelectionTimeoutMS() != null) {
            this.uri.append("&serverSelectionTimeoutMS=").append(this.baseProperty.getServerSelectionTimeoutMS());
        }
        if (this.baseProperty.getLocalThresholdMS() != null) {
            this.uri.append("&localThresholdMS=").append(this.baseProperty.getLocalThresholdMS());
        }
        if (this.baseProperty.getHeartbeatFrequencyMS() != null) {
            this.uri.append("&heartbeatFrequencyMS=").append(this.baseProperty.getHeartbeatFrequencyMS());
        }
        if (this.baseProperty.getReplicaSet() != null) {
            this.uri.append("&replicaSet=").append(this.baseProperty.getReplicaSet());
        }
        if (this.baseProperty.getSsl() != null) {
            this.uri.append("&ssl=").append(this.baseProperty.getSsl());
        }
        if (this.baseProperty.getTls() != null) {
            this.uri.append("&tls=").append(this.baseProperty.getTls());
        }
        if (this.baseProperty.getTlsInsecure() != null) {
            this.uri.append("&tlsInsecure=").append(this.baseProperty.getTlsInsecure());
        }
        if (this.baseProperty.getTlsAllowInvalidHostnames() != null) {
            this.uri.append("&tlsAllowInvalidHostnames=").append(this.baseProperty.getTlsAllowInvalidHostnames());
        }
        if (this.baseProperty.getConnectTimeoutMS() != null) {
            this.uri.append("&connectTimeoutMS=").append(this.baseProperty.getConnectTimeoutMS());
        }
        if (this.baseProperty.getSocketTimeoutMS() != null) {
            this.uri.append("&socketTimeoutMS=").append(this.baseProperty.getSocketTimeoutMS());
        }
        if (this.baseProperty.getMaxIdleTimeMS() != null) {
            this.uri.append("&maxIdleTimeMS=").append(this.baseProperty.getMaxIdleTimeMS());
        }
        if (this.baseProperty.getMaxLifeTimeMS() != null) {
            this.uri.append("&maxLifeTimeMS=").append(this.baseProperty.getMaxLifeTimeMS());
        }
        if (this.baseProperty.getJournal() != null) {
            this.uri.append("&journal=").append(this.baseProperty.getJournal());
        }
        if (this.baseProperty.getW() != null) {
            this.uri.append("&w=").append(this.baseProperty.getW());
        }
        if (this.baseProperty.getWtimeoutMS() != null) {
            this.uri.append("&wtimeoutMS=").append(this.baseProperty.getWtimeoutMS());
        }
        if (this.baseProperty.getReadPreference() != null) {
            this.uri.append("&readPreference=").append(this.baseProperty.getReadPreference());
        }
        if (this.baseProperty.getReadPreferenceTags() != null) {
            this.uri.append("&readPreferenceTags=").append(this.baseProperty.getReadPreferenceTags());
        }
        if (this.baseProperty.getMaxStalenessSeconds() != null) {
            this.uri.append("&maxStalenessSeconds=").append(this.baseProperty.getMaxStalenessSeconds());
        }
        if (this.baseProperty.getAuthMechanism() != null) {
            this.uri.append("&authMechanism=").append(this.baseProperty.getAuthMechanism());
        }
        if (this.baseProperty.getAuthSource() != null) {
            this.uri.append("&authSource=").append(this.baseProperty.getAuthSource());
        }
        if (this.baseProperty.getAuthMechanismProperties() != null) {
            this.uri.append("&authMechanismProperties=").append(this.baseProperty.getAuthMechanismProperties());
        }
        if (this.baseProperty.getAppName() != null) {
            this.uri.append("&appName=").append(this.baseProperty.getAppName());
        }
        if (this.baseProperty.getCompressors() != null) {
            this.uri.append("&compressors=").append(this.baseProperty.getCompressors());
        }
        if (this.baseProperty.getZlibCompressionLevel() != null) {
            this.uri.append("&zlibCompressionLevel=").append(this.baseProperty.getZlibCompressionLevel());
        }
        if (this.baseProperty.getRetryWrites() != null) {
            this.uri.append("&retryWrites=").append(this.baseProperty.getRetryWrites());
        }
        if (this.baseProperty.getRetryReads() != null) {
            this.uri.append("&retryReads=").append(this.baseProperty.getRetryReads());
        }
        if (this.baseProperty.getUuidRepresentation() != null) {
            this.uri.append("&uuidRepresentation=").append(this.baseProperty.getUuidRepresentation());
        }
        if (this.baseProperty.getDirectConnection() != null) {
            this.uri.append("&directConnection=").append(this.baseProperty.getDirectConnection());
        }
        if (this.baseProperty.getMaxConnecting() != null) {
            this.uri.append("&maxConnecting=").append(this.baseProperty.getMaxConnecting());
        }
        if (this.baseProperty.getSrvServiceName() != null) {
            this.uri.append("&srvServiceName=").append(this.baseProperty.getSrvServiceName());
        }
        if (!(mongodbUrl = this.uri.toString()).contains("?")) {
            mongodbUrl = mongodbUrl.replaceFirst("&", "?");
        }
        log.info(String.format("get connected\uff1a%s", IPAddressUtil.maskSensitiveInfo(mongodbUrl)));
        return mongodbUrl;
    }
}

