/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.toolkit;

import com.anwen.mongo.domain.MongoPlusConvertException;
import com.anwen.mongo.logging.Log;
import com.anwen.mongo.logging.LogFactory;
import com.anwen.mongo.toolkit.ClassTypeUtil;
import com.anwen.mongo.toolkit.StringEscape;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class StringUtils {
    static Log log = LogFactory.getLog(StringUtils.class);
    public static final String IS = "is";
    public static final int INDEX_NOT_FOUND = -1;
    public static final char UNDERLINE = '_';
    public static final Pattern MP_SQL_PLACE_HOLDER = Pattern.compile("[{](?<idx>\\d+)}");
    private static final Pattern P_IS_COLUMN = Pattern.compile("^\\w\\S*[\\w\\d]*$");
    private static final Pattern CAPITAL_MODE = Pattern.compile("^[0-9A-Z/_]+$");
    private static final Pattern REPLACE_BLANK = Pattern.compile("\\s*|\t|\r|\n");

    public static boolean isBlank(CharSequence cs) {
        if (cs != null) {
            int length = cs.length();
            for (int i = 0; i < length; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static String toStringTrim(Object o) {
        return String.valueOf(o).trim();
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static String isNotBlankAndConvert(Object value) {
        try {
            String str = String.valueOf(value);
            if (StringUtils.isBlank(str)) {
                throw new MongoPlusConvertException("value is empty");
            }
            return str;
        }
        catch (Exception e) {
            log.warn("Conversion to String failed, reason for failure: {}", e.getMessage());
            throw new MongoPlusConvertException("Conversion to String failed");
        }
    }

    public static boolean hasLength(String str) {
        return str != null && !str.isEmpty();
    }

    public static boolean hasText(String str) {
        return str != null && !StringUtils.isBlank(str);
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        if (str.equals("null")) {
            return true;
        }
        int len = str.length();
        if (len == 0) {
            return true;
        }
        block3: for (int i = 0; i < len; ++i) {
            switch (str.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static String firstCharToLowerCase(String str) {
        return StringUtils.changeFirstCharCase(str, false);
    }

    public static String firstCharToUpperCase(String str) {
        return StringUtils.changeFirstCharCase(str, true);
    }

    private static String changeFirstCharCase(String str, boolean capitalize) {
        char updatedChar;
        if (str == null || str.isEmpty()) {
            return str;
        }
        char baseChar = str.charAt(0);
        if (baseChar == (updatedChar = capitalize ? Character.toUpperCase(baseChar) : Character.toLowerCase(baseChar))) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = updatedChar;
        return new String(chars);
    }

    public static String hide(CharSequence str, int startInclude, int endExclude) {
        return StringUtils.replace(str, startInclude, endExclude, '*');
    }

    public static String repeat(char c, int count) {
        if (count <= 0) {
            return "";
        }
        char[] result = new char[count];
        Arrays.fill(result, c);
        return new String(result);
    }

    public static String cleanBlank(CharSequence str) {
        return StringUtils.filter(str, c -> !StringUtils.isBlankChar(c.charValue()));
    }

    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234 || c == 0 || c == 12644 || c == 10240 || c == 6158;
    }

    public static String filter(CharSequence str, Function<Character, Boolean> filter) {
        if (str == null || filter == null) {
            return StringUtils.str(str);
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (!filter.apply(Character.valueOf(c)).booleanValue()) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String subBefore(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (StringUtils.isEmpty(string)) {
            return null == string ? null : "";
        }
        String str = string.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return "";
        }
        return str.substring(0, pos);
    }

    public static int containCount(String src, int from, int to, char[] targets) {
        int count = 0;
        if (src != null) {
            from = Math.max(from, 0);
            to = Math.min(to, src.length());
            for (int i = from; i < to; ++i) {
                char c = src.charAt(i);
                boolean contained = false;
                for (char target : targets) {
                    if (c != target) continue;
                    contained = true;
                    break;
                }
                if (!contained) continue;
                ++count;
            }
        }
        return count;
    }

    public static String toHyphenation(String src, String hyphenation) {
        StringBuilder sb = new StringBuilder(src);
        int cnt = 0;
        for (int i = 1; i < src.length(); ++i) {
            if (!Character.isUpperCase(src.charAt(i))) continue;
            sb.insert(i + cnt, hyphenation);
            cnt += hyphenation.length();
        }
        return sb.toString().toLowerCase();
    }

    public static String toUnderline(String src) {
        return StringUtils.toHyphenation(src, "_");
    }

    public static boolean sqlContains(String sql, String column) {
        int cLen = column.length();
        int idx = sql.indexOf(column);
        while (idx >= 0) {
            if (idx > 0 && StringUtils.isSqlColumnChar(sql.charAt(idx - 1))) {
                idx = sql.indexOf(column, idx + cLen);
                continue;
            }
            int endIdx = idx + cLen;
            if (endIdx < sql.length() && StringUtils.isSqlColumnChar(sql.charAt(endIdx))) {
                idx = sql.indexOf(column, idx + cLen);
                continue;
            }
            return true;
        }
        return false;
    }

    public static boolean isSqlColumnChar(char c) {
        return 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '_';
    }

    public static int indexOf(CharSequence seq, CharSequence searchSeq) {
        if (seq == null || searchSeq == null) {
            return -1;
        }
        return StringUtils.indexOf(seq, searchSeq, 0);
    }

    public static int indexOf(CharSequence cs, CharSequence searchChar, int start) {
        return cs.toString().indexOf(searchChar.toString(), start);
    }

    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        if (ignoreCase) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return str1.toString().contentEquals(str2);
    }

    public static int countOf(String str, char target) {
        if (str == null) {
            return 0;
        }
        int count = 0;
        int index = str.indexOf(target);
        while (index >= 0 && index < str.length()) {
            index = str.indexOf(target, index + 1);
            ++count;
        }
        return count;
    }

    public static boolean isCamel(String str) {
        return Character.isLowerCase(str.charAt(0)) && !str.contains("_");
    }

    public static boolean isNotColumnName(String str) {
        return !P_IS_COLUMN.matcher(str).matches();
    }

    public static String getTargetColumn(String column) {
        if (StringUtils.isNotColumnName(column)) {
            return column.substring(1, column.length() - 1);
        }
        return column;
    }

    public static String camelToUnderline(String param) {
        if (StringUtils.isBlank(param)) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String underlineToCamel(String param) {
        if (StringUtils.isBlank(param)) {
            return "";
        }
        String temp = param.toLowerCase();
        int len = temp.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = temp.charAt(i);
            if (c == '_') {
                if (++i >= len) continue;
                sb.append(Character.toUpperCase(temp.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String convertToCamelCase(String str) {
        if (Objects.equals(str, "_id")) {
            return str;
        }
        return Arrays.stream(str.split("_")).reduce((s1, s2) -> s1 + s2.substring(0, 1).toUpperCase() + s2.substring(1)).orElse("");
    }

    public static String convertCamelToUnderscore(String camelCaseString) {
        if (camelCaseString == null || camelCaseString.isEmpty()) {
            return camelCaseString;
        }
        return IntStream.range(0, camelCaseString.length()).mapToObj(i -> {
            char c = camelCaseString.charAt(i);
            if (Character.isUpperCase(c)) {
                return (i > 0 ? "_" : "") + Character.toLowerCase(c);
            }
            return String.valueOf(c);
        }).collect(Collectors.joining());
    }

    public static boolean matches(String regex, String input) {
        if (null == regex || null == input) {
            return false;
        }
        return Pattern.matches(regex, input);
    }

    public static String replace(CharSequence str, int startInclude, int endExclude, char replacedChar) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.str(str);
        }
        String originalStr = StringUtils.str(str);
        int[] strCodePoints = originalStr.codePoints().toArray();
        int strLength = strCodePoints.length;
        if (startInclude > strLength) {
            return originalStr;
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return originalStr;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < strLength; ++i) {
            if (i >= startInclude && i < endExclude) {
                stringBuilder.append(replacedChar);
                continue;
            }
            stringBuilder.append(new String(strCodePoints, i, 1));
        }
        return stringBuilder.toString();
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static String sqlParam(Object obj) {
        String repStr = obj instanceof Collection ? StringUtils.quotaMarkList((Collection)obj) : StringUtils.quotaMark(obj);
        return repStr;
    }

    public static String quotaMark(Object obj) {
        String srcStr = String.valueOf(obj);
        if (obj instanceof CharSequence) {
            return StringEscape.escapeString(srcStr);
        }
        return srcStr;
    }

    public static String quotaMarkList(Collection<?> coll) {
        return coll.stream().map(StringUtils::quotaMark).collect(Collectors.joining(",", "(", ")"));
    }

    public static String concatCapitalize(String concatStr, String str) {
        if (StringUtils.isBlank(concatStr)) {
            concatStr = "";
        }
        if (str == null || str.isEmpty()) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isTitleCase(firstChar)) {
            return str;
        }
        return concatStr + Character.toTitleCase(firstChar) + str.substring(1);
    }

    public static boolean checkValNotNull(Object object) {
        if (object instanceof CharSequence) {
            return StringUtils.isNotEmpty((CharSequence)object);
        }
        return object != null;
    }

    public static boolean checkValNull(Object object) {
        return !StringUtils.checkValNotNull(object);
    }

    public static boolean containsUpperCase(String word) {
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCapitalMode(String word) {
        return null != word && CAPITAL_MODE.matcher(word).matches();
    }

    public static boolean isMixedMode(String word) {
        return StringUtils.matches(".*[A-Z]+.*", word) && StringUtils.matches(".*[/_]+.*", word);
    }

    public static boolean endsWith(String str, String suffix) {
        return StringUtils.endsWith(str, suffix, false);
    }

    private static boolean endsWith(String str, String suffix, boolean ignoreCase) {
        if (str == null || suffix == null) {
            return str == null && suffix == null;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return str.regionMatches(ignoreCase, strOffset, suffix, 0, suffix.length());
    }

    public static boolean isCharSequence(Class<?> clazz) {
        return clazz != null && ClassTypeUtil.isTargetClass(CharSequence.class, clazz) != false;
    }

    public static String prefixToLower(String rawString, int index) {
        String field = rawString.substring(0, index).toLowerCase() + rawString.substring(index);
        return field;
    }

    public static String removePrefixAfterPrefixToLower(String rawString, int index) {
        return StringUtils.prefixToLower(rawString.substring(index), 1);
    }

    public static String camelToHyphen(String input) {
        return StringUtils.wordsToHyphenCase(StringUtils.wordsAndHyphenAndCamelToConstantCase(input));
    }

    private static String wordsAndHyphenAndCamelToConstantCase(String input) {
        char[] chars;
        StringBuilder buf = new StringBuilder();
        char previousChar = ' ';
        for (char c : chars = input.toCharArray()) {
            boolean isNotUnderscore;
            boolean isUpperCaseAndPreviousIsLowerCase = Character.isLowerCase(previousChar) && Character.isUpperCase(c);
            boolean previousIsWhitespace = Character.isWhitespace(previousChar);
            boolean lastOneIsNotUnderscore = buf.length() > 0 && buf.charAt(buf.length() - 1) != '_';
            boolean bl = isNotUnderscore = c != '_';
            if (lastOneIsNotUnderscore && (isUpperCaseAndPreviousIsLowerCase || previousIsWhitespace)) {
                buf.append("_");
            } else if (Character.isDigit(previousChar) && Character.isLetter(c)) {
                buf.append('_');
            }
            if (StringUtils.shouldReplace(c) && lastOneIsNotUnderscore) {
                buf.append('_');
            } else if (!Character.isWhitespace(c) && (isNotUnderscore || lastOneIsNotUnderscore)) {
                buf.append(Character.toUpperCase(c));
            }
            previousChar = c;
        }
        if (Character.isWhitespace(previousChar)) {
            buf.append("_");
        }
        return buf.toString();
    }

    private static boolean shouldReplace(char c) {
        return c == '.' || c == '_' || c == '-';
    }

    private static String wordsToHyphenCase(String s) {
        StringBuilder buf = new StringBuilder();
        char lastChar = 'a';
        for (char c : s.toCharArray()) {
            if (Character.isWhitespace(lastChar) && !Character.isWhitespace(c) && '-' != c && buf.length() > 0 && buf.charAt(buf.length() - 1) != '-') {
                buf.append("-");
            }
            if ('_' == c) {
                buf.append("-");
            } else if ('.' == c) {
                buf.append("-");
            } else if (!Character.isWhitespace(c)) {
                buf.append(Character.toLowerCase(c));
            }
            lastChar = c;
        }
        if (Character.isWhitespace(lastChar)) {
            buf.append("-");
        }
        return buf.toString();
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        if (cs1 instanceof String && cs2 instanceof String) {
            return cs1.equals(cs2);
        }
        int length = cs1.length();
        for (int i = 0; i < length; ++i) {
            if (cs1.charAt(i) == cs2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static byte[] hexToBytes(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    public static String bytesToHex(byte[] hashBytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte hashByte : hashBytes) {
            String hex = Integer.toHexString(0xFF & hashByte);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

