/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.toolkit;

import com.anwen.mongo.cache.global.PropertyCache;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;

public class ObjectIdUtil {
    public static <T> Object convertObjectId(T id) {
        if (id == null) {
            return null;
        }
        String strId = String.valueOf(id);
        if (ObjectId.isValid((String)strId)) {
            return new ObjectId(strId);
        }
        return id;
    }

    public static Collection<Object> convertObjectId(Collection<?> ids) {
        if (ids == null) {
            return Collections.emptyList();
        }
        return ids.stream().map(ObjectIdUtil::convertObjectId).collect(Collectors.toList());
    }

    public static Object getObjectIdValue(Object value) {
        if (value instanceof ObjectId) {
            return value;
        }
        String convertValue = String.valueOf(value);
        return ObjectId.isValid((String)convertValue) && PropertyCache.autoConvertObjectId != false ? new ObjectId(convertValue) : value;
    }
}

