/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.toolkit;

import com.anwen.mongo.cache.global.DataSourceNameCache;
import com.anwen.mongo.cache.global.PropertyCache;
import com.anwen.mongo.listener.BaseListener;
import com.anwen.mongo.model.BaseProperty;
import com.anwen.mongo.toolkit.StringUtils;
import com.anwen.mongo.toolkit.UrlJoint;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.connection.SslSettings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collections;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class MongoUtil {
    public static MongoClient getMongo(String dsName, BaseProperty baseProperty) {
        SslSettings sslSettings = null;
        if (baseProperty.getSsl().booleanValue()) {
            try {
                KeyStore clientKeyStore = KeyStore.getInstance("JKS");
                clientKeyStore.load(Files.newInputStream(Paths.get(baseProperty.getClientKeyStore(), new String[0]), new OpenOption[0]), baseProperty.getKeyPassword().toCharArray());
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                keyManagerFactory.init(clientKeyStore, baseProperty.getKeyPassword().toCharArray());
                TrustManager[] getTrustManagers = null;
                if (StringUtils.isNotBlank(baseProperty.getJks())) {
                    KeyStore trustStore = KeyStore.getInstance("JKS");
                    trustStore.load(Files.newInputStream(Paths.get(baseProperty.getJks(), new String[0]), new OpenOption[0]), baseProperty.getKeyPassword().toCharArray());
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                    trustManagerFactory.init(trustStore);
                    getTrustManagers = trustManagerFactory.getTrustManagers();
                }
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(keyManagerFactory.getKeyManagers(), getTrustManagers, null);
                sslSettings = SslSettings.builder().enabled(true).invalidHostNameAllowed(baseProperty.isInvalidHostNameAllowed()).context(sslContext).build();
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                throw new RuntimeException(e);
            }
        }
        return MongoUtil.getMongo(dsName, baseProperty, sslSettings);
    }

    public static MongoClient getMongo(String dsName, BaseProperty baseProperty, SslSettings sslSettings) {
        DataSourceNameCache.setBaseProperty(dsName, baseProperty);
        MongoClientSettings.Builder builder = MongoClientSettings.builder();
        if (sslSettings != null) {
            builder.applyToSslSettings(ssl -> ssl.applySettings(sslSettings));
        }
        builder.applyConnectionString(new ConnectionString(new UrlJoint(baseProperty).jointMongoUrl()));
        if (PropertyCache.log.booleanValue()) {
            builder.commandListenerList(Collections.singletonList(new BaseListener()));
        }
        return MongoClients.create((MongoClientSettings)builder.build());
    }
}

