/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.toolkit;

import com.anwen.mongo.enums.CommandEnum;
import com.anwen.mongo.toolkit.BsonUtil;
import com.anwen.mongo.toolkit.CollUtil;
import com.anwen.mongo.toolkit.StringUtils;
import com.mongodb.Function;
import com.mongodb.event.CommandStartedEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public class MongoCommandBuildUtils {
    private static final Map<String, Function<CommandStartedEvent, String>> HANDLERS = new HashMap<String, Function<CommandStartedEvent, String>>();

    public static String buildCommand(CommandStartedEvent event) {
        Function<CommandStartedEvent, String> function = HANDLERS.get(event.getCommandName());
        if (Objects.nonNull(function)) {
            return (String)function.apply((Object)event);
        }
        return event.getCommand().toString();
    }

    private static String buildFindCommand(CommandStartedEvent event) {
        String collection = MongoCommandBuildUtils.getJson("find", "", event);
        String json = MongoCommandBuildUtils.getJson("filter", "", event);
        String skip = MongoCommandBuildUtils.getJson("skip", "", event);
        String limit = MongoCommandBuildUtils.getJson("limit", "", event);
        String command = "db." + collection + "." + event.getCommandName() + "(" + json + ")";
        if (StringUtils.isNotBlank(skip) && !skip.equals("0")) {
            command = command + ".skip(" + skip + ")";
        }
        if (StringUtils.isNotBlank(limit) && !limit.equals("0")) {
            command = command + ".limit(" + limit + ")";
        }
        return command;
    }

    private static String buildInsertCommand(CommandStartedEvent event) {
        String json = MongoCommandBuildUtils.getJson("documents", "", event);
        String collection = MongoCommandBuildUtils.getJson("insert", "", event);
        return "db." + collection + ".insert(" + json + ")";
    }

    private static String buildUpdateCommand(CommandStartedEvent event) {
        BsonArray array;
        int size;
        String collection = MongoCommandBuildUtils.getJson("update", "", event);
        BsonValue bsonValue = event.getCommand().get((Object)"updates");
        if (bsonValue instanceof BsonArray && (size = (array = (BsonArray)bsonValue).size()) > 1) {
            ArrayList<String> res = new ArrayList<String>();
            for (BsonValue value : array) {
                String q = MongoCommandBuildUtils.getJson(value, "q");
                String u = MongoCommandBuildUtils.getJson(value, "u");
                String multi = MongoCommandBuildUtils.getJson(value, "multi");
                if ("true".equals(multi)) {
                    res.add("db." + collection + ".updateMany(" + q + ", " + u + ")");
                    continue;
                }
                res.add("db." + collection + ".updateOne(" + q + ", " + u + ")");
            }
            return res.stream().collect(Collectors.joining(System.lineSeparator()));
        }
        String multi = MongoCommandBuildUtils.getJson("updates", "multi", event);
        String q = MongoCommandBuildUtils.getJson("updates", "q", event);
        String u = MongoCommandBuildUtils.getJson("updates", "u", event);
        if ("true".equals(multi)) {
            return "db." + collection + ".updateMany(" + q + ", " + u + ")";
        }
        return "db." + collection + ".updateOne(" + q + ", " + u + ")";
    }

    private static String buildDeleteCommand(CommandStartedEvent event) {
        String json = MongoCommandBuildUtils.getJson("deletes", "q", event);
        String collection = MongoCommandBuildUtils.getJson("delete", "", event);
        return "db." + collection + ".deleteMany(" + json + ")";
    }

    private static String buildCountCommand(CommandStartedEvent event) {
        String json = MongoCommandBuildUtils.getJson("counts", "q", event);
        String collection = MongoCommandBuildUtils.getJson("count", "", event);
        return "db." + collection + ".count(" + json + ")";
    }

    private static String getJson(BsonValue bs, String item) {
        if (Objects.isNull(bs)) {
            return "";
        }
        if (bs.isDocument()) {
            return MongoCommandBuildUtils.buildByDocument((BsonDocument)bs, item);
        }
        if (bs.isArray()) {
            return MongoCommandBuildUtils.buildByArray((BsonArray)bs, item);
        }
        return BsonUtil.toJavaType(bs).toString();
    }

    private static String buildByArray(BsonArray bs, String item) {
        ArrayList<String> jsons = new ArrayList<String>();
        for (BsonValue delete : bs) {
            BsonDocument query = delete.asDocument();
            if (StringUtils.isBlank(item)) {
                jsons.add(query.toJson());
                continue;
            }
            BsonValue bsonValue = query.get((Object)item);
            if (!Objects.nonNull(bsonValue)) continue;
            if (bsonValue.isDocument()) {
                jsons.add(bsonValue.toString());
                continue;
            }
            jsons.add(BsonUtil.toJavaType(bsonValue).toString());
        }
        if (jsons.isEmpty()) {
            return "";
        }
        if (jsons.size() == 1) {
            return (String)jsons.get(0);
        }
        return "[" + String.join((CharSequence)",", jsons) + "]";
    }

    private static String buildByDocument(BsonDocument bs, String item) {
        if (StringUtils.isBlank(item)) {
            return bs.toJson();
        }
        BsonValue bsonValue = bs.get((Object)item);
        if (bsonValue instanceof BsonDocument) {
            return bsonValue.asDocument().toJson();
        }
        return BsonUtil.toJavaType(bsonValue).toString();
    }

    private static String getJson(String key, String item, CommandStartedEvent event) {
        BsonDocument filter = event.getCommand();
        BsonValue bs = filter.get((Object)key);
        return MongoCommandBuildUtils.getJson(bs, item);
    }

    private static String buildAggregateCommand(CommandStartedEvent event) {
        List pipeline = (List)event.getCommand().get((Object)"pipeline");
        String collection = MongoCommandBuildUtils.getJson("aggregate", "", event);
        if (CollUtil.isEmpty(pipeline)) {
            return "db." + collection + "." + event.getCommandName() + "()";
        }
        StringBuilder commandBuilder = new StringBuilder("db." + collection + "." + event.getCommandName() + "([");
        for (BsonDocument stage : pipeline) {
            commandBuilder.append(stage.toJson()).append(", ");
        }
        commandBuilder.delete(commandBuilder.length() - 2, commandBuilder.length()).append("])");
        return commandBuilder.toString();
    }

    static {
        HANDLERS.put(CommandEnum.FIND.getCommand(), (Function<CommandStartedEvent, String>)((Function)MongoCommandBuildUtils::buildFindCommand));
        HANDLERS.put(CommandEnum.COUNT.getCommand(), (Function<CommandStartedEvent, String>)((Function)MongoCommandBuildUtils::buildCountCommand));
        HANDLERS.put(CommandEnum.INSERT.getCommand(), (Function<CommandStartedEvent, String>)((Function)MongoCommandBuildUtils::buildInsertCommand));
        HANDLERS.put(CommandEnum.DELETE.getCommand(), (Function<CommandStartedEvent, String>)((Function)MongoCommandBuildUtils::buildDeleteCommand));
        HANDLERS.put(CommandEnum.UPDATE.getCommand(), (Function<CommandStartedEvent, String>)((Function)MongoCommandBuildUtils::buildUpdateCommand));
        HANDLERS.put(CommandEnum.AGGREGATE.getCommand(), (Function<CommandStartedEvent, String>)((Function)MongoCommandBuildUtils::buildAggregateCommand));
    }
}

