/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.toolkit;

import com.anwen.mongo.cache.codec.MapCodecCache;
import com.anwen.mongo.conditions.interfaces.Projection;
import com.anwen.mongo.conditions.interfaces.condition.CompareCondition;
import com.anwen.mongo.conditions.interfaces.condition.Order;
import com.anwen.mongo.handlers.condition.BuildCondition;
import com.anwen.mongo.mapping.MongoConverter;
import com.anwen.mongo.mapping.TypeReference;
import com.anwen.mongo.model.BaseLambdaQueryResult;
import com.anwen.mongo.model.PageParam;
import com.anwen.mongo.model.PageResult;
import com.anwen.mongo.toolkit.CollUtil;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoIterable;
import java.util.List;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.Document;

public class LambdaOperate {
    public BaseLambdaQueryResult baseLambdaQuery(List<CompareCondition> compareConditionList, List<Order> orderList, List<Projection> projectionList, List<BasicDBObject> basicDBObjectList) {
        BasicDBObject sortCond = new BasicDBObject();
        if (CollUtil.isNotEmpty(orderList)) {
            orderList.forEach(order -> sortCond.put((Object)order.getColumn(), (Object)order.getType()));
        }
        BasicDBObject basicDBObject = BuildCondition.condition().queryCondition(compareConditionList);
        if (CollUtil.isNotEmpty(basicDBObjectList)) {
            basicDBObjectList.forEach(basic -> basicDBObject.putAll((Map)basic.toBsonDocument(BsonDocument.class, MapCodecCache.getDefaultCodecRegistry())));
        }
        return new BaseLambdaQueryResult(basicDBObject, BuildCondition.condition().projectionCondition(projectionList), sortCond);
    }

    public <T> PageResult<T> getLambdaQueryResultPage(FindIterable<Document> documentFindIterable, long totalSize, PageParam pageParams, TypeReference<T> typeReference, MongoConverter mongoConverter) {
        List<T> pageContentData = mongoConverter.read((MongoIterable<Document>)documentFindIterable.skip((pageParams.getPageNum() - 1) * pageParams.getPageSize()).limit(pageParams.getPageSize().intValue()), typeReference);
        if (totalSize == -1L) {
            totalSize = pageContentData.size();
        }
        return new PageResult<T>(pageParams.getPageNum().intValue(), pageParams.getPageSize().intValue(), totalSize, (totalSize + (long)pageParams.getPageSize().intValue() - 1L) / (long)pageParams.getPageSize().intValue(), pageContentData);
    }
}

