/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.toolkit;

import com.anwen.mongo.domain.MongoPlusConvertException;
import com.anwen.mongo.logging.Log;
import com.anwen.mongo.logging.LogFactory;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;

public class InstantUtil {
    private static final Log log = LogFactory.getLog(InstantUtil.class);

    public static LocalDateTime convertTimestampToLocalDateTime8(long timestamp) {
        return InstantUtil.convertTimestampToLocalDateTime(timestamp).minusHours(8L);
    }

    public static LocalDateTime convertTimestampToLocalDateTime(long timestamp) {
        Instant instant;
        try {
            instant = Instant.ofEpochMilli(timestamp);
        }
        catch (Exception e) {
            log.error("Convert To Instant Fail,message: {}", e.getMessage(), e);
            throw new MongoPlusConvertException("Convert To Instant Fail");
        }
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime convertTimestampToLocalDateTime8(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).minusHours(8L);
    }

    public static LocalDate convertTimestampToLocalDate(long timestamp) {
        return InstantUtil.convertTimestampToLocalDateTime8(timestamp).toLocalDate();
    }

    public static LocalDate convertTimestampToLocalDate(Instant instant) {
        return InstantUtil.convertTimestampToLocalDateTime8(instant).toLocalDate();
    }

    public static LocalTime convertTimestampToLocalTime(long timestamp) {
        return InstantUtil.convertTimestampToLocalDateTime(timestamp).toLocalTime();
    }

    public static LocalTime convertTimestampToLocalTime(Instant instant) {
        return InstantUtil.convertTimestampToLocalDateTime8(instant).toLocalTime();
    }
}

