/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.toolkit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPAddressUtil {
    private static final String MONGODB_URI_REGEX = "mongodb://([^:]+):([^@]+)@";
    private static final String IP_PORT_REGEX = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3}):(\\d{2})(\\d{1,3})";

    public static String maskSensitiveInfo(String input) {
        try {
            Pattern uriPattern = Pattern.compile(MONGODB_URI_REGEX);
            Matcher uriMatcher = uriPattern.matcher(input);
            StringBuffer uriSb = new StringBuffer();
            while (uriMatcher.find()) {
                String replacement = "mongodb://***:***@";
                uriMatcher.appendReplacement(uriSb, replacement);
            }
            uriMatcher.appendTail(uriSb);
            String intermediateResult = uriSb.toString();
            Pattern ipPortPattern = Pattern.compile(IP_PORT_REGEX);
            Matcher ipPortMatcher = ipPortPattern.matcher(intermediateResult);
            StringBuffer ipPortSb = new StringBuffer();
            while (ipPortMatcher.find()) {
                String replacement = ipPortMatcher.group(1) + ".*.*." + ipPortMatcher.group(4) + ":**" + ipPortMatcher.group(6);
                ipPortMatcher.appendReplacement(ipPortSb, replacement);
            }
            ipPortMatcher.appendTail(ipPortSb);
            return ipPortSb.toString();
        }
        catch (Exception e) {
            return input;
        }
    }
}

