/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.toolkit;

import com.anwen.mongo.model.MutablePair;
import com.anwen.mongo.toolkit.StringUtils;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import java.util.Arrays;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Hex;

public class GenerateKeyUtil {
    public static String generateAESKey(String password) throws NoSuchAlgorithmException {
        byte[] key = password.getBytes();
        MessageDigest sha = MessageDigest.getInstance("SHA-256");
        key = sha.digest(key);
        key = Arrays.copyOf(key, 16);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
        return StringUtils.bytesToHex(secretKeySpec.getEncoded());
    }

    public static MutablePair<String, String> generateRSAKey() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        KeyPair keyPair = keyGen.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        return new MutablePair<String, String>(StringUtils.bytesToHex(publicKey.getEncoded()), StringUtils.bytesToHex(privateKey.getEncoded()));
    }

    public static MutablePair<String, String> generateSM2Key() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "BC");
        keyPairGenerator.initialize(new ECGenParameterSpec("sm2p256v1"));
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        return new MutablePair<String, String>(Hex.toHexString((byte[])publicKey.getEncoded()), Hex.toHexString((byte[])privateKey.getEncoded()));
    }

    public static String generateSM4Key() throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance("SM4", "BC");
        kg.init(128);
        SecretKey secretKey = kg.generateKey();
        return Hex.toHexString((byte[])secretKey.getEncoded());
    }
}

