/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.toolkit;

import com.anwen.mongo.annotation.comm.FieldEncrypt;
import com.anwen.mongo.encryptor.AESExample;
import com.anwen.mongo.encryptor.Base64Example;
import com.anwen.mongo.encryptor.Encryptor;
import com.anwen.mongo.encryptor.MD5Example;
import com.anwen.mongo.encryptor.PBEExample;
import com.anwen.mongo.encryptor.RSAExample;
import com.anwen.mongo.encryptor.SM2Example;
import com.anwen.mongo.encryptor.SM3Example;
import com.anwen.mongo.encryptor.SM4Example;
import com.anwen.mongo.enums.AlgorithmEnum;
import com.anwen.mongo.logging.Log;
import com.anwen.mongo.logging.LogFactory;
import com.anwen.mongo.toolkit.ClassTypeUtil;
import com.anwen.mongo.toolkit.StringUtils;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;

public class EncryptorUtil {
    private static final Log log = LogFactory.getLog(EncryptorUtil.class);
    public static final Map<AlgorithmEnum, Encryptor> algorithmEnumEncryptorMap = new HashMap<AlgorithmEnum, Encryptor>();
    public static final Map<Class<?>, Encryptor> encryptorCache = new HashMap();

    public static Object encrypt(FieldEncrypt fieldEncrypt, Object value) {
        try {
            Encryptor encryptor = EncryptorUtil.getEncryptor(fieldEncrypt);
            value = encryptor.encrypt(String.valueOf(value), fieldEncrypt.key(), fieldEncrypt.publicKey());
        }
        catch (Exception e) {
            log.error(fieldEncrypt.algorithm().name() + " encryption failed due to: {}", e.getMessage(), e);
        }
        return value;
    }

    public static Object decrypt(FieldEncrypt fieldEncrypt, Object value) {
        try {
            Encryptor encryptor = EncryptorUtil.getEncryptor(fieldEncrypt);
            value = encryptor.decrypt(String.valueOf(value), fieldEncrypt.key(), fieldEncrypt.publicKey());
        }
        catch (Exception e) {
            log.error(fieldEncrypt.algorithm().name() + " decryption failed due to: {}", e.getMessage(), e);
        }
        return value;
    }

    public static Encryptor getEncryptor(FieldEncrypt fieldEncrypt) {
        Encryptor encryptor = algorithmEnumEncryptorMap.get(fieldEncrypt.algorithm());
        if (fieldEncrypt.algorithm() == AlgorithmEnum.SM2) {
            encryptor = new SM2Example();
            algorithmEnumEncryptorMap.put(AlgorithmEnum.SM2, encryptor);
        } else if (fieldEncrypt.algorithm() == AlgorithmEnum.SM3) {
            encryptor = new SM3Example();
            algorithmEnumEncryptorMap.put(AlgorithmEnum.SM3, encryptor);
        } else if (fieldEncrypt.algorithm() == AlgorithmEnum.SM4) {
            encryptor = new SM4Example();
            algorithmEnumEncryptorMap.put(AlgorithmEnum.SM4, encryptor);
        }
        if (fieldEncrypt.encryptor() != Void.class) {
            if (encryptorCache.get(fieldEncrypt.encryptor()) != null) {
                encryptor = encryptorCache.get(fieldEncrypt.encryptor());
            } else {
                encryptor = (Encryptor)ClassTypeUtil.getInstanceByClass(fieldEncrypt.encryptor());
                encryptorCache.put(fieldEncrypt.encryptor(), encryptor);
            }
        }
        return encryptor;
    }

    public static PublicKey getPublicKeyFromString(String key, String algorithm) throws Exception {
        byte[] keyBytes = StringUtils.hexToBytes(key);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePublic(spec);
    }

    public static PublicKey getPublicKeyFromString(String key, String algorithm, String provider) throws Exception {
        byte[] keyBytes = StringUtils.hexToBytes(key);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm, provider);
        return keyFactory.generatePublic(spec);
    }

    public static PrivateKey getPrivateKeyFromString(String key, String algorithm) throws Exception {
        byte[] keyBytes = StringUtils.hexToBytes(key);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePrivate(spec);
    }

    public static PrivateKey getPrivateKeyFromString(String key, String algorithm, String provider) throws Exception {
        byte[] keyBytes = StringUtils.hexToBytes(key);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm, provider);
        return keyFactory.generatePrivate(spec);
    }

    static {
        algorithmEnumEncryptorMap.put(AlgorithmEnum.MD5_16, new MD5Example(16));
        algorithmEnumEncryptorMap.put(AlgorithmEnum.MD5_32, new MD5Example());
        algorithmEnumEncryptorMap.put(AlgorithmEnum.AES, new AESExample());
        algorithmEnumEncryptorMap.put(AlgorithmEnum.BASE64, new Base64Example());
        algorithmEnumEncryptorMap.put(AlgorithmEnum.RSA, new RSAExample());
        algorithmEnumEncryptorMap.put(AlgorithmEnum.PBEWithMD5AndDES, new PBEExample(AlgorithmEnum.PBEWithMD5AndDES.getAlgorithm()));
        algorithmEnumEncryptorMap.put(AlgorithmEnum.PBEWithMD5AndTripleDES, new PBEExample(AlgorithmEnum.PBEWithMD5AndTripleDES.getAlgorithm()));
        algorithmEnumEncryptorMap.put(AlgorithmEnum.PBEWithSHA1AndDESede, new PBEExample(AlgorithmEnum.PBEWithSHA1AndDESede.getAlgorithm()));
        algorithmEnumEncryptorMap.put(AlgorithmEnum.PBEWithSHA1AndRC2_40, new PBEExample(AlgorithmEnum.PBEWithSHA1AndRC2_40.getAlgorithm()));
    }
}

