/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.toolkit;

import com.anwen.mongo.enums.DesensitizationTypeEnum;
import com.anwen.mongo.toolkit.StringUtils;

public class DesensitizedUtil {
    public static final char SPACE = ' ';

    public static String desensitized(CharSequence str, int startInclude, int endExclude, DesensitizationTypeEnum desensitizedType) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        String newStr = String.valueOf(str);
        switch (desensitizedType) {
            case CUSTOM: {
                newStr = StringUtils.hide(str, startInclude, endExclude);
                break;
            }
            case USER_ID: {
                newStr = String.valueOf(DesensitizedUtil.userId());
                break;
            }
            case CHINESE_NAME: {
                newStr = DesensitizedUtil.chineseName(String.valueOf(str));
                break;
            }
            case ID_CARD: {
                newStr = DesensitizedUtil.idCardNum(String.valueOf(str), 1, 2);
                break;
            }
            case FIXED_PHONE: {
                newStr = DesensitizedUtil.fixedPhone(String.valueOf(str));
                break;
            }
            case MOBILE_PHONE: {
                newStr = DesensitizedUtil.mobilePhone(String.valueOf(str));
                break;
            }
            case ADDRESS: {
                newStr = DesensitizedUtil.address(String.valueOf(str), 8);
                break;
            }
            case EMAIL: {
                newStr = DesensitizedUtil.email(String.valueOf(str));
                break;
            }
            case PASSWORD: {
                newStr = DesensitizedUtil.password(String.valueOf(str));
                break;
            }
            case CAR_LICENSE: {
                newStr = DesensitizedUtil.carLicense(String.valueOf(str));
                break;
            }
            case BANK_CARD: {
                newStr = DesensitizedUtil.bankCard(String.valueOf(str));
                break;
            }
            case IPV4: {
                newStr = DesensitizedUtil.ipv4(String.valueOf(str));
                break;
            }
            case IPV6: {
                newStr = DesensitizedUtil.ipv6(String.valueOf(str));
                break;
            }
            case FIRST_MASK: {
                newStr = DesensitizedUtil.firstMask(String.valueOf(str));
                break;
            }
            case CLEAR_TO_EMPTY: {
                newStr = DesensitizedUtil.clear();
                break;
            }
            case CLEAR_TO_NULL: {
                newStr = DesensitizedUtil.clearToNull();
                break;
            }
        }
        return newStr;
    }

    public static String clear() {
        return "";
    }

    public static String clearToNull() {
        return null;
    }

    public static Long userId() {
        return 0L;
    }

    public static String firstMask(String str) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        return StringUtils.hide(str, 1, str.length());
    }

    public static String chineseName(String fullName) {
        return DesensitizedUtil.firstMask(fullName);
    }

    public static String idCardNum(String idCardNum, int front, int end) {
        if (StringUtils.isBlank(idCardNum)) {
            return "";
        }
        if (front + end > idCardNum.length()) {
            return "";
        }
        if (front < 0 || end < 0) {
            return "";
        }
        return StringUtils.hide(idCardNum, front, idCardNum.length() - end);
    }

    public static String fixedPhone(String num) {
        if (StringUtils.isBlank(num)) {
            return "";
        }
        return StringUtils.hide(num, 4, num.length() - 2);
    }

    public static String mobilePhone(String num) {
        if (StringUtils.isBlank(num)) {
            return "";
        }
        return StringUtils.hide(num, 3, num.length() - 4);
    }

    public static String address(String address, int sensitiveSize) {
        if (StringUtils.isBlank(address)) {
            return "";
        }
        int length = address.length();
        return StringUtils.hide(address, length - sensitiveSize, length);
    }

    public static String email(String email) {
        if (StringUtils.isBlank(email)) {
            return "";
        }
        int index = StringUtils.indexOf(email, "@");
        if (index <= 1) {
            return email;
        }
        return StringUtils.hide(email, 1, index);
    }

    public static String password(String password) {
        if (StringUtils.isBlank(password)) {
            return "";
        }
        return StringUtils.repeat('*', password.length());
    }

    public static String carLicense(String carLicense) {
        if (StringUtils.isBlank(carLicense)) {
            return "";
        }
        if (carLicense.length() == 7) {
            carLicense = StringUtils.hide(carLicense, 3, 6);
        } else if (carLicense.length() == 8) {
            carLicense = StringUtils.hide(carLicense, 3, 7);
        }
        return carLicense;
    }

    public static String bankCard(String bankCardNo) {
        if (StringUtils.isBlank(bankCardNo)) {
            return bankCardNo;
        }
        if ((bankCardNo = StringUtils.cleanBlank(bankCardNo)).length() < 9) {
            return bankCardNo;
        }
        int length = bankCardNo.length();
        int endLength = length % 4 == 0 ? 4 : length % 4;
        int midLength = length - 4 - endLength;
        StringBuilder buf = new StringBuilder();
        buf.append(bankCardNo, 0, 4);
        for (int i = 0; i < midLength; ++i) {
            if (i % 4 == 0) {
                buf.append(' ');
            }
            buf.append('*');
        }
        buf.append(' ').append(bankCardNo, length - endLength, length);
        return buf.toString();
    }

    public static String ipv4(String ipv4) {
        return StringUtils.subBefore(ipv4, '.', false) + ".*.*.*";
    }

    public static String ipv6(String ipv6) {
        return StringUtils.subBefore(ipv6, ':', false) + ":*:*:*:*:*:*:*";
    }
}

