/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.toolkit;

import com.anwen.mongo.toolkit.ClassTypeUtil;
import java.lang.reflect.Modifier;
import java.util.Map;

public class CustomClassUtil {
    public static boolean isCustomObject(Class<?> clazz) {
        String pkgName;
        Package pkg = clazz.getPackage();
        String string = pkgName = pkg != null ? pkg.getName() : "";
        if (pkgName.startsWith("java.") || pkgName.startsWith("javax.")) {
            return false;
        }
        if (clazz.isEnum()) {
            return false;
        }
        if (clazz.isAnonymousClass()) {
            return false;
        }
        if (clazz.isLocalClass()) {
            return false;
        }
        if (clazz.isArray()) {
            return false;
        }
        if (ClassTypeUtil.isTargetClass(Iterable.class, clazz).booleanValue() || ClassTypeUtil.isTargetClass(Map.class, clazz).booleanValue()) {
            return false;
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return false;
        }
        if (clazz.isPrimitive()) {
            return false;
        }
        if (clazz.isSynthetic()) {
            return false;
        }
        if (clazz == String.class) {
            return false;
        }
        if (clazz == Boolean.class) {
            return false;
        }
        if (clazz == Character.class) {
            return false;
        }
        if (clazz == Byte.class) {
            return false;
        }
        if (clazz == Short.class) {
            return false;
        }
        if (clazz == Integer.class) {
            return false;
        }
        if (clazz == Long.class) {
            return false;
        }
        if (clazz == Float.class) {
            return false;
        }
        if (clazz == Double.class) {
            return false;
        }
        return clazz != Void.class;
    }
}

