/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.toolkit;

import com.anwen.mongo.annotation.ID;
import com.anwen.mongo.domain.MongoPlusException;
import com.anwen.mongo.domain.MongoPlusFieldException;
import com.anwen.mongo.logging.Log;
import com.anwen.mongo.logging.LogFactory;
import com.anwen.mongo.toolkit.CustomClassUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ClassTypeUtil {
    private static final Log log = LogFactory.getLog(ClassTypeUtil.class);
    private static final Map<Class<?>, List<Class<?>>> cacheMap = new ConcurrentHashMap();
    private static final Map<Class<?>, List<Field>> FIELD_CACHE = new HashMap();
    private static volatile ClassTypeUtil instance;
    private static final Map<Class<?>, Set<Class<?>>> cacheClass;
    private static final Map<Class<?>, Object> instanceCache;
    private static final Map<Class<?>, ConcurrentHashMap<Class<?>, Boolean>> isTargetClassMap;
    private static final Map<Class<?>, Boolean> isAnonymousClassMap;

    private ClassTypeUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClassTypeUtil getInstance() {
        if (instance != null) return instance;
        Class<ClassTypeUtil> clazz = ClassTypeUtil.class;
        synchronized (ClassTypeUtil.class) {
            if (instance != null) return instance;
            instance = new ClassTypeUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static synchronized List<Class<?>> getAllFieldClasses(Class<?> clazz) {
        Field[] declaredFields;
        if (cacheMap.containsKey(clazz)) {
            return cacheMap.get(clazz);
        }
        ArrayList classList = new ArrayList();
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            classList.add(ClassTypeUtil.getClassByFieldType(field));
        }
        cacheMap.put(clazz, classList);
        return classList;
    }

    public static Class<?> getClassByFieldType(Field field) {
        Type genericType;
        Class<?> fieldType = field.getType();
        if (fieldType.isArray()) {
            return fieldType.getComponentType();
        }
        if (ClassTypeUtil.isTargetClass(Collection.class, fieldType).booleanValue() && (genericType = field.getGenericType()) instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return fieldType;
    }

    public static Boolean isItCustomType(Field field) {
        return CustomClassUtil.isCustomObject(ClassTypeUtil.getClassByFieldType(field));
    }

    public static synchronized List<Class<?>> getAllCustomFieldClasses(Class<?> clazz) {
        ArrayList result = new ArrayList();
        List<Class<?>> fieldClasses = ClassTypeUtil.getAllFieldClasses(clazz);
        fieldClasses.parallelStream().forEach(field -> {
            if (CustomClassUtil.isCustomObject(field)) {
                result.add((Class<?>)field);
                result.addAll(ClassTypeUtil.getAllCustomFieldClasses(field));
            }
        });
        return result;
    }

    public static <T> Object getClassFieldValue(T entity, String field) {
        try {
            Field declaredField = entity.getClass().getDeclaredField(field);
            declaredField.setAccessible(true);
            return declaredField.get(entity);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Object getIdByEntity(T entity, boolean exception) {
        Optional<Field> fieldOptional = ClassTypeUtil.getFields(ClassTypeUtil.getClass(entity)).stream().peek(field -> field.setAccessible(true)).filter(field -> field.getAnnotation(ID.class) != null).findFirst();
        if (!fieldOptional.isPresent()) {
            if (exception) {
                return null;
            }
            throw new MongoPlusFieldException("_id undefined");
        }
        try {
            return fieldOptional.get().get(entity);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Field> getFields(Class<?> clazz) {
        List<Field> fields = FIELD_CACHE.get(clazz);
        if (fields == null) {
            fields = new ArrayList<Field>();
            if (!clazz.equals(Object.class)) {
                fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
                ClassTypeUtil.getSupperFields(fields, clazz.getSuperclass());
            }
            FIELD_CACHE.put(clazz, fields);
        }
        return fields;
    }

    private static void getSupperFields(List<Field> fieldList, Class<?> clazz) {
        if (clazz != null && !clazz.equals(Object.class)) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
            ClassTypeUtil.getSupperFields(fieldList, clazz.getSuperclass());
        }
    }

    public static Class<?> getListGenericType(Field field) {
        return ClassTypeUtil.getListGenericType(field.getGenericType());
    }

    public static Class<?> getListGenericType(Class<?> clazz) {
        return ClassTypeUtil.getListGenericType(clazz.getGenericSuperclass());
    }

    public static Class<?> getListGenericType(Type genericType) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        if (genericType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length > 0 && actualTypeArguments[0] instanceof Class) {
            return (Class)actualTypeArguments[0];
        }
        return Object.class;
    }

    public static Class<?> getListClass(List<?> list) {
        ParameterizedType parameterizedType = (ParameterizedType)list.getClass().getGenericSuperclass();
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        return (Class)typeArguments[0];
    }

    public static <T> Class<?> getClass(T entity) {
        Class<?> entityClass = entity.getClass();
        if (entityClass.isAnonymousClass()) {
            entityClass = entityClass.getSuperclass();
        }
        return entityClass;
    }

    public static Class<?> getClassFromType(Type type) {
        Type[] bounds;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = ClassTypeUtil.getClassFromType(componentType);
            return Array.newInstance(componentClass, 0).getClass();
        }
        if (type instanceof TypeVariable && (bounds = ((TypeVariable)type).getBounds()).length > 0) {
            return ClassTypeUtil.getClassFromType(bounds[0]);
        }
        throw new IllegalArgumentException("Type not supported: " + type);
    }

    public static <T> Object getInstanceByClass(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Failed to create " + clazz.getName() + ", message: {}", e.getMessage(), e);
            throw new MongoPlusException("Failed to create " + clazz.getName());
        }
    }

    public static Boolean isTargetClass(Class<?> targetClazz, Class<?> sourceClazz) {
        ConcurrentHashMap classBooleanMap = isTargetClassMap.computeIfAbsent(targetClazz, k -> new ConcurrentHashMap());
        return classBooleanMap.computeIfAbsent(sourceClazz, targetClazz::isAssignableFrom);
    }

    public static Boolean isAnonymousClass(Class<?> clazz) {
        return isAnonymousClassMap.computeIfAbsent(clazz, k -> clazz.isAnonymousClass());
    }

    static {
        cacheClass = new ConcurrentHashMap();
        instanceCache = new HashMap();
        isTargetClassMap = new ConcurrentHashMap();
        isAnonymousClassMap = new ConcurrentHashMap();
        isTargetClassMap.put(Map.class, new ConcurrentHashMap());
        isTargetClassMap.put(Collection.class, new ConcurrentHashMap());
        isTargetClassMap.put(Enum.class, new ConcurrentHashMap());
    }
}

