/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.toolkit;

import com.anwen.mongo.bson.EmptyDocument;
import com.anwen.mongo.cache.codec.MapCodecCache;
import com.anwen.mongo.toolkit.ArrayUtils;
import com.anwen.mongo.toolkit.CollUtil;
import com.anwen.mongo.toolkit.Filters;
import com.anwen.mongo.toolkit.ObjectIdUtil;
import com.anwen.mongo.toolkit.StringUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClientSettings;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.BSONObject;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bson.types.ObjectId;

public class BsonUtil {
    public static final Document EMPTY_DOCUMENT = new EmptyDocument();

    public static <T> T get(Bson bson, String key) {
        return (T)BsonUtil.asMap(bson).get(key);
    }

    public static Map<String, Object> asMap(Bson bson) {
        return BsonUtil.asMap(bson, MongoClientSettings.getDefaultCodecRegistry());
    }

    public static Map<String, Object> asMap(Bson bson, CodecRegistry codecRegistry) {
        if (bson == null) {
            return Collections.emptyMap();
        }
        if (bson instanceof Document) {
            return (Document)bson;
        }
        if (bson instanceof BasicDBObject) {
            return (BasicDBObject)bson;
        }
        if (bson instanceof DBObject) {
            return ((DBObject)bson).toMap();
        }
        return new Document((Map)bson.toBsonDocument(Document.class, codecRegistry));
    }

    public static Document asDocument(Bson bson) {
        return BsonUtil.asDocument(bson, MongoClientSettings.getDefaultCodecRegistry());
    }

    public static Document asDocument(Bson bson, CodecRegistry codecRegistry) {
        Map<String, Object> map = BsonUtil.asMap(bson, codecRegistry);
        if (map instanceof Document) {
            return (Document)bson;
        }
        return new Document(map);
    }

    public static Document asMutableDocument(Bson bson) {
        if (bson instanceof EmptyDocument) {
            bson = new Document((Map)BsonUtil.asDocument(bson));
        }
        if (bson instanceof Document) {
            return (Document)bson;
        }
        Map<String, Object> map = BsonUtil.asMap(bson);
        if (map instanceof Document) {
            return (Document)map;
        }
        return new Document(map);
    }

    public static Bson addToMap(Bson bson, String key, Object value) {
        if (bson instanceof Document) {
            ((Document)bson).put(key, value);
            return bson;
        }
        if (!(bson instanceof BSONObject)) {
            bson = new BasicDBObject((Map)bson.toBsonDocument(BsonDocument.class, MapCodecCache.getDefaultCodecRegistry()));
        }
        ((BSONObject)bson).put(key, value);
        return bson;
    }

    public static Bson addToMapByKey(String targetKey, Bson bson, String key, Object value) {
        BsonDocument bsonDocument = bson.toBsonDocument(BsonDocument.class, MapCodecCache.getDefaultCodecRegistry()).get((Object)targetKey).asDocument();
        if (bsonDocument == null) {
            return bson;
        }
        bson = BsonUtil.addToMap((Bson)bsonDocument, key, value);
        return bson;
    }

    public static void addAllToMap(Bson target, Map<String, ?> source) {
        if (target instanceof Document) {
            ((Document)target).putAll(source);
            return;
        }
        if (!(target instanceof BSONObject)) {
            target = new BasicDBObject((Map)target.toBsonDocument(BsonDocument.class, MapCodecCache.getDefaultCodecRegistry()));
        }
        ((BSONObject)target).putAll(source);
    }

    public static boolean contains(Bson bson, String key, Object value) {
        if (bson instanceof Document) {
            Document document = (Document)bson;
            return document.containsKey((Object)key) && BsonUtil.nullSafeEquals(document.get((Object)key), value);
        }
        if (bson instanceof BSONObject) {
            BSONObject bsonObject = (BSONObject)bson;
            return bsonObject.containsField(key) && BsonUtil.nullSafeEquals(bsonObject.get(key), value);
        }
        Map<String, Object> map = BsonUtil.asMap(bson);
        return map.containsKey(key) && BsonUtil.nullSafeEquals(map.get(key), value);
    }

    public static boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            return BsonUtil.arrayEquals(o1, o2);
        }
        return false;
    }

    private static boolean arrayEquals(Object o1, Object o2) {
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
        if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
            return Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof char[] && o2 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        if (o1 instanceof double[] && o2 instanceof double[]) {
            return Arrays.equals((double[])o1, (double[])o2);
        }
        if (o1 instanceof float[] && o2 instanceof float[]) {
            return Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof int[] && o2 instanceof int[]) {
            return Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof long[] && o2 instanceof long[]) {
            return Arrays.equals((long[])o1, (long[])o2);
        }
        if (o1 instanceof short[] && o2 instanceof short[]) {
            return Arrays.equals((short[])o1, (short[])o2);
        }
        return false;
    }

    public static boolean removeNullId(Bson bson) {
        if (!BsonUtil.contains(bson, "_id", null)) {
            return false;
        }
        BsonUtil.removeFrom(bson, "_id");
        return true;
    }

    static void removeFrom(Bson bson, String key) {
        if (bson instanceof Document) {
            ((Document)bson).remove((Object)key);
            return;
        }
        if (bson instanceof BSONObject) {
            ((BSONObject)bson).removeField(key);
            return;
        }
        throw new IllegalArgumentException(String.format("Cannot remove from %s given Bson must be a Document or BSONObject.", bson.getClass()));
    }

    public static Object toJavaType(BsonValue value) {
        switch (value.getBsonType()) {
            case INT32: {
                return value.asInt32().getValue();
            }
            case INT64: {
                return value.asInt64().getValue();
            }
            case STRING: {
                return value.asString().getValue();
            }
            case DECIMAL128: {
                return value.asDecimal128().doubleValue();
            }
            case DOUBLE: {
                return value.asDouble().getValue();
            }
            case BOOLEAN: {
                return value.asBoolean().getValue();
            }
            case OBJECT_ID: {
                return value.asObjectId().getValue();
            }
            case DB_POINTER: {
                return new DBRef(value.asDBPointer().getNamespace(), (Object)value.asDBPointer().getId());
            }
            case BINARY: {
                return value.asBinary().getData();
            }
            case DATE_TIME: {
                return new Date(value.asDateTime().getValue());
            }
            case SYMBOL: {
                return value.asSymbol().getSymbol();
            }
            case ARRAY: {
                return value.asArray().toArray();
            }
            case DOCUMENT: {
                return Document.parse((String)value.asDocument().toJson());
            }
        }
        return value;
    }

    public static BsonValue simpleToBsonValue(Object source) {
        if (source instanceof BsonValue) {
            return (BsonValue)source;
        }
        if (source instanceof ObjectId) {
            return new BsonObjectId((ObjectId)source);
        }
        if (source instanceof String) {
            return new BsonString((String)source);
        }
        if (source instanceof Double) {
            return new BsonDouble(((Double)source).doubleValue());
        }
        if (source instanceof Integer) {
            return new BsonInt32(((Integer)source).intValue());
        }
        if (source instanceof Long) {
            return new BsonInt64(((Long)source).longValue());
        }
        if (source instanceof byte[]) {
            return new BsonBinary((byte[])source);
        }
        if (source instanceof Boolean) {
            return new BsonBoolean(((Boolean)source).booleanValue());
        }
        if (source instanceof Float) {
            return new BsonDouble((double)((Float)source).floatValue());
        }
        if (source instanceof Binary) {
            Binary binary = (Binary)source;
            return new BsonBinary(binary.getType(), binary.getData());
        }
        if (source instanceof Temporal) {
            if (source instanceof Instant) {
                Instant value = (Instant)source;
                return new BsonDateTime(value.toEpochMilli());
            }
            if (source instanceof LocalDateTime) {
                LocalDateTime value = (LocalDateTime)source;
                return new BsonDateTime(value.toInstant(ZoneOffset.UTC).toEpochMilli());
            }
            if (source instanceof LocalDate) {
                LocalDate value = (LocalDate)source;
                return new BsonDateTime(value.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli());
            }
            if (source instanceof LocalTime) {
                LocalTime value = (LocalTime)source;
                return new BsonDateTime(value.atDate(LocalDate.ofEpochDay(0L)).toInstant(ZoneOffset.UTC).toEpochMilli());
            }
        }
        if (source instanceof Date) {
            Date date = (Date)source;
            new BsonDateTime(date.getTime());
        }
        throw new IllegalArgumentException(String.format("Unable to convert %s (%s) to BsonValue.", source, source != null ? source.getClass().getName() : "null"));
    }

    public static Document merge(Document ... documents) {
        if (ArrayUtils.isEmpty(documents)) {
            return new Document();
        }
        if (documents.length == 1) {
            return documents[0];
        }
        Document target = new Document();
        Arrays.asList(documents).forEach(arg_0 -> ((Document)target).putAll(arg_0));
        return target;
    }

    public static boolean isJsonDocument(String value) {
        if (!StringUtils.hasText(value)) {
            return false;
        }
        String potentialJson = value.trim();
        return potentialJson.startsWith("{") && potentialJson.endsWith("}");
    }

    public static boolean isJsonArray(String value) {
        return StringUtils.hasText(value) && value.startsWith("[") && value.endsWith("]");
    }

    public static Object resolveValue(Bson bson, String key) {
        return BsonUtil.resolveValue(BsonUtil.asMap(bson), key);
    }

    public static Object resolveValue(Map<String, Object> source, String key) {
        if (source.containsKey(key) || !key.contains(".")) {
            return source.get(key);
        }
        String[] parts = key.split("\\.");
        for (int i = 1; i < parts.length; ++i) {
            Object result = source.get(parts[i - 1]);
            if (!(result instanceof Bson)) {
                return null;
            }
            source = BsonUtil.asMap((Bson)result);
        }
        return source.get(parts[parts.length - 1]);
    }

    public static boolean hasValue(Bson bson, String key) {
        Map<String, Object> source = BsonUtil.asMap(bson);
        if (source.get(key) != null) {
            return true;
        }
        if (!key.contains(".")) {
            return false;
        }
        String[] parts = key.split("\\.");
        for (int i = 1; i < parts.length; ++i) {
            Object result = source.get(parts[i - 1]);
            if ((source = BsonUtil.getAsMap(result)) != null) continue;
            return false;
        }
        return source.containsKey(parts[parts.length - 1]);
    }

    private static Map<String, Object> getAsMap(Object source) {
        if (source instanceof Document) {
            return (Document)source;
        }
        if (source instanceof BasicDBObject) {
            return (BasicDBObject)source;
        }
        if (source instanceof DBObject) {
            DBObject dbObject = (DBObject)source;
            return dbObject.toMap();
        }
        if (source instanceof Map) {
            return (Map)source;
        }
        return null;
    }

    public static Bson asBson(Object source) {
        if (source instanceof Document) {
            return (Document)source;
        }
        if (source instanceof BasicDBObject) {
            return (BasicDBObject)source;
        }
        if (source instanceof DBObject) {
            DBObject dbObject = (DBObject)source;
            return new Document(dbObject.toMap());
        }
        if (source instanceof Map) {
            return new Document((Map)source);
        }
        throw new IllegalArgumentException(String.format("Cannot convert %s to Bson", source));
    }

    public static boolean supportsBson(Object source) {
        return source instanceof DBObject || source instanceof Map;
    }

    public static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollUtil.arrayToList(source) : Collections.singleton(source);
    }

    private static String serializeValue(Object value) {
        if (value == null) {
            return "null";
        }
        String documentJson = new Document("toBeEncoded", value).toJson();
        return documentJson.substring(documentJson.indexOf(58) + 1, documentJson.length() - 1).trim();
    }

    public static Bson getIdsCondition(Collection<? extends Serializable> idList) {
        List convertedIds = idList.stream().map(ObjectIdUtil::getObjectIdValue).collect(Collectors.toList());
        return Filters.in("_id", convertedIds);
    }
}

