/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.toolkit;

import com.anwen.mongo.enums.AggregateOptionsEnum;
import com.mongodb.BasicDBObject;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.model.Collation;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;

public class AggregateUtil {
    public static void aggregateOptions(AggregateIterable<?> aggregateIterable, BasicDBObject optionsBasicDBObject) {
        AggregateUtil.options(aggregateIterable, optionsBasicDBObject);
    }

    public static void options(AggregateIterable<?> aggregateIterable, BasicDBObject optionsBasicDBObject) {
        Set keyedSet = optionsBasicDBObject.keySet();
        for (String key : keyedSet) {
            AggregateOptionsEnum aggregateOptionsEnum = AggregateOptionsEnum.getByOptions((String)key);
            switch (Objects.requireNonNull(aggregateOptionsEnum)) {
                case ALLOW_DISK_USE: {
                    aggregateIterable.allowDiskUse(Boolean.valueOf(optionsBasicDBObject.getBoolean(key)));
                    break;
                }
                case COLLATION: {
                    aggregateIterable.collation((Collation)optionsBasicDBObject.get(key));
                    break;
                }
                case BATCH_SIZE: {
                    aggregateIterable.batchSize(optionsBasicDBObject.getInt(key));
                    break;
                }
                case MAX_TIME_MS: {
                    aggregateIterable.maxTime(optionsBasicDBObject.getLong(key), TimeUnit.MILLISECONDS);
                    break;
                }
                case MAX_AWAIT_TIME_MS: {
                    aggregateIterable.maxAwaitTime(optionsBasicDBObject.getLong(key), TimeUnit.MILLISECONDS);
                    break;
                }
                case BYPASS_DOCUMENT_VALIDATION: {
                    aggregateIterable.bypassDocumentValidation(Boolean.valueOf(optionsBasicDBObject.getBoolean(key)));
                    break;
                }
                case COMMENT: {
                    aggregateIterable.comment(String.valueOf(optionsBasicDBObject.get(key)));
                    break;
                }
                case COMMENT_STR: {
                    aggregateIterable.comment(optionsBasicDBObject.getString(key));
                    break;
                }
                case HINT: {
                    aggregateIterable.hint((Bson)optionsBasicDBObject.get(key));
                    break;
                }
                case LET: {
                    aggregateIterable.let((Bson)optionsBasicDBObject.get(key));
                }
            }
        }
    }
}

