/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.support;

import com.anwen.mongo.annotation.ID;
import com.anwen.mongo.annotation.collection.CollectionField;
import com.anwen.mongo.cache.global.PropertyCache;
import com.anwen.mongo.toolkit.StringUtils;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;

@FunctionalInterface
public interface SFunction<T, R>
extends Function<T, R>,
Serializable {
    public static final String defaultSplit = "";
    public static final Integer defaultToType = 0;

    default public String getFieldName() {
        String methodName = this.getMethodName();
        if (methodName.startsWith("get")) {
            methodName = methodName.substring(3);
        }
        return StringUtils.firstCharToLowerCase(methodName);
    }

    default public String getFieldNameLineOption() {
        return "$" + this.getFieldNameLine();
    }

    default public String getFieldNameLine() {
        return this.getFieldName(this, defaultSplit);
    }

    default public String getFieldName(SFunction<T, ?> fn, String split) {
        return this.getFieldName(fn, split, defaultToType);
    }

    default public String getFieldName(SFunction<T, ?> fn, String split, Integer toType) {
        Field field = this.getField(fn);
        String fieldName = this.getFieldName(fn);
        if (PropertyCache.camelToUnderline.booleanValue()) {
            fieldName = StringUtils.camelToUnderline(fieldName);
        }
        CollectionField collectionField = field.getAnnotation(CollectionField.class);
        ID id = field.getAnnotation(ID.class);
        if (collectionField != null && StringUtils.isNotBlank(collectionField.value())) {
            return collectionField.value();
        }
        if (id != null) {
            return "_id";
        }
        switch (toType) {
            case 1: {
                return fieldName.replaceAll("[A-Z]", split + "$0").toUpperCase();
            }
            case 2: {
                return fieldName.replaceAll("[A-Z]", split + "$0").toLowerCase();
            }
        }
        return fieldName.replaceAll("[A-Z]", split + "$0");
    }

    default public Class<?> getImplClass() {
        SerializedLambda serializedLambda = this.getSerializedLambda();
        try {
            return Class.forName(serializedLambda.getImplClass().replace("/", "."));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    default public String getMethodName() {
        return this.getSerializedLambda().getImplMethodName();
    }

    default public Class<?> getFieldClass() {
        return this.getReturnType();
    }

    default public SerializedLambda getSerializedLambda() {
        Method method;
        try {
            method = this.getClass().getDeclaredMethod("writeReplace", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        method.setAccessible(true);
        try {
            return (SerializedLambda)method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    default public SerializedLambda getSerializedLambdaOne(SFunction<T, ?> fn) {
        SerializedLambda serializedLambda;
        Method writeReplaceMethod;
        try {
            writeReplaceMethod = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        boolean isAccessible = writeReplaceMethod.isAccessible();
        writeReplaceMethod.setAccessible(true);
        try {
            serializedLambda = (SerializedLambda)writeReplaceMethod.invoke(fn, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        writeReplaceMethod.setAccessible(isAccessible);
        return serializedLambda;
    }

    default public Class<?> getReturnType() {
        Method method;
        Class<?> className;
        SerializedLambda lambda = this.getSerializedLambda();
        try {
            className = Class.forName(lambda.getImplClass().replace("/", "."));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            method = className.getMethod(this.getMethodName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return method.getReturnType();
    }

    default public Field getField() {
        return this.getField(this);
    }

    default public Field getField(SFunction<T, ?> fn) {
        SerializedLambda serializedLambda = this.getSerializedLambdaOne(this);
        try {
            return Class.forName(serializedLambda.getImplClass().replace("/", ".")).getDeclaredField(this.getFieldName(fn));
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    default public String getFieldName(SFunction<T, ?> fn) {
        SerializedLambda serializedLambda = this.getSerializedLambdaOne(fn);
        String fieldName = serializedLambda.getImplMethodName().substring("get".length());
        if (!fieldName.equals(fieldName.toUpperCase())) {
            fieldName = fieldName.replaceFirst(fieldName.charAt(0) + defaultSplit, (fieldName.charAt(0) + defaultSplit).toLowerCase());
        }
        return fieldName;
    }
}

