/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.strategy.conversion.impl;

import com.anwen.mongo.logging.Log;
import com.anwen.mongo.logging.LogFactory;
import com.anwen.mongo.mapping.MongoConverter;
import com.anwen.mongo.strategy.conversion.ConversionStrategy;
import com.anwen.mongo.toolkit.StringUtils;

public class IntegerConversionStrategy
implements ConversionStrategy<Integer> {
    Log log = LogFactory.getLog(IntegerConversionStrategy.class);

    @Override
    public Integer convertValue(Object fieldValue, Class<?> fieldType, MongoConverter mongoConverter) throws IllegalAccessException {
        Integer value = null;
        try {
            value = fieldValue instanceof Integer ? (Integer)fieldValue : Integer.valueOf(Integer.parseInt(StringUtils.isNotBlankAndConvert(fieldValue)));
        }
        catch (Exception e) {
            this.log.warn("Conversion to number failed, exception message: {}", e.getMessage());
        }
        return value;
    }
}

