/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.strategy.conversion.impl;

import com.anwen.mongo.logging.Log;
import com.anwen.mongo.logging.LogFactory;
import com.anwen.mongo.mapping.MongoConverter;
import com.anwen.mongo.strategy.conversion.ConversionStrategy;
import com.anwen.mongo.toolkit.StringUtils;

public class DoubleConversionStrategy
implements ConversionStrategy<Double> {
    Log log = LogFactory.getLog(DoubleConversionStrategy.class);

    @Override
    public Double convertValue(Object fieldValue, Class<?> fieldType, MongoConverter mongoConverter) throws IllegalAccessException {
        Double value = null;
        try {
            value = fieldValue instanceof Double ? (Double)fieldValue : Double.valueOf(Double.parseDouble(StringUtils.isNotBlankAndConvert(fieldValue)));
        }
        catch (NumberFormatException e) {
            this.log.warn("Conversion to Double failed, exception message: {}", e.getMessage());
        }
        return value;
    }
}

