/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.strategy.conversion.impl;

import com.anwen.mongo.logging.Log;
import com.anwen.mongo.logging.LogFactory;
import com.anwen.mongo.mapping.MongoConverter;
import com.anwen.mongo.strategy.conversion.ConversionStrategy;
import com.anwen.mongo.toolkit.StringUtils;
import java.math.BigInteger;

public class BigIntegerConversionStrategy
implements ConversionStrategy<BigInteger> {
    private final Log log = LogFactory.getLog(BigIntegerConversionStrategy.class);

    @Override
    public BigInteger convertValue(Object fieldValue, Class<?> fieldType, MongoConverter mongoConverter) throws IllegalAccessException {
        BigInteger value = null;
        try {
            value = new BigInteger(StringUtils.isNotBlankAndConvert(fieldValue));
        }
        catch (Exception e) {
            this.log.warn("Convert fieldValue To BigDecimal Fail,Exception Message: {}", e.getMessage(), e);
        }
        return value;
    }
}

