/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.service.impl;

import com.anwen.mongo.aggregate.Aggregate;
import com.anwen.mongo.aggregate.LambdaAggregateChainWrapper;
import com.anwen.mongo.annotation.ID;
import com.anwen.mongo.cache.global.DataSourceNameCache;
import com.anwen.mongo.conditions.query.LambdaQueryChainWrapper;
import com.anwen.mongo.conditions.query.QueryChainWrapper;
import com.anwen.mongo.conditions.query.QueryWrapper;
import com.anwen.mongo.conditions.update.LambdaUpdateChainWrapper;
import com.anwen.mongo.conditions.update.UpdateChainWrapper;
import com.anwen.mongo.domain.MongoPlusException;
import com.anwen.mongo.handlers.collection.AnnotationOperate;
import com.anwen.mongo.mapper.BaseMapper;
import com.anwen.mongo.mapping.TypeInformation;
import com.anwen.mongo.mapping.TypeReference;
import com.anwen.mongo.model.MutablePair;
import com.anwen.mongo.model.PageParam;
import com.anwen.mongo.model.PageResult;
import com.anwen.mongo.service.IService;
import com.anwen.mongo.support.SFunction;
import com.anwen.mongo.toolkit.BsonUtil;
import com.anwen.mongo.toolkit.ChainWrappers;
import com.anwen.mongo.toolkit.ClassTypeUtil;
import com.anwen.mongo.toolkit.CollUtil;
import com.anwen.mongo.toolkit.ConditionUtil;
import com.anwen.mongo.toolkit.Filters;
import com.anwen.mongo.toolkit.ObjectIdUtil;
import com.anwen.mongo.toolkit.StringUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.WriteModel;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public class ServiceImpl<T>
implements IService<T> {
    private BaseMapper baseMapper;
    private Class<T> clazz;

    public void setBaseMapper(BaseMapper baseMapper) {
        this.baseMapper = baseMapper;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Class<T> getGenericityClass() {
        if (this.clazz != null) {
            return this.clazz;
        }
        Type superClassType = this.getClass().getGenericSuperclass();
        ParameterizedType pt = (ParameterizedType)superClassType;
        Type genType = pt.getActualTypeArguments()[0];
        if (genType instanceof Class) {
            this.clazz = (Class)genType;
        } else if (genType instanceof TypeVariable) {
            this.clazz = Object.class;
        } else {
            throw new IllegalArgumentException("Unsupported generic type: " + genType);
        }
        return this.clazz;
    }

    @Override
    public MongoCollection<Document> getCollection() {
        String database = DataSourceNameCache.getDatabase();
        String annotationDatabase = AnnotationOperate.getDatabase(this.clazz);
        if (StringUtils.isNotBlank(annotationDatabase)) {
            database = annotationDatabase;
        }
        return this.baseMapper.getMongoPlusClient().getCollection(database, this.clazz);
    }

    @Override
    public MongoCollection<Document> getCollection(String database) {
        return this.baseMapper.getMongoPlusClient().getCollection(database, this.clazz);
    }

    @Override
    public Boolean save(T entity) {
        return this.baseMapper.save(entity);
    }

    @Override
    public Boolean saveBatch(Collection<T> entityList) {
        return this.baseMapper.saveBatch(entityList);
    }

    @Override
    public Boolean saveOrUpdate(T entity) {
        Object idByEntity = ClassTypeUtil.getIdByEntity(entity, true);
        if (idByEntity == null) {
            return this.save(entity);
        }
        return this.updateById(entity);
    }

    @Override
    public boolean saveOrUpdate(T entity, boolean isQueryDatabase) {
        if (!isQueryDatabase) {
            return this.saveOrUpdate(entity);
        }
        Object idByEntity = ClassTypeUtil.getIdByEntity(entity, true);
        long count = this.count((QueryChainWrapper)new QueryWrapper().eq("_id", idByEntity));
        if (count > 0L) {
            return this.updateById(entity);
        }
        return this.save(entity);
    }

    @Override
    public Boolean saveOrUpdateWrapper(T entity, QueryChainWrapper<T, ?> queryChainWrapper) {
        long count = this.count(queryChainWrapper);
        if (count > 0L) {
            return this.baseMapper.update(entity, queryChainWrapper);
        }
        return this.save(entity);
    }

    @Override
    public Boolean saveOrUpdateBatch(Collection<T> entityList) {
        if (CollUtil.isEmpty(entityList)) {
            throw new MongoPlusException("entityList is null");
        }
        ArrayList<WriteModel<Document>> writeModelList = new ArrayList<WriteModel<Document>>();
        entityList.forEach(entity -> {
            Object idByEntity = ClassTypeUtil.getIdByEntity(entity, true);
            if (idByEntity == null) {
                writeModelList.add((WriteModel<Document>)new InsertOneModel((Object)this.baseMapper.getMongoConverter().writeBySave(entity)));
            } else {
                MutablePair<BasicDBObject, BasicDBObject> basicDBObjectPair = ConditionUtil.getUpdate(entity, this.baseMapper.getMongoConverter());
                writeModelList.add((WriteModel<Document>)new UpdateManyModel((Bson)basicDBObjectPair.getLeft(), (Bson)basicDBObjectPair.getRight()));
            }
        });
        return this.baseMapper.bulkWrite(writeModelList, entityList.stream().findFirst().orElseThrow(() -> new MongoPlusException("entityList is null")).getClass()).intValue() == entityList.size();
    }

    @Override
    public boolean saveOrUpdateBatch(Collection<T> entityList, boolean isQueryDatabase) {
        if (CollUtil.isEmpty(entityList)) {
            throw new MongoPlusException("entityList is null");
        }
        if (!isQueryDatabase) {
            return this.saveOrUpdateBatch(entityList);
        }
        List idList = entityList.stream().map(entity -> ClassTypeUtil.getIdByEntity(entity, true)).filter(Objects::nonNull).collect(Collectors.toList());
        List<WriteModel<Document>> writeModelList = entityList.stream().filter(entity -> ClassTypeUtil.getIdByEntity(entity, true) == null).map(entity -> new InsertOneModel((Object)this.baseMapper.getMongoConverter().writeBySave(entity))).collect(Collectors.toList());
        Set<Object> existingIdSet = CollUtil.isNotEmpty(idList) ? this.list((QueryChainWrapper)new QueryWrapper().in("_id", (Collection)idList)).stream().map(entity -> ClassTypeUtil.getIdByEntity(entity, true)).collect(Collectors.toSet()) : new HashSet();
        writeModelList.addAll(entityList.stream().filter(entity -> {
            Object id = ClassTypeUtil.getIdByEntity(entity, true);
            return id != null && existingIdSet.contains(id);
        }).map(entity -> {
            MutablePair<BasicDBObject, BasicDBObject> basicDBObjectPair = ConditionUtil.getUpdate(entity, this.baseMapper.getMongoConverter());
            return new UpdateManyModel((Bson)basicDBObjectPair.getLeft(), (Bson)basicDBObjectPair.getRight());
        }).collect(Collectors.toList()));
        writeModelList.addAll(entityList.stream().filter(entity -> {
            Object id = ClassTypeUtil.getIdByEntity(entity, true);
            return id != null && !existingIdSet.contains(id);
        }).map(entity -> new InsertOneModel((Object)this.baseMapper.getMongoConverter().writeBySave(entity))).collect(Collectors.toList()));
        return this.baseMapper.bulkWrite(writeModelList, entityList.stream().findFirst().orElseThrow(() -> new MongoPlusException("entityList is null")).getClass()).intValue() == entityList.size();
    }

    @Override
    public Boolean saveOrUpdateBatchWrapper(Collection<T> entityList, QueryChainWrapper<T, ?> queryChainWrapper) {
        Class<?> clazz = entityList.stream().findFirst().orElseThrow(() -> new MongoPlusException("entityList is null")).getClass();
        ArrayList<WriteModel<Document>> writeModelList = new ArrayList<WriteModel<Document>>();
        entityList.forEach(entity -> {
            long count = this.baseMapper.count(queryChainWrapper, clazz);
            if (count > 0L) {
                MutablePair<BasicDBObject, BasicDBObject> updatePair = ConditionUtil.getUpdateCondition(queryChainWrapper.getCompareList(), entity, this.baseMapper.getMongoConverter());
                writeModelList.add((WriteModel<Document>)new UpdateManyModel((Bson)updatePair.getLeft(), (Bson)updatePair.getRight()));
            } else {
                writeModelList.add((WriteModel<Document>)new InsertOneModel((Object)this.baseMapper.getMongoConverter().writeBySave(entity)));
            }
        });
        return this.baseMapper.bulkWrite(writeModelList, entityList.stream().findFirst().orElseThrow(() -> new MongoPlusException("entityList is null")).getClass()).intValue() == entityList.size();
    }

    @Override
    public Boolean updateById(T entity) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq("_id", TypeInformation.of(entity).getAnnotationField(ID.class, "@ID is not found").getValue());
        return this.update(entity, wrapper);
    }

    @Override
    public Boolean updateBatchByIds(Collection<T> entityList) {
        ArrayList<WriteModel<Document>> writeModelList = new ArrayList<WriteModel<Document>>();
        entityList.forEach(entity -> {
            MutablePair<BasicDBObject, BasicDBObject> basicDBObjectPair = ConditionUtil.getUpdate(entity, this.baseMapper.getMongoConverter());
            writeModelList.add((WriteModel<Document>)new UpdateManyModel((Bson)basicDBObjectPair.getLeft(), (Bson)basicDBObjectPair.getRight()));
        });
        return this.baseMapper.bulkWrite(writeModelList, entityList.stream().findFirst().orElseThrow(() -> new MongoPlusException("entityList is null")).getClass()).intValue() == entityList.size();
    }

    @Override
    public Boolean updateByColumn(T entity, SFunction<T, Object> column) {
        return this.updateByColumn(entity, column.getFieldNameLine());
    }

    @Override
    public Boolean updateByColumn(T entity, String column) {
        Object filterValue = ClassTypeUtil.getClassFieldValue(entity, column);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq(column, filterValue);
        return this.update(entity, wrapper);
    }

    @Override
    public Boolean remove(UpdateChainWrapper<T, ?> updateChainWrapper) {
        return this.baseMapper.remove(updateChainWrapper, this.clazz);
    }

    @Override
    public Boolean update(UpdateChainWrapper<T, ?> updateChainWrapper) {
        return this.baseMapper.update(updateChainWrapper, this.clazz);
    }

    @Override
    public Boolean update(T entity, QueryChainWrapper<T, ?> queryChainWrapper) {
        return this.baseMapper.update(entity, queryChainWrapper);
    }

    @Override
    public Boolean removeById(Serializable id) {
        Bson filterId = Filters.eq("_id", ObjectIdUtil.getObjectIdValue(id));
        return this.baseMapper.remove(filterId, this.clazz) >= 1L;
    }

    @Override
    public Boolean removeByColumn(SFunction<T, Object> column, Object value) {
        return this.removeByColumn(column.getFieldNameLine(), value);
    }

    @Override
    public Boolean removeByColumn(String column, Object value) {
        Bson filter = Filters.eq(column, ObjectIdUtil.getObjectIdValue(value));
        return this.baseMapper.remove(filter, this.clazz) >= 1L;
    }

    @Override
    public Boolean removeBatchByIds(Collection<? extends Serializable> idList) {
        return this.baseMapper.remove(BsonUtil.getIdsCondition(idList), this.clazz) >= 1L;
    }

    @Override
    public List<T> list(Aggregate<?> aggregate) {
        return this.list(aggregate, this.clazz);
    }

    @Override
    public <R> List<R> list(Aggregate<?> aggregate, Class<R> rClass) {
        return this.baseMapper.aggregateList(aggregate, this.clazz, rClass);
    }

    @Override
    public <R> List<R> list(Aggregate<?> aggregate, TypeReference<R> typeReference) {
        return this.baseMapper.aggregateList(aggregate, this.clazz, typeReference);
    }

    @Override
    public T one(QueryChainWrapper<T, ?> queryChainWrapper) {
        return this.one(queryChainWrapper, this.clazz);
    }

    @Override
    public <R> R one(QueryChainWrapper<T, ?> queryChainWrapper, Class<R> rClazz) {
        return this.baseMapper.one(queryChainWrapper, this.clazz, rClazz);
    }

    @Override
    public <R> R one(QueryChainWrapper<T, ?> queryChainWrapper, TypeReference<R> typeReference) {
        return this.baseMapper.one(queryChainWrapper, this.clazz, typeReference);
    }

    @Override
    public List<T> list() {
        return this.list(this.clazz);
    }

    @Override
    public <R> List<R> list(Class<R> rClazz) {
        return this.baseMapper.list(this.clazz, rClazz);
    }

    @Override
    public <R> List<R> list(TypeReference<R> typeReference) {
        return this.baseMapper.list(this.clazz, typeReference);
    }

    @Override
    public List<T> list(QueryChainWrapper<T, ?> queryChainWrapper) {
        return this.list(queryChainWrapper, this.clazz);
    }

    @Override
    public <R> List<R> list(QueryChainWrapper<T, ?> queryChainWrapper, Class<R> rClazz) {
        return this.baseMapper.list(queryChainWrapper, this.clazz, rClazz);
    }

    @Override
    public <R> List<R> list(QueryChainWrapper<T, ?> queryChainWrapper, TypeReference<R> typeReference) {
        return this.baseMapper.list(queryChainWrapper, this.clazz, typeReference);
    }

    @Override
    public long count() {
        return this.baseMapper.count(this.clazz);
    }

    @Override
    public long count(QueryChainWrapper<T, ?> queryChainWrapper) {
        return this.baseMapper.count(queryChainWrapper, this.clazz);
    }

    @Override
    public PageResult<T> page(QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize) {
        return this.page(queryChainWrapper, pageNum, pageSize, this.clazz);
    }

    @Override
    public PageResult<T> page(QueryChainWrapper<T, ?> queryChainWrapper, PageParam pageParam) {
        return this.page(queryChainWrapper, pageParam.getPageNum(), pageParam.getPageSize());
    }

    @Override
    public PageResult<T> page(QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, Integer recentPageNum) {
        return this.page(queryChainWrapper, pageNum, pageSize, recentPageNum, this.clazz);
    }

    @Override
    public PageResult<T> page(QueryChainWrapper<T, ?> queryChainWrapper, PageParam pageParam, Integer recentPageNum) {
        return this.page(queryChainWrapper, pageParam.getPageNum(), pageParam.getPageSize(), recentPageNum);
    }

    @Override
    public <R> PageResult<R> page(Integer pageNum, Integer pageSize, Integer recentPageNum, Class<R> rClazz) {
        return this.baseMapper.page(new QueryWrapper(), pageNum, pageSize, recentPageNum, this.clazz, rClazz);
    }

    @Override
    public <R> PageResult<R> page(Integer pageNum, Integer pageSize, Integer recentPageNum, TypeReference<R> typeReference) {
        return this.baseMapper.page(new QueryWrapper(), pageNum, pageSize, recentPageNum, this.clazz, typeReference);
    }

    @Override
    public <R> PageResult<R> page(QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, Class<R> rClazz) {
        return this.baseMapper.page(queryChainWrapper, pageNum, pageSize, this.clazz, rClazz);
    }

    @Override
    public <R> PageResult<R> page(QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, TypeReference<R> typeReference) {
        return this.baseMapper.page(queryChainWrapper, pageNum, pageSize, this.clazz, typeReference);
    }

    @Override
    public <R> PageResult<R> page(QueryChainWrapper<T, ?> queryChainWrapper, PageParam pageParam, Class<R> rClazz) {
        return this.baseMapper.page(queryChainWrapper, pageParam.getPageNum(), pageParam.getPageSize(), this.clazz, rClazz);
    }

    @Override
    public <R> PageResult<R> page(QueryChainWrapper<T, ?> queryChainWrapper, PageParam pageParam, TypeReference<R> typeReference) {
        return this.baseMapper.page(queryChainWrapper, pageParam.getPageNum(), pageParam.getPageSize(), this.clazz, typeReference);
    }

    @Override
    public <R> PageResult<R> page(QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, Integer recentPageNum, Class<R> rClazz) {
        return this.baseMapper.page(queryChainWrapper, pageNum, pageSize, recentPageNum, this.clazz, rClazz);
    }

    @Override
    public <R> PageResult<R> page(QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, Integer recentPageNum, TypeReference<R> typeReference) {
        return this.baseMapper.page(queryChainWrapper, pageNum, pageSize, recentPageNum, this.clazz, typeReference);
    }

    @Override
    public <R> PageResult<R> page(QueryChainWrapper<T, ?> queryChainWrapper, PageParam pageParam, Integer recentPageNum, Class<R> rClazz) {
        return this.baseMapper.page(queryChainWrapper, pageParam.getPageNum(), pageParam.getPageSize(), recentPageNum, this.clazz, rClazz);
    }

    @Override
    public <R> PageResult<R> page(QueryChainWrapper<T, ?> queryChainWrapper, PageParam pageParam, Integer recentPageNum, TypeReference<R> typeReference) {
        return this.baseMapper.page(queryChainWrapper, pageParam.getPageNum(), pageParam.getPageSize(), recentPageNum, this.clazz, typeReference);
    }

    @Override
    public List<T> pageList(PageParam pageParam) {
        return this.pageList(pageParam.getPageNum(), pageParam.getPageSize());
    }

    @Override
    public <R> List<R> pageList(PageParam pageParam, Class<R> rClazz) {
        return this.pageList(pageParam.getPageNum(), pageParam.getPageSize(), rClazz);
    }

    @Override
    public <R> List<R> pageList(PageParam pageParam, TypeReference<R> typeReference) {
        return this.pageList(pageParam.getPageNum(), pageParam.getPageSize(), typeReference);
    }

    @Override
    public List<T> pageList(Integer pageNum, Integer pageSize) {
        return this.pageList(new QueryWrapper(), pageNum, pageSize, this.clazz);
    }

    @Override
    public <R> List<R> pageList(Integer pageNum, Integer pageSize, Class<R> rClazz) {
        return this.baseMapper.pageList(new QueryWrapper(), pageNum, pageSize, this.clazz, rClazz);
    }

    @Override
    public <R> List<R> pageList(Integer pageNum, Integer pageSize, TypeReference<R> typeReference) {
        return this.baseMapper.pageList(new QueryWrapper(), pageNum, pageSize, this.clazz, typeReference);
    }

    @Override
    public List<T> pageList(QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize) {
        return this.pageList(queryChainWrapper, pageNum, pageSize, this.clazz);
    }

    @Override
    public <R> List<R> pageList(QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, Class<R> rClazz) {
        return this.baseMapper.pageList(queryChainWrapper, pageNum, pageSize, this.clazz, rClazz);
    }

    @Override
    public <R> List<R> pageList(QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, TypeReference<R> typeReference) {
        return this.baseMapper.pageList(queryChainWrapper, pageNum, pageSize, this.clazz, typeReference);
    }

    @Override
    public List<T> pageList(QueryChainWrapper<T, ?> queryChainWrapper, PageParam pageParam) {
        return this.pageList(queryChainWrapper, pageParam.getPageNum(), pageParam.getPageSize(), this.clazz);
    }

    @Override
    public <R> List<R> pageList(QueryChainWrapper<T, ?> queryChainWrapper, PageParam pageParam, Class<R> rClazz) {
        return this.baseMapper.pageList(queryChainWrapper, pageParam.getPageNum(), pageParam.getPageSize(), this.clazz, rClazz);
    }

    @Override
    public <R> List<R> pageList(QueryChainWrapper<T, ?> queryChainWrapper, PageParam pageParam, TypeReference<R> typeReference) {
        return this.baseMapper.pageList(queryChainWrapper, pageParam.getPageNum(), pageParam.getPageSize(), this.clazz, typeReference);
    }

    @Override
    public PageResult<T> page(PageParam pageParam) {
        return this.page(pageParam.getPageNum(), pageParam.getPageSize());
    }

    @Override
    public <R> PageResult<R> page(PageParam pageParam, Class<R> rClazz) {
        return this.page(pageParam.getPageNum(), pageParam.getPageSize(), rClazz);
    }

    @Override
    public <R> PageResult<R> page(PageParam pageParam, TypeReference<R> typeReference) {
        return this.page(pageParam.getPageNum(), pageParam.getPageSize(), typeReference);
    }

    @Override
    public PageResult<T> page(PageParam pageParam, Integer recentPageNum) {
        return this.page(pageParam.getPageNum(), pageParam.getPageSize(), recentPageNum);
    }

    @Override
    public <R> PageResult<R> page(PageParam pageParam, Integer recentPageNum, Class<R> rClazz) {
        return this.page(pageParam.getPageNum(), pageParam.getPageSize(), recentPageNum, rClazz);
    }

    @Override
    public <R> PageResult<R> page(PageParam pageParam, Integer recentPageNum, TypeReference<R> typeReference) {
        return this.page(pageParam.getPageNum(), pageParam.getPageSize(), recentPageNum, typeReference);
    }

    @Override
    public PageResult<T> page(Integer pageNum, Integer pageSize) {
        return this.page(new QueryWrapper(), pageNum, pageSize);
    }

    @Override
    public <R> PageResult<R> page(Integer pageNum, Integer pageSize, Class<R> rClazz) {
        return this.baseMapper.page(new QueryWrapper(), pageNum, pageSize, this.clazz, rClazz);
    }

    @Override
    public <R> PageResult<R> page(Integer pageNum, Integer pageSize, TypeReference<R> typeReference) {
        return this.baseMapper.page(new QueryWrapper(), pageNum, pageSize, this.clazz, typeReference);
    }

    @Override
    public PageResult<T> page(Integer pageNum, Integer pageSize, Integer recentPageNum) {
        return this.page(new QueryWrapper(), pageNum, pageSize, recentPageNum, this.clazz);
    }

    @Override
    public T getById(Serializable id) {
        return this.getById(id, this.clazz);
    }

    @Override
    public <R> R getById(Serializable id, Class<R> rClazz) {
        return this.baseMapper.getById(id, this.clazz, rClazz);
    }

    @Override
    public <R> R getById(Serializable id, TypeReference<R> typeReference) {
        return this.baseMapper.getById(id, this.clazz, typeReference);
    }

    @Override
    public List<T> getByIds(Collection<? extends Serializable> ids) {
        return this.getByIds(ids, this.clazz);
    }

    @Override
    public <R> List<R> getByIds(Collection<? extends Serializable> ids, Class<R> rClazz) {
        return this.baseMapper.getByIds(ids, this.clazz, rClazz);
    }

    @Override
    public <R> List<R> getByIds(Collection<? extends Serializable> ids, TypeReference<R> typeReference) {
        return this.baseMapper.getByIds(ids, this.clazz, typeReference);
    }

    @Override
    public List<T> queryCommand(String command) {
        return this.queryCommand(command, this.clazz);
    }

    @Override
    public <R> List<R> queryCommand(String command, Class<R> rClazz) {
        return this.baseMapper.queryCommand(command, this.clazz, rClazz);
    }

    @Override
    public <R> List<R> queryCommand(String command, TypeReference<R> typeReference) {
        return this.baseMapper.queryCommand(command, this.clazz, typeReference);
    }

    @Override
    public List<T> getByColumn(SFunction<T, Object> field, Object fieldValue) {
        return this.getByColumn(field.getFieldNameLine(), fieldValue, this.clazz);
    }

    @Override
    public <R> List<R> getByColumn(SFunction<T, Object> field, Object fieldValue, Class<R> rClazz) {
        return this.baseMapper.getByColumn(field.getFieldNameLine(), fieldValue, this.clazz, rClazz);
    }

    @Override
    public <R> List<R> getByColumn(SFunction<T, Object> field, Object fieldValue, TypeReference<R> typeReference) {
        return this.baseMapper.getByColumn(field.getFieldNameLine(), fieldValue, this.clazz, typeReference);
    }

    @Override
    public List<T> getByColumn(String field, Object fieldValue) {
        return this.getByColumn(field, fieldValue, this.clazz);
    }

    @Override
    public <R> List<R> getByColumn(String field, Object fieldValue, Class<R> rClazz) {
        return this.baseMapper.getByColumn(field, fieldValue, this.clazz, rClazz);
    }

    @Override
    public <R> List<R> getByColumn(String field, Object fieldValue, TypeReference<R> typeReference) {
        return this.baseMapper.getByColumn(field, fieldValue, this.clazz, typeReference);
    }

    @Override
    public Boolean exist(Serializable id) {
        return this.baseMapper.isExist(id, this.clazz);
    }

    @Override
    public Boolean exist(QueryChainWrapper<T, ?> queryChainWrapper) {
        return this.baseMapper.isExist(queryChainWrapper, this.clazz);
    }

    @Override
    public String createIndex(Bson bson) {
        return this.baseMapper.createIndex(bson, this.clazz);
    }

    @Override
    public String createIndex(Bson bson, IndexOptions indexOptions) {
        return this.baseMapper.createIndex(bson, indexOptions, this.clazz);
    }

    @Override
    public List<String> createIndexes(List<IndexModel> indexes) {
        return this.baseMapper.createIndexes(indexes, this.clazz);
    }

    @Override
    public List<String> createIndexes(List<IndexModel> indexes, CreateIndexOptions createIndexOptions) {
        return this.baseMapper.createIndexes(indexes, createIndexOptions, this.clazz);
    }

    @Override
    public List<Document> listIndexes() {
        return this.baseMapper.listIndexes(this.clazz);
    }

    @Override
    public void dropIndex(String indexName) {
        this.baseMapper.dropIndex(indexName, this.clazz);
    }

    @Override
    public void dropIndex(String indexName, DropIndexOptions dropIndexOptions) {
        this.baseMapper.dropIndex(indexName, dropIndexOptions, this.clazz);
    }

    @Override
    public void dropIndex(Bson keys) {
        this.baseMapper.dropIndex(keys, this.clazz);
    }

    @Override
    public void dropIndex(Bson keys, DropIndexOptions dropIndexOptions) {
        this.baseMapper.dropIndex(keys, dropIndexOptions, this.clazz);
    }

    @Override
    public void dropIndexes() {
        this.baseMapper.dropIndexes(this.clazz);
    }

    @Override
    public void dropIndexes(DropIndexOptions dropIndexOptions) {
        this.baseMapper.dropIndexes(dropIndexOptions, this.clazz);
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    @Override
    public LambdaQueryChainWrapper<T> lambdaQuery() {
        return ChainWrappers.lambdaQueryChain(this.baseMapper, this.clazz);
    }

    @Override
    public LambdaAggregateChainWrapper<T> lambdaAggregate() {
        return ChainWrappers.lambdaAggregatesChain(this.baseMapper, this.clazz);
    }

    @Override
    public LambdaAggregateChainWrapper<T> lambdaAggregates() {
        return ChainWrappers.lambdaAggregatesChain(this.baseMapper, this.clazz);
    }

    @Override
    public LambdaUpdateChainWrapper<T> lambdaUpdate() {
        return ChainWrappers.lambdaUpdateChain(this.baseMapper, this.clazz);
    }
}

