/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.proxy;

import com.anwen.mongo.cache.global.ExecutorProxyCache;
import com.anwen.mongo.cache.global.ExecutorReplacerCache;
import com.anwen.mongo.cache.global.InterceptorCache;
import com.anwen.mongo.enums.ExecuteMethodEnum;
import com.anwen.mongo.execute.Execute;
import com.anwen.mongo.interceptor.Interceptor;
import com.anwen.mongo.replacer.Replacer;
import com.anwen.mongo.strategy.executor.MethodExecutorStrategy;
import com.mongodb.client.MongoCollection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import org.bson.Document;

public class ExecutorProxy
implements InvocationHandler {
    private final Execute target;

    public ExecutorProxy(Execute target) {
        this.target = target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ExecuteMethodEnum executeMethodEnum = ExecuteMethodEnum.getMethod((String)method.getName());
        MethodExecutorStrategy executor = ExecutorProxyCache.EXECUTOR_MAP.get(executeMethodEnum);
        MongoCollection collection = (MongoCollection)args[args.length - 1];
        if (Objects.nonNull(executor)) {
            InterceptorCache.interceptors.forEach(interceptor -> {
                interceptor.beforeExecute(executeMethodEnum, args, (MongoCollection<Document>)collection);
                executor.invoke((Interceptor)interceptor, args);
            });
        }
        for (Replacer replacer : ExecutorReplacerCache.replacers) {
            if (!replacer.supplier().get(proxy, this.target, method, args)) continue;
            return replacer.invoke(proxy, this.target, method, args);
        }
        Object invoke = method.invoke((Object)this.target, args);
        InterceptorCache.interceptors.forEach(interceptor -> interceptor.afterExecute(executeMethodEnum, args, invoke, (MongoCollection<Document>)collection));
        return invoke;
    }
}

