/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.model;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class PageResult<T>
implements Serializable {
    private static final long serialVersionUID = 4737078483619467352L;
    private long pageNum;
    private long pageSize;
    private long totalSize;
    private long totalPages;
    private List<T> contentData;
    private boolean isFirstPage = false;
    private boolean isLastPage = false;
    private boolean hasPreviousPage = false;
    private boolean hasNextPage = false;

    public long getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(long pageNum) {
        this.pageNum = pageNum;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public long getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(long totalPages) {
        this.totalPages = totalPages;
    }

    public List<T> getContentData() {
        return this.contentData;
    }

    public void setContentData(List<T> contentData) {
        this.contentData = contentData;
    }

    public boolean isFirstPage() {
        return this.isFirstPage;
    }

    public void setFirstPage(boolean firstPage) {
        this.isFirstPage = firstPage;
    }

    public boolean isLastPage() {
        return this.isLastPage;
    }

    public void setLastPage(boolean lastPage) {
        this.isLastPage = lastPage;
    }

    public boolean isHasPreviousPage() {
        return this.hasPreviousPage;
    }

    public void setHasPreviousPage(boolean hasPreviousPage) {
        this.hasPreviousPage = hasPreviousPage;
    }

    public boolean isHasNextPage() {
        return this.hasNextPage;
    }

    public void setHasNextPage(boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PageResult that = (PageResult)object;
        return this.pageNum == that.pageNum && this.pageSize == that.pageSize && this.totalSize == that.totalSize && this.totalPages == that.totalPages && this.isFirstPage == that.isFirstPage && this.isLastPage == that.isLastPage && this.hasPreviousPage == that.hasPreviousPage && this.hasNextPage == that.hasNextPage && Objects.equals(this.contentData, that.contentData);
    }

    public int hashCode() {
        return Objects.hash(this.pageNum, this.pageSize, this.totalSize, this.totalPages, this.contentData, this.isFirstPage, this.isLastPage, this.hasPreviousPage, this.hasNextPage);
    }

    public String toString() {
        return "{\"pageNum\": " + this.pageNum + ",\"pageSize\": " + this.pageSize + ",\"totalSize\": " + this.totalSize + ",\"totalPages\": " + this.totalPages + ",\"isFirstPage\": " + this.isFirstPage + ",\"isLastPage\": " + this.isLastPage + ",\"hasPreviousPage\": " + this.hasPreviousPage + ",\"hasNextPage\": " + this.hasNextPage + ",\"contentData\": " + this.contentData + '}';
    }

    public PageResult(long pageNum, long pageSize, long totalSize, long totalPages, List<T> contentData) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.totalSize = totalSize;
        this.totalPages = totalPages;
        this.contentData = contentData;
        this.isFirstPage = pageNum == 1L;
        this.isLastPage = pageNum == totalPages || totalPages == 0L;
        this.hasPreviousPage = pageNum > 1L;
        this.hasNextPage = pageNum < totalPages;
    }

    public PageResult() {
    }
}

