/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.model;

import com.anwen.mongo.support.SFunction;
import com.mongodb.assertions.Assertions;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Indexes {
    private Indexes() {
    }

    public static Bson ascending(String ... fieldNames) {
        return Indexes.ascending(Arrays.asList(fieldNames));
    }

    @SafeVarargs
    public static <T> Bson ascendingFunc(SFunction<T, Object> ... fieldNames) {
        return Indexes.ascendingFunc(Arrays.asList(fieldNames));
    }

    public static Bson ascending(List<String> fieldNames) {
        Assertions.notNull((String)"fieldNames", fieldNames);
        return Indexes.compoundIndex(fieldNames, (BsonValue)new BsonInt32(1));
    }

    public static <T> Bson ascendingFunc(List<SFunction<T, Object>> fieldNames) {
        Assertions.notNull((String)"fieldNames", fieldNames);
        return Indexes.compoundIndex(fieldNames.stream().map(SFunction::getFieldNameLine).collect(Collectors.toList()), (BsonValue)new BsonInt32(1));
    }

    public static Bson descending(String ... fieldNames) {
        return Indexes.descending(Arrays.asList(fieldNames));
    }

    @SafeVarargs
    public static <T> Bson descendingFunc(SFunction<T, Object> ... fieldNames) {
        return Indexes.descendingFunc(Arrays.asList(fieldNames));
    }

    public static Bson descending(List<String> fieldNames) {
        Assertions.notNull((String)"fieldNames", fieldNames);
        return Indexes.compoundIndex(fieldNames, (BsonValue)new BsonInt32(-1));
    }

    public static <T> Bson descendingFunc(List<SFunction<T, Object>> fieldNames) {
        Assertions.notNull((String)"fieldNames", fieldNames);
        return Indexes.compoundIndex(fieldNames.stream().map(SFunction::getFieldNameLine).collect(Collectors.toList()), (BsonValue)new BsonInt32(-1));
    }

    public static Bson geo2dsphere(String ... fieldNames) {
        return Indexes.geo2dsphere(Arrays.asList(fieldNames));
    }

    public static <T> Bson geo2dsphereFunc(SFunction<T, Object> ... fieldNames) {
        return Indexes.geo2dsphereFunc(Arrays.asList(fieldNames));
    }

    public static Bson geo2dsphere(List<String> fieldNames) {
        Assertions.notNull((String)"fieldNames", fieldNames);
        return Indexes.compoundIndex(fieldNames, (BsonValue)new BsonString("2dsphere"));
    }

    public static <T> Bson geo2dsphereFunc(List<SFunction<T, Object>> fieldNames) {
        Assertions.notNull((String)"fieldNames", fieldNames);
        return Indexes.compoundIndex(fieldNames.stream().map(SFunction::getFieldNameLine).collect(Collectors.toList()), (BsonValue)new BsonString("2dsphere"));
    }

    public static Bson geo2d(String fieldName) {
        Assertions.notNull((String)"fieldName", (Object)fieldName);
        return new BsonDocument(fieldName, (BsonValue)new BsonString("2d"));
    }

    public static <T> Bson geo2d(SFunction<T, Object> fieldName) {
        Assertions.notNull((String)"fieldName", fieldName);
        return new BsonDocument(fieldName.getFieldNameLine(), (BsonValue)new BsonString("2d"));
    }

    @Deprecated
    public static Bson geoHaystack(String fieldName, Bson additional) {
        Assertions.notNull((String)"fieldName", (Object)fieldName);
        return Indexes.compoundIndex(new Bson[]{new BsonDocument(fieldName, (BsonValue)new BsonString("geoHaystack")), additional});
    }

    @Deprecated
    public static <T> Bson geoHaystack(SFunction<T, Object> fieldName, Bson additional) {
        Assertions.notNull((String)"fieldName", fieldName);
        return Indexes.compoundIndex(new Bson[]{new BsonDocument(fieldName.getFieldNameLine(), (BsonValue)new BsonString("geoHaystack")), additional});
    }

    public static Bson text(String fieldName) {
        Assertions.notNull((String)"fieldName", (Object)fieldName);
        return new BsonDocument(fieldName, (BsonValue)new BsonString("text"));
    }

    public static <T> Bson text(SFunction<T, Object> fieldName) {
        Assertions.notNull((String)"fieldName", fieldName);
        return new BsonDocument(fieldName.getFieldNameLine(), (BsonValue)new BsonString("text"));
    }

    public static Bson text() {
        return Indexes.text("$**");
    }

    public static Bson hashed(String fieldName) {
        Assertions.notNull((String)"fieldName", (Object)fieldName);
        return new BsonDocument(fieldName, (BsonValue)new BsonString("hashed"));
    }

    public static <T> Bson hashed(SFunction<T, Object> fieldName) {
        Assertions.notNull((String)"fieldName", fieldName);
        return new BsonDocument(fieldName.getFieldNameLine(), (BsonValue)new BsonString("hashed"));
    }

    public static Bson compoundIndex(Bson ... indexes) {
        return Indexes.compoundIndex(Arrays.asList(indexes));
    }

    public static Bson compoundIndex(List<? extends Bson> indexes) {
        return new CompoundIndex(indexes);
    }

    private static Bson compoundIndex(List<String> fieldNames, BsonValue value) {
        BsonDocument document = new BsonDocument();
        for (String fieldName : fieldNames) {
            document.append(fieldName, value);
        }
        return document;
    }

    private static class CompoundIndex
    implements Bson {
        private final List<? extends Bson> indexes;

        CompoundIndex(List<? extends Bson> indexes) {
            Assertions.notNull((String)"indexes", indexes);
            this.indexes = indexes;
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocument compoundIndex = new BsonDocument();
            for (Bson bson : this.indexes) {
                BsonDocument indexDocument = bson.toBsonDocument(documentClass, codecRegistry);
                for (String key : indexDocument.keySet()) {
                    compoundIndex.append(key, indexDocument.get((Object)key));
                }
            }
            return compoundIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompoundIndex that = (CompoundIndex)o;
            return this.indexes.equals(that.indexes);
        }

        public int hashCode() {
            return this.indexes.hashCode();
        }
    }
}

