/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.model;

import com.anwen.mongo.bson.MongoPlusDocument;
import com.anwen.mongo.mapping.TypeInformation;
import com.anwen.mongo.support.SFunction;
import java.util.Map;
import org.bson.Document;

public class AutoFillMetaObject {
    private final MongoPlusDocument document;
    private final MongoPlusDocument autoFillDocument;
    private TypeInformation targetObject;

    public AutoFillMetaObject() {
        this.document = new MongoPlusDocument();
        this.autoFillDocument = new MongoPlusDocument();
    }

    public AutoFillMetaObject(MongoPlusDocument document) {
        this.document = document;
        this.autoFillDocument = new MongoPlusDocument();
    }

    public AutoFillMetaObject(MongoPlusDocument document, MongoPlusDocument autoFillDocument) {
        this.document = document;
        this.autoFillDocument = autoFillDocument;
    }

    public MongoPlusDocument getAllFillField() {
        return this.autoFillDocument;
    }

    public MongoPlusDocument getDocument() {
        return this.document;
    }

    public void getAllFillFieldAndClear(Document document) {
        document.putAll((Map)((Object)this.autoFillDocument));
        this.autoFillDocument.clear();
        this.targetObject = null;
    }

    public boolean isEmpty() {
        return this.document.isEmpty();
    }

    public <T, R> void fillValue(SFunction<T, R> column, Object value) {
        if (this.metaObjectExist(column)) {
            this.autoFillDocument.put(column, value);
        }
    }

    public <T, R> void forceFillValue(SFunction<T, R> column, Object value) {
        this.autoFillDocument.put(column, value);
    }

    public void fillValue(String column, Object value) {
        if (this.metaObjectExist(column)) {
            this.autoFillDocument.put(column, value);
        }
    }

    public void forceFillValue(String column, Object value) {
        this.autoFillDocument.put(column, value);
    }

    public <T, R> boolean metaObjectExist(SFunction<T, R> column) {
        return this.document.containsKey(column);
    }

    public boolean metaObjectExist(String column) {
        return this.document.containsKey(column);
    }

    public <T, R> Object getMetaObjectValue(SFunction<T, R> column) {
        return this.autoFillDocument.get(column);
    }

    public Object getMetaObjectValue(String column) {
        return this.autoFillDocument.get(column);
    }

    public TypeInformation getTargetObject() {
        return this.targetObject;
    }

    public void setTargetObject(TypeInformation targetObject) {
        this.targetObject = targetObject;
    }
}

