/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.mapping;

import com.anwen.mongo.cache.global.SimpleCache;
import com.anwen.mongo.domain.MongoPlusFieldException;
import com.anwen.mongo.mapping.FieldInformation;
import com.anwen.mongo.mapping.SimpleFieldInformation;
import com.anwen.mongo.mapping.TypeInformation;
import com.anwen.mongo.toolkit.ArrayUtils;
import com.anwen.mongo.toolkit.ClassTypeUtil;
import com.anwen.mongo.toolkit.CollUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SimpleTypeInformation<T>
implements TypeInformation {
    private T instance;
    private final Class<?> clazz;
    private Type[] types;
    private final Map<String, FieldInformation> fieldMap = new HashMap<String, FieldInformation>();
    private final List<FieldInformation> fieldList = new ArrayList<FieldInformation>();
    private final Map<Class<? extends Annotation>, List<FieldInformation>> annotationFieldMap = new HashMap<Class<? extends Annotation>, List<FieldInformation>>();

    private SimpleTypeInformation(T instance, Class<?> clazz) {
        this.instance = instance;
        this.clazz = clazz;
    }

    protected SimpleTypeInformation(T instance, Type[] types) {
        this.instance = instance;
        this.clazz = SimpleTypeInformation.getInstanceClass(instance);
        this.types = types;
    }

    private static Class<?> getInstanceClass(Object instance) {
        Class<?> instanceClass = instance.getClass();
        if (ClassTypeUtil.isAnonymousClass(instanceClass).booleanValue()) {
            instanceClass = instanceClass.getSuperclass();
        }
        return instanceClass;
    }

    @Override
    public Class<?> getClazz() {
        return this.clazz;
    }

    @Override
    public Boolean isMap() {
        return ClassTypeUtil.isTargetClass(Map.class, this.clazz);
    }

    @Override
    public Boolean isCollection() {
        return ClassTypeUtil.isTargetClass(Collection.class, this.clazz);
    }

    @Override
    public Boolean isSimpleType() {
        return SimpleCache.getSimpleTypeHolder().isSimpleType(this.clazz);
    }

    @Override
    public Type[] getType() {
        if (ArrayUtils.isEmpty(this.types)) {
            this.types = this.clazz.getTypeParameters();
        }
        return this.types;
    }

    @Override
    public T getInstance() {
        return this.instance;
    }

    public static <T> TypeInformation of(T instance) {
        return new SimpleTypeInformation<T>(instance, SimpleTypeInformation.getInstanceClass(instance));
    }

    @Override
    public void setInstance(Object instance) {
        this.instance = instance;
    }

    @Override
    public List<FieldInformation> getFields() {
        if (CollUtil.isEmpty(this.fieldList)) {
            Arrays.stream(this.clazz.getDeclaredFields()).forEach(field -> {
                field.setAccessible(true);
                if (Modifier.isStatic(field.getModifiers())) {
                    return;
                }
                this.fieldList.add(new SimpleFieldInformation<T>(this.instance, (Field)field));
            });
            this.getSupperFields(this.clazz.getSuperclass());
        }
        return this.fieldList;
    }

    @Override
    public FieldInformation getField(String fieldName) {
        if (!this.fieldMap.containsKey(fieldName)) {
            try {
                this.fieldMap.put(fieldName, new SimpleFieldInformation<T>(this.instance, this.clazz.getField(fieldName)));
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        return this.fieldMap.get(fieldName);
    }

    @Override
    public List<FieldInformation> getAnnotationFields(Class<? extends Annotation> annotationClass) {
        if (!this.annotationFieldMap.containsKey(annotationClass)) {
            this.annotationFieldMap.put(annotationClass, this.getFields().stream().filter(field -> field.getField().getAnnotation(annotationClass) != null).collect(Collectors.toList()));
        }
        return this.annotationFieldMap.get(annotationClass);
    }

    @Override
    public FieldInformation getAnnotationField(Class<? extends Annotation> annotationClass, String nullMessage) {
        List<FieldInformation> fieldList = this.getAnnotationFields(annotationClass);
        if (CollUtil.isEmpty(fieldList)) {
            throw new MongoPlusFieldException(nullMessage);
        }
        return fieldList.get(0);
    }

    @Override
    public FieldInformation getAnnotationField(Class<? extends Annotation> annotationClass) {
        List<FieldInformation> fieldList = this.getAnnotationFields(annotationClass);
        if (CollUtil.isEmpty(fieldList)) {
            return null;
        }
        return fieldList.get(0);
    }

    @Override
    public Object getAnnotationFieldValue(Class<? extends Annotation> annotationClass, String nullMessage) {
        return this.getAnnotationField(annotationClass, nullMessage).getValue();
    }

    @Override
    public Object getAnnotationFieldValue(Class<? extends Annotation> annotationClass) {
        return this.getAnnotationField(annotationClass).getValue();
    }

    private void getSupperFields(Class<?> clazz) {
        if (clazz != null && !clazz.equals(Object.class)) {
            Arrays.asList(clazz.getDeclaredFields()).forEach(field -> {
                field.setAccessible(true);
                if (Modifier.isStatic(field.getModifiers())) {
                    return;
                }
                this.fieldList.add(new SimpleFieldInformation<T>(this.instance, (Field)field));
            });
            this.getSupperFields(clazz.getSuperclass());
        }
    }
}

