/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.mapping;

import com.anwen.mongo.toolkit.Assert;
import com.anwen.mongo.toolkit.ClassTypeUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.BsonValue;
import org.bson.types.ObjectId;

public class SimpleTypeHolder {
    private static final Set<Class<?>> DEFAULTS;
    private final Map<Class<?>, Boolean> simpleTypes;
    private final Map<Class<?>, Boolean> mongoType = new ConcurrentHashMap();

    public SimpleTypeHolder() {
        this(Collections.emptySet(), true);
    }

    public SimpleTypeHolder(Set<? extends Class<?>> customSimpleTypes, boolean registerDefaults) {
        Assert.notNull(customSimpleTypes, "CustomSimpleTypes must not be null");
        this.simpleTypes = new ConcurrentHashMap(customSimpleTypes.size() + DEFAULTS.size());
        this.register(customSimpleTypes);
        if (registerDefaults) {
            this.register(DEFAULTS);
        }
    }

    public SimpleTypeHolder(Set<? extends Class<?>> customSimpleTypes, SimpleTypeHolder source) {
        Assert.notNull(customSimpleTypes, "CustomSimpleTypes must not be null");
        Assert.notNull((Object)source, "SourceTypeHolder must not be null");
        this.simpleTypes = new ConcurrentHashMap(customSimpleTypes.size() + source.simpleTypes.size());
        this.register(customSimpleTypes);
        this.registerCachePositives(source.simpleTypes);
    }

    private void registerCachePositives(Map<Class<?>, Boolean> source) {
        for (Map.Entry<Class<?>, Boolean> entry : source.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            this.simpleTypes.put(entry.getKey(), true);
        }
    }

    public boolean isMongoType(Class<?> type) {
        Assert.notNull(type, "Type must not be null");
        return ObjectId.class.equals(type) || ClassTypeUtil.isTargetClass(BsonValue.class, type) != false;
    }

    public boolean isSimpleType(Class<?> type) {
        Assert.notNull(type, "Type must not be null");
        Boolean isSimpleType = this.simpleTypes.get(type);
        if (Object.class.equals(type) || ClassTypeUtil.isTargetClass(Enum.class, type).booleanValue()) {
            return true;
        }
        if (isSimpleType != null) {
            return isSimpleType;
        }
        String typeName = type.getName();
        if (typeName.startsWith("java.lang") || typeName.startsWith("java.time") || typeName.equals("kotlin.Unit")) {
            return true;
        }
        this.simpleTypes.put(type, false);
        return false;
    }

    private void register(Collection<? extends Class<?>> types) {
        types.forEach(customSimpleType -> this.simpleTypes.put((Class<?>)customSimpleType, true));
    }

    static {
        HashSet<Class<Object>> defaults = new HashSet<Class<Object>>();
        defaults.add(Boolean.TYPE);
        defaults.add(boolean[].class);
        defaults.add(Long.TYPE);
        defaults.add(long[].class);
        defaults.add(Short.TYPE);
        defaults.add(short[].class);
        defaults.add(Integer.TYPE);
        defaults.add(int[].class);
        defaults.add(Byte.TYPE);
        defaults.add(byte[].class);
        defaults.add(Float.TYPE);
        defaults.add(float[].class);
        defaults.add(Double.TYPE);
        defaults.add(double[].class);
        defaults.add(Character.TYPE);
        defaults.add(char[].class);
        defaults.add(Boolean.class);
        defaults.add(Long.class);
        defaults.add(Short.class);
        defaults.add(Integer.class);
        defaults.add(Byte.class);
        defaults.add(Float.class);
        defaults.add(Double.class);
        defaults.add(Character.class);
        defaults.add(String.class);
        defaults.add(Date.class);
        defaults.add(Locale.class);
        defaults.add(Class.class);
        defaults.add(Enum.class);
        defaults.add(BigDecimal.class);
        defaults.add(BigInteger.class);
        DEFAULTS = Collections.unmodifiableSet(defaults);
    }
}

