/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.mapping;

import com.anwen.mongo.annotation.ID;
import com.anwen.mongo.annotation.collection.CollectionField;
import com.anwen.mongo.cache.global.FieldCache;
import com.anwen.mongo.cache.global.PropertyCache;
import com.anwen.mongo.cache.global.SimpleCache;
import com.anwen.mongo.domain.MongoPlusFieldException;
import com.anwen.mongo.mapping.FieldInformation;
import com.anwen.mongo.mapping.SimpleTypeInformation;
import com.anwen.mongo.mapping.TypeInformation;
import com.anwen.mongo.toolkit.ArrayUtils;
import com.anwen.mongo.toolkit.ClassTypeUtil;
import com.anwen.mongo.toolkit.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

public class SimpleFieldInformation<T>
implements FieldInformation {
    private Object value;
    private String name;
    private Class<?> mapValueType;
    private Class<?> collectionValueType = Object.class;
    private final Field field;
    private ID id;
    private CollectionField collectionField;
    private Method get;
    private Method set;
    private Type[] types;
    private String camelCaseName;
    private final Class<?> typeClass;
    private final T instance;

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    @Override
    public Type[] getType() {
        if (ArrayUtils.isEmpty(this.types)) {
            try {
                this.types = ((ParameterizedType)this.getGenericType()).getActualTypeArguments();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.types;
    }

    @Override
    public TypeInformation getTypeInformation() {
        return new SimpleTypeInformation(this.getTypeClass(), this.getType());
    }

    public SimpleFieldInformation(T instance, Field field) {
        this.instance = instance;
        field.setAccessible(true);
        this.field = field;
        this.typeClass = field.getType();
    }

    @Override
    public Object getValue() {
        if (this.value == null) {
            try {
                this.value = this.field.get(this.instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return this.value;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.field.getName();
            if (this.getCollectionField() != null && StringUtils.isNotBlank(this.getCollectionField().value())) {
                this.name = this.getCollectionField().value();
            }
        }
        return this.name;
    }

    @Override
    public String getCamelCaseName() {
        if (this.camelCaseName == null) {
            String fieldName = this.getName();
            if (PropertyCache.camelToUnderline.booleanValue() && (this.getCollectionField() == null || StringUtils.isBlank(this.getCollectionField().value()))) {
                fieldName = StringUtils.camelToUnderline(fieldName);
            }
            this.camelCaseName = fieldName;
        }
        return this.camelCaseName;
    }

    @Override
    public String getIdOrCamelCaseName() {
        return this.isId() ? "_id" : this.getCamelCaseName();
    }

    @Override
    public boolean isMap() {
        return ClassTypeUtil.isTargetClass(Map.class, this.typeClass);
    }

    @Override
    public Class<?> mapValueType() {
        if (this.isMap() && this.mapValueType == null) {
            Type[] typeArguments = ((ParameterizedType)this.getGenericType()).getActualTypeArguments();
            this.mapValueType = (Class)typeArguments[1];
        }
        return this.mapValueType;
    }

    @Override
    public Class<?> collectionValueType() {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        Type genericType;
        if (this.isCollection() && this.collectionValueType == null && (genericType = this.getGenericType()) instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length > 0 && actualTypeArguments[0] instanceof Class) {
            this.collectionValueType = (Class)actualTypeArguments[0];
        }
        return this.collectionValueType;
    }

    @Override
    public boolean isCollection() {
        return this.typeClass.isArray() || Iterable.class.equals(this.typeClass) || ClassTypeUtil.isTargetClass(Collection.class, this.typeClass) != false;
    }

    @Override
    public boolean isSimpleType() {
        return SimpleCache.getSimpleTypeHolder().isSimpleType(this.typeClass);
    }

    @Override
    public boolean isSkipCheckField() {
        return this.getCollectionField() != null && !this.getCollectionField().exist();
    }

    @Override
    public boolean isSkipCheckFieldAndId() {
        return this.isSkipCheckField() || this.isId();
    }

    @Override
    public boolean isId() {
        return this.getId() != null;
    }

    @Override
    public ID getId() {
        if (this.id == null) {
            this.id = this.field.getAnnotation(ID.class);
        }
        return this.id;
    }

    @Override
    public Method getMethod() {
        try {
            if (this.get == null) {
                this.get = this.instance.getClass().getMethod(this.capitalize("get", this.field.getName()), this.typeClass);
            }
        }
        catch (NoSuchMethodException e) {
            throw new MongoPlusFieldException("The get method to obtain the " + this.field.getName() + " field failed", e);
        }
        return this.get;
    }

    @Override
    public Method setMethod() {
        try {
            if (this.set == null) {
                this.set = this.instance.getClass().getMethod(this.capitalize("set", this.field.getName()), this.typeClass);
            }
        }
        catch (NoSuchMethodException e) {
            throw new MongoPlusFieldException("The set method to obtain the " + this.field.getName() + " field failed", e);
        }
        return this.set;
    }

    @Override
    public void setValue(Object value) {
        try {
            this.field.set(this.instance, value);
        }
        catch (IllegalAccessException e) {
            throw new MongoPlusFieldException("Failed to set the " + this.field.getName() + " field content", e);
        }
    }

    private String capitalize(String method, String str) {
        return method + str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    @Override
    public CollectionField getCollectionField() {
        CollectionField collectionField;
        if (FieldCache.getCollectionField(this.field) == null && (collectionField = this.field.getAnnotation(CollectionField.class)) != null) {
            FieldCache.setCollectionFieldMapCache(this.field, collectionField);
        }
        return FieldCache.getCollectionField(this.field);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.getField().getAnnotation(annotationClass);
    }

    @Override
    public boolean isAnnotation(Class<? extends Annotation> annotationClass) {
        return this.getField().isAnnotationPresent(annotationClass);
    }

    @Override
    public Type getGenericType() {
        if (FieldCache.getGenericType(this.field) == null) {
            FieldCache.setGenericTypeMapCache(this.field, this.field.getGenericType());
        }
        return FieldCache.getGenericType(this.field);
    }
}

