/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.mapping;

import com.anwen.mongo.annotation.ID;
import com.anwen.mongo.convert.Converter;
import com.anwen.mongo.domain.MongoPlusFieldException;
import com.anwen.mongo.mapping.EntityRead;
import com.anwen.mongo.mapping.FieldInformation;
import com.anwen.mongo.mapping.MongoWriter;
import com.anwen.mongo.mapping.TypeInformation;
import com.anwen.mongo.mapping.TypeReference;
import com.anwen.mongo.strategy.conversion.ConversionStrategy;
import com.anwen.mongo.toolkit.ClassTypeUtil;
import com.mongodb.client.MongoIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bson.Document;
import org.bson.conversions.Bson;

public interface MongoConverter
extends MongoWriter,
EntityRead {
    public void writeBySave(Object var1, Document var2);

    default public Document writeBySave(Object sourceObj) {
        Document document = new Document();
        this.writeBySave(sourceObj, document);
        return document;
    }

    default public Document write(Map<String, Object> map) {
        Document document = new Document();
        this.write(map, (Bson)document);
        return document;
    }

    default public List<Document> writeBatch(Collection<Map<String, Object>> sourceObjCollection, List<Document> documentList) {
        sourceObjCollection.forEach(sourceObj -> documentList.add(this.write((Map<String, Object>)sourceObj)));
        return documentList;
    }

    default public List<Document> writeBatch(final Collection<Map<String, Object>> sourceObjCollection) {
        return new ArrayList<Document>(){
            {
                sourceObjCollection.forEach((? super T sourceObj) -> this.add(MongoConverter.this.write((Map<String, Object>)sourceObj)));
            }
        };
    }

    default public void writeBySaveBatch(Collection<?> sourceObjCollection, List<Document> documentList) {
        sourceObjCollection.forEach(sourceObj -> {
            Document document = new Document();
            this.writeBySave(sourceObj, document);
            documentList.add(document);
        });
    }

    default public List<Document> writeBySaveBatch(final Collection<?> sourceObjCollection) {
        return new ArrayList<Document>(){
            {
                sourceObjCollection.forEach((? super T sourceObj) -> {
                    Document document = new Document();
                    MongoConverter.this.writeBySave(sourceObj, document);
                    this.add(document);
                });
            }
        };
    }

    public void writeByUpdate(Object var1, Document var2);

    default public Document writeByUpdate(Object sourceObj) {
        Document document = new Document();
        this.writeByUpdate(sourceObj, document);
        return document;
    }

    default public void writeByUpdateBatch(Collection<?> sourceObjCollection, List<Document> documentList) {
        sourceObjCollection.forEach(sourceObj -> {
            Document document = new Document();
            this.writeByUpdate(sourceObj, document);
            documentList.add(document);
        });
    }

    default public List<Document> writeByUpdateBatch(Collection<?> sourceObjCollection) {
        ArrayList<Document> documentList = new ArrayList<Document>();
        sourceObjCollection.forEach(sourceObj -> {
            Document document = new Document();
            this.writeByUpdate(sourceObj, document);
            documentList.add(document);
        });
        return documentList;
    }

    default public <T> T readInternal(Document document, Class<T> clazz) {
        return this.readInternal((Object)document, new TypeReference<T>(clazz){});
    }

    public <T> T readInternal(Object var1, TypeReference<T> var2);

    default public <T> List<T> read(final MongoIterable<Document> findIterable, final Class<T> clazz) {
        return new ArrayList<T>(){
            {
                findIterable.forEach(document -> this.add(MongoConverter.this.convertDocument((Document)document, clazz)));
            }
        };
    }

    default public <T> List<T> read(final MongoIterable<Document> findIterable, final TypeReference<T> typeReference) {
        return new ArrayList<T>(){
            {
                findIterable.forEach(document -> this.add(MongoConverter.this.read(document, typeReference)));
            }
        };
    }

    default public <T> T readDocument(MongoIterable<Document> findIterable, Class<?> clazz) {
        Document document = (Document)findIterable.first();
        if (document != null) {
            return (T)this.convertDocument(document, clazz);
        }
        return null;
    }

    default public <T> T readDocument(MongoIterable<Document> findIterable, TypeReference<T> typeReference) {
        Document document = (Document)findIterable.first();
        if (document != null) {
            return this.read((Object)document, typeReference);
        }
        return null;
    }

    default public <T> T convertDocument(Document document, Class<T> clazz) {
        if (ClassTypeUtil.isTargetClass(Map.class, clazz).booleanValue()) {
            return (T)Converter.convertKeysToCamelCase((Map<String, Object>)document);
        }
        return this.read(document, clazz);
    }

    default public void reSetIdValue(Object sourceObj, Document document) {
        if (Objects.isNull(sourceObj) || Objects.isNull(document) || !document.containsKey((Object)"_id")) {
            return;
        }
        if (ClassTypeUtil.isTargetClass(Map.class, sourceObj.getClass()).booleanValue()) {
            Map map = (Map)sourceObj;
            if (!map.containsKey("_id")) {
                map.put("_id", document.get((Object)"_id"));
            }
            return;
        }
        TypeInformation typeInformation = TypeInformation.of(sourceObj);
        FieldInformation idFieldInformation = typeInformation.getAnnotationField(ID.class, "@ID field not found");
        Object idValue = idFieldInformation.getValue();
        if (Objects.isNull(idValue)) {
            try {
                Object idV = document.get((Object)"_id");
                ConversionStrategy<?> conversionStrategy = this.getConversionStrategy(idFieldInformation.getTypeClass());
                if (conversionStrategy != null && idV.getClass() != idFieldInformation.getTypeClass()) {
                    idFieldInformation.setValue(conversionStrategy.convertValue(idV, idFieldInformation.getTypeClass(), this));
                } else {
                    idFieldInformation.setValue(idV);
                }
            }
            catch (Exception e) {
                throw new MongoPlusFieldException("reSet id value error", e);
            }
        }
    }

    default public <T> void batchReSetIdValue(Collection<T> entityList, List<Document> documentList) {
        int index = 0;
        for (T t : entityList) {
            Document document = documentList.get(index);
            this.reSetIdValue(t, document);
            ++index;
        }
    }

    public ConversionStrategy<?> getConversionStrategy(Class<?> var1);
}

