/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.mapping;

import com.anwen.mongo.annotation.collection.CollectionField;
import com.anwen.mongo.annotation.comm.FieldEncrypt;
import com.anwen.mongo.cache.global.ConversionCache;
import com.anwen.mongo.cache.global.PropertyCache;
import com.anwen.mongo.cache.global.SimpleCache;
import com.anwen.mongo.domain.MongoPlusWriteException;
import com.anwen.mongo.handlers.TypeHandler;
import com.anwen.mongo.logging.Log;
import com.anwen.mongo.logging.LogFactory;
import com.anwen.mongo.manager.MongoPlusClient;
import com.anwen.mongo.mapping.AbstractMongoConverter;
import com.anwen.mongo.mapping.FieldInformation;
import com.anwen.mongo.mapping.SimpleTypeHolder;
import com.anwen.mongo.mapping.TypeInformation;
import com.anwen.mongo.mapping.TypeReference;
import com.anwen.mongo.strategy.conversion.ConversionStrategy;
import com.anwen.mongo.strategy.mapping.MappingStrategy;
import com.anwen.mongo.toolkit.BsonUtil;
import com.anwen.mongo.toolkit.ClassTypeUtil;
import com.anwen.mongo.toolkit.EncryptorUtil;
import com.anwen.mongo.toolkit.StringUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bson.types.ObjectId;

public class MappingMongoConverter
extends AbstractMongoConverter {
    private final Log log = LogFactory.getLog(MappingMongoConverter.class);
    private final SimpleTypeHolder simpleTypeHolder;
    private List<Class<?>> ignoreType = new ArrayList();
    private final Map<Type, Class<?>> typeClassCache = new ConcurrentHashMap();
    private final Map<Type, Type> genericTypeCache = new ConcurrentHashMap<Type, Type>();

    public MappingMongoConverter(MongoPlusClient mongoPlusClient) {
        super(mongoPlusClient);
        this.simpleTypeHolder = SimpleCache.getSimpleTypeHolder();
        this.ignoreType.add(ObjectId.class);
        this.ignoreType.add(Binary.class);
    }

    public MappingMongoConverter(MongoPlusClient mongoPlusClient, List<Class<?>> ignoreType) {
        super(mongoPlusClient);
        this.simpleTypeHolder = SimpleCache.getSimpleTypeHolder();
        this.ignoreType = ignoreType;
    }

    @Override
    public void write(Object sourceObj, Bson bson, TypeInformation typeInformation) {
        this.processFields(typeInformation.getFields(), bson, true);
    }

    public Bson writeInternal(Object sourceObj, Bson bson) {
        this.processFields(TypeInformation.of(sourceObj).getFields(), bson, false);
        return bson;
    }

    private void processFields(List<FieldInformation> fields, Bson bson, boolean filterId) {
        fields.stream().filter(fieldInformation -> !fieldInformation.isSkipCheckField() && (!filterId || !fieldInformation.isId())).forEach(fieldInformation -> {
            CollectionField collectionField = fieldInformation.getCollectionField();
            Object obj = null;
            if (collectionField != null && ClassTypeUtil.isTargetClass(TypeHandler.class, collectionField.typeHandler()).booleanValue()) {
                TypeHandler typeHandler = (TypeHandler)ClassTypeUtil.getInstanceByClass(collectionField.typeHandler());
                obj = typeHandler.setParameter(fieldInformation.getName(), fieldInformation.getValue());
            }
            String fieldName = fieldInformation.getName();
            if (collectionField == null && PropertyCache.camelToUnderline.booleanValue()) {
                fieldName = StringUtils.camelToUnderline(fieldName);
            }
            if (fieldInformation.isAnnotation(FieldEncrypt.class)) {
                obj = EncryptorUtil.encrypt(fieldInformation.getAnnotation(FieldEncrypt.class), fieldInformation.getValue());
            }
            if (this.ignoreType.contains(fieldInformation.getTypeClass())) {
                obj = fieldInformation.getValue();
            }
            if (obj != null) {
                BsonUtil.addToMap(bson, fieldName, obj);
            } else {
                this.writeProperties(bson, fieldName, fieldInformation.getValue());
            }
        });
    }

    private void writeProperties(Bson bson, String key, Object sourceObj) {
        if (PropertyCache.ignoringNull.booleanValue() && sourceObj == null) {
            return;
        }
        BsonUtil.addToMap(bson, key, this.writeProperties(sourceObj));
    }

    private Object writeProperties(Object sourceObj) {
        Object resultObj;
        MappingStrategy<Object> mappingStrategy = null;
        if (sourceObj != null) {
            mappingStrategy = this.getMappingStrategy(sourceObj.getClass());
        }
        if (mappingStrategy != null) {
            try {
                resultObj = mappingStrategy.mapping(sourceObj);
            }
            catch (IllegalAccessException e) {
                String error = String.format("Exception mapping %s to simple type", sourceObj.getClass().getName());
                this.log.error(error, e);
                throw new MongoPlusWriteException(error);
            }
        } else {
            resultObj = sourceObj == null || this.simpleTypeHolder.isSimpleType(sourceObj.getClass()) || this.simpleTypeHolder.isMongoType(sourceObj.getClass()) ? this.getPotentiallyConvertedSimpleWrite(sourceObj) : (ClassTypeUtil.isTargetClass(Collection.class, sourceObj.getClass()) != false || sourceObj.getClass().isArray() ? this.writeCollectionInternal(BsonUtil.asCollection(sourceObj), new ArrayList()) : (ClassTypeUtil.isTargetClass(Map.class, sourceObj.getClass()) != false ? this.writeMapInternal((Map)sourceObj, (Bson)new Document()) : this.writeInternal(sourceObj, (Bson)new Document())));
        }
        return resultObj;
    }

    @Override
    public Bson writeMapInternal(Map<?, ?> obj, Bson bson) {
        obj.forEach((k, v) -> {
            String key;
            if (this.simpleTypeHolder.isSimpleType(k.getClass())) {
                key = String.valueOf(k);
                if (PropertyCache.camelToUnderline.booleanValue()) {
                    key = StringUtils.camelToUnderline(key);
                }
            } else {
                throw new MongoPlusWriteException("Cannot use a complex object as a key value");
            }
            this.writeProperties(bson, key, v);
        });
        return bson;
    }

    private Collection<?> writeCollectionInternal(Collection<?> obj, Collection<?> sink) {
        List<Object> collection = sink instanceof List ? (List<Object>)sink : new ArrayList(sink);
        obj.forEach(element -> collection.add(this.writeProperties(element)));
        return collection;
    }

    @Override
    public void write(Map<?, ?> map, Bson bson) {
        this.writeMapInternal(map, bson);
    }

    @Override
    public <T> T readInternal(Object sourceObj, TypeReference<T> typeReference) {
        Class<?> clazz = typeReference.getClazz();
        ConversionStrategy<?> conversionStrategy = this.getConversionStrategy(clazz);
        try {
            if (ClassTypeUtil.isTargetClass(Collection.class, clazz).booleanValue()) {
                return this.handleCollectionType(sourceObj, typeReference, clazz, conversionStrategy);
            }
            if (ClassTypeUtil.isTargetClass(Map.class, clazz).booleanValue()) {
                return this.handleMapType(sourceObj, typeReference, clazz, conversionStrategy);
            }
            return this.handleDefaultType(sourceObj, clazz, conversionStrategy);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T handleCollectionType(Object sourceObj, TypeReference<T> typeReference, Class<?> clazz, ConversionStrategy<?> conversionStrategy) throws IllegalAccessException {
        if (conversionStrategy == null) {
            Type genericTypeClass = this.extractGenericType(typeReference, 0);
            return (T)this.convertCollection(genericTypeClass, sourceObj, this.createCollectionInstance(clazz));
        }
        return (T)conversionStrategy.convertValue(sourceObj, clazz, this);
    }

    private <T> T handleMapType(Object sourceObj, TypeReference<T> typeReference, Class<?> clazz, ConversionStrategy<?> conversionStrategy) throws IllegalAccessException {
        if (conversionStrategy == null) {
            Type genericTypeClass = this.extractGenericType(typeReference, 1);
            return (T)this.convertMap(genericTypeClass, sourceObj, this.createMapInstance(clazz));
        }
        return (T)conversionStrategy.convertValue(sourceObj, clazz, this);
    }

    private <T> T handleDefaultType(Object sourceObj, Class<?> clazz, ConversionStrategy<?> conversionStrategy) throws IllegalAccessException {
        if (conversionStrategy == null) {
            conversionStrategy = ConversionCache.getConversionStrategy(Object.class);
        }
        return (T)conversionStrategy.convertValue(sourceObj, clazz, this);
    }

    private Type extractGenericType(TypeReference<?> typeReference, int index) {
        return this.genericTypeCache.computeIfAbsent(typeReference.getType(), type -> {
            if (type instanceof ParameterizedType) {
                return MappingMongoConverter.getGenericTypeClass((ParameterizedType)type, index);
            }
            return Object.class;
        });
    }

    public static Type getGenericTypeClass(ParameterizedType parameterizedType, int size) {
        return parameterizedType.getActualTypeArguments()[size];
    }

    public Collection<?> convertCollection(Type type, Object fieldValue, Collection collection) {
        if (fieldValue == null) {
            return collection;
        }
        if (!(fieldValue instanceof Collection)) {
            final Object finalFieldValue = fieldValue;
            fieldValue = new ArrayList<Object>(){
                {
                    this.add(finalFieldValue);
                }
            };
        }
        Class<?> metaClass = this.getRawClass(type);
        ArrayList valueList = (ArrayList)fieldValue;
        if (this.simpleTypeHolder.isSimpleType(metaClass)) {
            valueList.forEach(value -> collection.add(this.convertValue(value, metaClass)));
        } else if (ClassTypeUtil.isTargetClass(Collection.class, metaClass).booleanValue()) {
            Type collectionType = MappingMongoConverter.getGenericTypeClass((ParameterizedType)type, 0);
            Collection<?> collectionInstance = this.createCollectionInstance(metaClass);
            valueList.forEach(value -> this.convertCollection(collectionType, value, collectionInstance));
            collection.add(collectionInstance);
        } else if (ClassTypeUtil.isTargetClass(Map.class, metaClass).booleanValue()) {
            valueList.forEach(value -> collection.add(this.convertMap(MappingMongoConverter.getGenericTypeClass((ParameterizedType)type, 1), value, this.createMapInstance(metaClass))));
        } else {
            valueList.forEach(value -> collection.add(this.readInternal((Document)value, metaClass)));
        }
        return collection;
    }

    public <V> Map<String, V> convertMap(Type type, Object fieldValue, Map map) {
        if (fieldValue == null) {
            return map;
        }
        Document document = (Document)fieldValue;
        Class<?> rawClass = this.getRawClass(type);
        if (this.simpleTypeHolder.isSimpleType(rawClass)) {
            document.forEach((k, v) -> map.put(k, this.convertValue(v, rawClass)));
        } else if (ClassTypeUtil.isTargetClass(Collection.class, rawClass).booleanValue()) {
            document.forEach((k, v) -> map.put(k, this.convertCollection(MappingMongoConverter.getGenericTypeClass((ParameterizedType)type, 0), v, this.createCollectionInstance(rawClass))));
        } else if (ClassTypeUtil.isTargetClass(Map.class, rawClass).booleanValue()) {
            document.forEach((k, v) -> map.put(k, this.convertMap(MappingMongoConverter.getGenericTypeClass((ParameterizedType)type, 1), v, this.createMapInstance(rawClass))));
        } else {
            document.forEach((k, v) -> map.put(k, this.readInternal((Document)v, rawClass)));
        }
        return map;
    }

    private Class<?> getRawClass(Type type) {
        return this.typeClassCache.computeIfAbsent(type, this::computeRawClass);
    }

    private Class<?> computeRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        throw new RuntimeException("Unknown type: " + type);
    }

    private Collection<?> createCollectionInstance(Class<?> collectionClass) {
        Collection collection = collectionClass.isInterface() ? new ArrayList() : (Collection)ClassTypeUtil.getInstanceByClass(collectionClass);
        return collection;
    }

    public Map createMapInstance(Class<?> mapClass) {
        Map map = mapClass.isInterface() ? new HashMap() : (Map)ClassTypeUtil.getInstanceByClass(mapClass);
        return map;
    }
}

