/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.mapping;

import com.anwen.mongo.annotation.ID;
import com.anwen.mongo.annotation.collection.CollectionField;
import com.anwen.mongo.bson.MongoPlusDocument;
import com.anwen.mongo.cache.global.ConversionCache;
import com.anwen.mongo.cache.global.HandlerCache;
import com.anwen.mongo.cache.global.MappingCache;
import com.anwen.mongo.cache.global.PropertyCache;
import com.anwen.mongo.context.MongoTransactionContext;
import com.anwen.mongo.enums.FieldFill;
import com.anwen.mongo.enums.IdTypeEnum;
import com.anwen.mongo.handlers.ReadHandler;
import com.anwen.mongo.handlers.TypeHandler;
import com.anwen.mongo.handlers.collection.AnnotationOperate;
import com.anwen.mongo.incrementer.id.IdWorker;
import com.anwen.mongo.logging.Log;
import com.anwen.mongo.logging.LogFactory;
import com.anwen.mongo.manager.MongoPlusClient;
import com.anwen.mongo.mapping.FieldInformation;
import com.anwen.mongo.mapping.MongoConverter;
import com.anwen.mongo.mapping.TypeInformation;
import com.anwen.mongo.mapping.TypeReference;
import com.anwen.mongo.model.AutoFillMetaObject;
import com.anwen.mongo.strategy.conversion.ConversionStrategy;
import com.anwen.mongo.strategy.mapping.MappingStrategy;
import com.anwen.mongo.toolkit.BsonUtil;
import com.anwen.mongo.toolkit.ClassTypeUtil;
import com.anwen.mongo.toolkit.CollUtil;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public abstract class AbstractMongoConverter
implements MongoConverter {
    private final Log log = LogFactory.getLog(AbstractMongoConverter.class);
    private final MongoPlusClient mongoPlusClient;
    public final Map<Class<?>, Boolean> classEnumTypeMap = new HashMap();
    private final AutoFillMetaObject insertFillAutoFillMetaObject = new AutoFillMetaObject();
    private final AutoFillMetaObject updateFillAutoFillMetaObject = new AutoFillMetaObject();

    public AbstractMongoConverter(MongoPlusClient mongoPlusClient) {
        this.mongoPlusClient = mongoPlusClient;
    }

    @Override
    public void writeBySave(Object sourceObj, Document document) {
        FieldInformation idFieldInformation;
        if (ClassTypeUtil.isTargetClass(Map.class, sourceObj.getClass()).booleanValue()) {
            this.write((Map)sourceObj, (Bson)document);
            return;
        }
        TypeInformation typeInformation = TypeInformation.of(sourceObj);
        if (HandlerCache.metaObjectHandler != null && this.insertFillAutoFillMetaObject.isEmpty()) {
            this.getFillInsertAndUpdateField(typeInformation, this.insertFillAutoFillMetaObject, this.updateFillAutoFillMetaObject);
        }
        if ((idFieldInformation = typeInformation.getAnnotationField(ID.class)) != null) {
            Object idValue = idFieldInformation.getValue();
            if (idValue != null) {
                if (ObjectId.isValid((String)String.valueOf(idValue)) && !idValue.getClass().equals(ObjectId.class)) {
                    document.put("_id", (Object)new ObjectId(String.valueOf(idValue)));
                }
            } else {
                idValue = this.generateId(idFieldInformation.getId().type(), typeInformation);
            }
            if (idValue != null) {
                Object object = idValue = idValue instanceof ObjectId ? idValue : this.convertValue(idValue, idFieldInformation.getTypeClass());
                if (PropertyCache.objectIdConvertType.booleanValue() && idValue instanceof ObjectId) {
                    idValue = this.convertValue(idValue, idFieldInformation.getTypeClass());
                }
                document.put("_id", idValue);
                if (idFieldInformation.getId().saveField()) {
                    document.put(idFieldInformation.getName(), idValue);
                }
            }
        }
        if (HandlerCache.metaObjectHandler != null && !this.insertFillAutoFillMetaObject.isEmpty()) {
            this.insertFillAutoFillMetaObject.setTargetObject(typeInformation);
            HandlerCache.metaObjectHandler.insertFill(this.insertFillAutoFillMetaObject);
        }
        this.write(sourceObj, (Bson)document);
        this.insertFillAutoFillMetaObject.getAllFillFieldAndClear(document);
    }

    @Override
    public void writeByUpdate(Object sourceObj, Document document) {
        FieldInformation idFieldInformation;
        if (ClassTypeUtil.isTargetClass(Map.class, sourceObj.getClass()).booleanValue()) {
            this.write((Map)sourceObj, (Bson)document);
            return;
        }
        TypeInformation typeInformation = TypeInformation.of(sourceObj);
        if (HandlerCache.metaObjectHandler != null && this.updateFillAutoFillMetaObject.isEmpty()) {
            this.getFillInsertAndUpdateField(typeInformation, this.insertFillAutoFillMetaObject, this.updateFillAutoFillMetaObject);
        }
        if ((idFieldInformation = typeInformation.getAnnotationField(ID.class, "@ID field not found")).getValue() != null) {
            document.put("_id", idFieldInformation.getValue());
        }
        if (HandlerCache.metaObjectHandler != null && !this.updateFillAutoFillMetaObject.isEmpty()) {
            this.updateFillAutoFillMetaObject.setTargetObject(typeInformation);
            HandlerCache.metaObjectHandler.updateFill(this.updateFillAutoFillMetaObject);
        }
        this.write(sourceObj, (Bson)document);
        this.updateFillAutoFillMetaObject.getAllFillFieldAndClear(document);
    }

    public void getFillInsertAndUpdateField(TypeInformation typeInformation, AutoFillMetaObject insertFillAutoFillMetaObject, AutoFillMetaObject updateFillAutoFillMetaObject) {
        typeInformation.getFields().forEach(field -> {
            CollectionField collectionField = field.getCollectionField();
            if (collectionField != null && collectionField.fill() != FieldFill.DEFAULT) {
                MongoPlusDocument insertFillAutoField = insertFillAutoFillMetaObject.getDocument();
                MongoPlusDocument updateFillAutoField = updateFillAutoFillMetaObject.getDocument();
                if (collectionField.fill() == FieldFill.INSERT) {
                    insertFillAutoField.put(field.getName(), field.getValue());
                }
                if (collectionField.fill() == FieldFill.UPDATE) {
                    updateFillAutoField.put(field.getName(), field.getValue());
                }
                if (collectionField.fill() == FieldFill.INSERT_UPDATE) {
                    insertFillAutoField.put(field.getName(), field.getValue());
                    updateFillAutoField.put(field.getName(), field.getValue());
                }
            }
        });
    }

    @Override
    public void write(Object sourceObj, Bson bson) {
        if (null == sourceObj) {
            return;
        }
        Object object = bson = bson != null ? bson : new Document();
        if (ClassTypeUtil.isTargetClass(Map.class, sourceObj.getClass()).booleanValue()) {
            this.write((Map)sourceObj, bson);
        } else {
            this.write(sourceObj, bson, TypeInformation.of(sourceObj));
        }
    }

    @Override
    public <T> T readInternal(Document document, TypeReference<T> typeReference, boolean useIdAsFieldName) {
        Class<?> clazz = typeReference.getClazz();
        if (document == null) {
            return null;
        }
        if (ClassTypeUtil.isTargetClass(Document.class, clazz).booleanValue()) {
            return (T)document;
        }
        if (ClassTypeUtil.isTargetClass(Map.class, clazz).booleanValue()) {
            return (T)this.readInternal((Object)document, new TypeReference<Map<String, Object>>(){});
        }
        if (ClassTypeUtil.isTargetClass(Collection.class, clazz).booleanValue()) {
            return (T)this.readInternal((Object)document, new TypeReference<Collection<Object>>(){});
        }
        TypeInformation typeInformation = TypeInformation.of(clazz);
        typeInformation.getFields().forEach(fieldInformation -> {
            String fieldName;
            String string = fieldName = useIdAsFieldName ? fieldInformation.getIdOrCamelCaseName() : fieldInformation.getCamelCaseName();
            if (fieldInformation.isSkipCheckField()) {
                return;
            }
            Object obj = document.get((Object)fieldName);
            if (obj == null) {
                return;
            }
            CollectionField collectionField = fieldInformation.getCollectionField();
            Object resultObj = null;
            if (collectionField != null && ClassTypeUtil.isTargetClass(TypeHandler.class, collectionField.typeHandler()).booleanValue()) {
                TypeHandler typeHandler = (TypeHandler)ClassTypeUtil.getInstanceByClass(collectionField.typeHandler());
                resultObj = typeHandler.getResult(obj);
            }
            if (CollUtil.isNotEmpty(HandlerCache.readHandlerList)) {
                List readHandlerList = HandlerCache.readHandlerList.stream().sorted(Comparator.comparingInt(ReadHandler::order)).collect(Collectors.toList());
                for (ReadHandler readHandler : readHandlerList) {
                    obj = readHandler.read((FieldInformation)fieldInformation, obj);
                }
            }
            if (resultObj == null) {
                resultObj = this.readInternal(obj, TypeReference.of(fieldInformation.getGenericType()));
            }
            fieldInformation.setValue(resultObj);
        });
        return typeInformation.getInstance();
    }

    public abstract void write(Object var1, Bson var2, TypeInformation var3);

    public abstract Bson writeMapInternal(Map<?, ?> var1, Bson var2);

    public Serializable generateId(IdTypeEnum idTypeEnum, TypeInformation typeInformation) {
        if (idTypeEnum.getKey() == IdTypeEnum.ASSIGN_UUID.getKey()) {
            return IdWorker.get32UUID();
        }
        if (idTypeEnum.getKey() == IdTypeEnum.ASSIGN_ULID.getKey()) {
            return IdWorker.get26ULID();
        }
        if (idTypeEnum.getKey() == IdTypeEnum.ASSIGN_ID.getKey()) {
            return Long.valueOf(IdWorker.getId());
        }
        if (idTypeEnum.getKey() == IdTypeEnum.AUTO.getKey()) {
            return this.generateAutoId(typeInformation);
        }
        if (idTypeEnum.getKey() == IdTypeEnum.OBJECT_ID.getKey()) {
            return new ObjectId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer generateAutoId(TypeInformation typeInformation) {
        String collectionName = AnnotationOperate.getCollectionName(typeInformation.getClazz());
        String string = collectionName.intern();
        synchronized (string) {
            MongoCollection<Document> collection = this.mongoPlusClient.getCollection(typeInformation.getClazz(), PropertyCache.autoIdCollectionName);
            Document query = new Document("_id", (Object)collectionName);
            Document update = new Document("$inc", (Object)new Document("autoNum", (Object)1));
            Document document = Optional.ofNullable(MongoTransactionContext.getClientSessionContext()).map(session -> (Document)collection.findOneAndUpdate(session, (Bson)query, (Bson)update, new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER))).orElseGet(() -> (Document)collection.findOneAndUpdate((Bson)query, (Bson)update, new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)));
            int finalNum = 1;
            if (document == null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("_id", collectionName);
                map.put("autoNum", finalNum);
                collection.insertOne((Object)new Document(map));
            } else {
                finalNum = Integer.parseInt(String.valueOf(document.get((Object)"autoNum")));
            }
            return finalNum;
        }
    }

    protected Object getPotentiallyConvertedSimpleWrite(Object value) {
        if (value == null) {
            return null;
        }
        if (CollUtil.isArray(value)) {
            if (value instanceof byte[]) {
                return value;
            }
            return BsonUtil.asCollection(value);
        }
        return ClassTypeUtil.isTargetClass(Enum.class, value.getClass()) != false ? ((Enum)value).name() : value;
    }

    protected <T> T convertValue(Object obj, Class<?> clazz) {
        ConversionStrategy<?> conversionStrategy = this.getConversionStrategy(clazz);
        if (conversionStrategy == null) {
            conversionStrategy = ConversionCache.getConversionStrategy(Object.class);
        }
        try {
            return (T)conversionStrategy.convertValue(obj, clazz, this);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ConversionStrategy<?> getConversionStrategy(Class<?> target) {
        Boolean isEnumType = this.classEnumTypeMap.computeIfAbsent(target, key -> ClassTypeUtil.isTargetClass(Enum.class, key));
        if (isEnumType.booleanValue()) {
            target = Enum.class;
        }
        return ConversionCache.getConversionStrategy(target);
    }

    protected MappingStrategy<Object> getMappingStrategy(Class<?> target) {
        return MappingCache.getMappingStrategy(target);
    }
}

