/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.mapper;

import com.anwen.mongo.aggregate.Aggregate;
import com.anwen.mongo.conditions.interfaces.condition.CompareCondition;
import com.anwen.mongo.conditions.query.QueryChainWrapper;
import com.anwen.mongo.conditions.update.UpdateChainWrapper;
import com.anwen.mongo.mapper.SuperMapper;
import com.anwen.mongo.mapping.TypeReference;
import com.anwen.mongo.model.PageResult;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.WriteModel;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public interface Mapper
extends SuperMapper {
    default public <T> boolean save(String collectionName, T entity) {
        return this.save("", collectionName, entity);
    }

    default public <T> Boolean saveBatch(String collectionName, Collection<T> entityList) {
        return this.saveBatch("", collectionName, entityList);
    }

    default public Long update(String collectionName, Bson queryBasic, Bson updateBasic) {
        return this.update("", collectionName, queryBasic, updateBasic);
    }

    default public Integer bulkWrite(String collectionName, List<WriteModel<Document>> writeModelList) {
        return this.bulkWrite("", collectionName, writeModelList);
    }

    default public <T> Boolean update(String collectionName, T entity, QueryChainWrapper<T, ?> queryChainWrapper) {
        return this.update("", collectionName, entity, queryChainWrapper);
    }

    default public boolean isExist(String collectionName, Serializable id) {
        return this.isExist("", collectionName, id);
    }

    default public boolean isExist(String collectionName, QueryChainWrapper<?, ?> queryChainWrapper) {
        return this.isExist("", collectionName, queryChainWrapper);
    }

    default public Boolean update(String collectionName, UpdateChainWrapper<?, ?> updateChainWrapper) {
        return this.update("", collectionName, updateChainWrapper);
    }

    default public Boolean remove(String collectionName, UpdateChainWrapper<?, ?> updateChainWrapper) {
        return this.remove("", collectionName, updateChainWrapper);
    }

    default public Long remove(String collectionName, Bson filter) {
        return this.remove("", collectionName, filter);
    }

    default public long count(String collectionName, QueryChainWrapper<?, ?> queryChainWrapper) {
        return this.count("", collectionName, queryChainWrapper);
    }

    default public long recentPageCount(String collectionName, List<CompareCondition> compareConditionList, Integer pageNum, Integer pageSize, Integer recentPageNum) {
        return this.recentPageCount("", collectionName, compareConditionList, pageNum, pageSize, recentPageNum);
    }

    default public <R> List<R> list(String collectionName, Class<R> rClazz) {
        return this.list("", collectionName, rClazz);
    }

    default public <R> List<R> list(String collectionName, TypeReference<R> typeReference) {
        return this.list("", collectionName, typeReference);
    }

    default public <T, R> List<R> list(String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, Class<R> rClazz) {
        return this.list("", collectionName, queryChainWrapper, rClazz);
    }

    default public <T, R> List<R> list(String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, TypeReference<R> typeReference) {
        return this.list("", collectionName, queryChainWrapper, typeReference);
    }

    default public <R> List<R> aggregateList(String collectionName, Aggregate<?> aggregate, Class<R> rClazz) {
        return this.aggregateList("", collectionName, aggregate, rClazz);
    }

    default public <R> List<R> aggregateList(String collectionName, Aggregate<?> aggregate, TypeReference<R> typeReference) {
        return this.aggregateList("", collectionName, aggregate, typeReference);
    }

    default public <T, R> R one(String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, Class<R> rClazz) {
        return this.one("", collectionName, queryChainWrapper, rClazz);
    }

    default public <T, R> R one(String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, TypeReference<R> typeReference) {
        return this.one("", collectionName, queryChainWrapper, typeReference);
    }

    default public <T, R> PageResult<R> page(String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, Class<R> rClazz) {
        return this.page("", collectionName, queryChainWrapper, pageNum, pageSize, rClazz);
    }

    default public <T, R> PageResult<R> page(String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, TypeReference<R> typeReference) {
        return this.page("", collectionName, queryChainWrapper, pageNum, pageSize, typeReference);
    }

    default public <T, R> List<R> pageList(String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, Class<R> rClazz) {
        return this.pageList("", collectionName, queryChainWrapper, pageNum, pageSize, rClazz);
    }

    default public <T, R> List<R> pageList(String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, TypeReference<R> typeReference) {
        return this.pageList("", collectionName, queryChainWrapper, pageNum, pageSize, typeReference);
    }

    default public <T, R> PageResult<R> page(String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, Integer recentPageNum, Class<R> rClazz) {
        return this.page("", collectionName, queryChainWrapper, pageNum, pageSize, recentPageNum, rClazz);
    }

    default public <T, R> PageResult<R> page(String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, Integer recentPageNum, TypeReference<R> typeReference) {
        return this.page("", collectionName, queryChainWrapper, pageNum, pageSize, recentPageNum, typeReference);
    }

    default public <R> List<R> getByIds(String collectionName, Collection<? extends Serializable> ids, Class<R> rClazz) {
        return this.getByIds("", collectionName, ids, rClazz);
    }

    default public <R> List<R> getByIds(String collectionName, Collection<? extends Serializable> ids, TypeReference<R> typeReference) {
        return this.getByIds("", collectionName, ids, typeReference);
    }

    default public <R> R getById(String collectionName, Serializable id, Class<R> rClazz) {
        return this.getById("", collectionName, id, rClazz);
    }

    default public <R> R getById(String collectionName, Serializable id, TypeReference<R> typeReference) {
        return this.getById("", collectionName, id, typeReference);
    }

    default public <R> List<R> queryCommand(String collectionName, String command, Class<R> rClazz) {
        return this.queryCommand("", collectionName, command, rClazz);
    }

    default public <R> List<R> queryCommand(String collectionName, String command, TypeReference<R> typeReference) {
        return this.queryCommand("", collectionName, command, typeReference);
    }

    default public <R> List<R> getByColumn(String collectionName, String column, Object value, Class<R> rClazz) {
        return this.getByColumn("", collectionName, column, value, rClazz);
    }

    default public <R> List<R> getByColumn(String collectionName, String column, Object value, TypeReference<R> typeReference) {
        return this.getByColumn("", collectionName, column, value, typeReference);
    }

    default public long count(String collectionName) {
        return this.count("", collectionName);
    }

    default public String createIndex(String collectionName, Bson bson) {
        return this.createIndex("", collectionName, bson);
    }

    default public String createIndex(String collectionName, Bson bson, IndexOptions indexOptions) {
        return this.createIndex("", collectionName, bson, indexOptions);
    }

    default public List<String> createIndexes(String collectionName, List<IndexModel> indexes) {
        return this.createIndexes("", collectionName, indexes);
    }

    default public List<String> createIndexes(String collectionName, List<IndexModel> indexes, CreateIndexOptions createIndexOptions) {
        return this.createIndexes("", collectionName, indexes, createIndexOptions);
    }

    default public List<Document> listIndexes(String collectionName) {
        return this.listIndexes("", collectionName);
    }

    default public void dropIndex(String collectionName, String indexName) {
        this.dropIndex("", collectionName, indexName);
    }

    default public void dropIndex(String collectionName, String indexName, DropIndexOptions dropIndexOptions) {
        this.dropIndex("", collectionName, indexName, dropIndexOptions);
    }

    default public void dropIndex(String collectionName, Bson keys) {
        this.dropIndex("", collectionName, keys);
    }

    default public void dropIndex(String collectionName, Bson keys, DropIndexOptions dropIndexOptions) {
        this.dropIndex("", collectionName, keys, dropIndexOptions);
    }

    default public void dropIndexes(String collectionName) {
        this.dropIndex("", collectionName);
    }

    default public void dropIndexes(String collectionName, DropIndexOptions dropIndexOptions) {
        this.dropIndexes("", collectionName, dropIndexOptions);
    }
}

