/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.mapper;

import com.anwen.mongo.aggregate.Aggregate;
import com.anwen.mongo.aware.MongoAwareUtils;
import com.anwen.mongo.aware.impl.NamespaceAware;
import com.anwen.mongo.conditions.interfaces.condition.CompareCondition;
import com.anwen.mongo.conditions.query.QueryChainWrapper;
import com.anwen.mongo.conditions.query.QueryWrapper;
import com.anwen.mongo.conditions.update.UpdateChainWrapper;
import com.anwen.mongo.execute.ExecutorFactory;
import com.anwen.mongo.manager.MongoPlusClient;
import com.anwen.mongo.mapper.AbstractBaseMapper;
import com.anwen.mongo.mapping.MongoConverter;
import com.anwen.mongo.mapping.TypeReference;
import com.anwen.mongo.model.MutablePair;
import com.anwen.mongo.model.PageResult;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.WriteModel;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public class DefaultBaseMapperImpl
extends AbstractBaseMapper {
    private final MongoPlusClient mongoPlusClient;

    public DefaultBaseMapperImpl(MongoPlusClient mongoPlusClient, MongoConverter mongoConverter) {
        super(mongoPlusClient, mongoConverter, new ExecutorFactory());
        this.mongoPlusClient = mongoPlusClient;
    }

    public DefaultBaseMapperImpl(MongoPlusClient mongoPlusClient, MongoConverter mongoConverter, ExecutorFactory factory) {
        super(mongoPlusClient, mongoConverter, factory);
        this.mongoPlusClient = mongoPlusClient;
    }

    @Override
    public <T> boolean save(T entity) {
        MutablePair<String, String> namespace = this.getNamespace(entity.getClass());
        return this.save((String)namespace.left, (String)namespace.right, entity);
    }

    @Override
    public <T> Boolean saveBatch(Collection<T> entityList) {
        Class<?> clazz = entityList.iterator().next().getClass();
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.saveBatch((String)namespace.left, (String)namespace.right, entityList);
    }

    @Override
    public Integer bulkWrite(List<WriteModel<Document>> writeModelList, Class<?> clazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.bulkWrite((String)namespace.left, (String)namespace.right, writeModelList);
    }

    @Override
    public <T> Boolean update(T entity, QueryChainWrapper<T, ?> queryChainWrapper) {
        MutablePair<String, String> namespace = this.getNamespace(entity.getClass());
        return this.update((String)namespace.left, (String)namespace.right, entity, queryChainWrapper);
    }

    @Override
    public <T, R> List<R> list(Class<T> clazz, Class<R> rClazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.list((String)namespace.left, (String)namespace.right, rClazz);
    }

    @Override
    public <T, R> List<R> list(Class<T> clazz, TypeReference<R> typeReference) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.list((String)namespace.left, (String)namespace.right, typeReference);
    }

    @Override
    public <T, R> List<R> list(QueryChainWrapper<T, ?> queryChainWrapper, Class<T> clazz, Class<R> rClazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.list((String)namespace.left, (String)namespace.right, queryChainWrapper, rClazz);
    }

    @Override
    public <T, R> List<R> list(QueryChainWrapper<T, ?> queryChainWrapper, Class<T> clazz, TypeReference<R> typeReference) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.list((String)namespace.left, (String)namespace.right, queryChainWrapper, typeReference);
    }

    @Override
    public <T, R> List<R> aggregateList(Aggregate<?> aggregate, Class<T> clazz, Class<R> rClazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.aggregateList((String)namespace.left, (String)namespace.right, aggregate, rClazz);
    }

    @Override
    public <T, R> List<R> aggregateList(Aggregate<?> aggregate, Class<T> clazz, TypeReference<R> typeReference) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.aggregateList((String)namespace.left, (String)namespace.right, aggregate, typeReference);
    }

    @Override
    public <T, R> R one(QueryChainWrapper<T, ?> queryChainWrapper, Class<T> clazz, Class<R> rClazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.one((String)namespace.left, (String)namespace.right, queryChainWrapper, rClazz);
    }

    @Override
    public <T, R> R one(QueryChainWrapper<T, ?> queryChainWrapper, Class<T> clazz, TypeReference<R> typeReference) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.one((String)namespace.left, (String)namespace.right, queryChainWrapper, typeReference);
    }

    @Override
    public <T, R> PageResult<R> page(Integer pageNum, Integer pageSize, Class<T> clazz, Class<R> rClazz) {
        return this.page(new QueryWrapper(), pageNum, pageSize, clazz, rClazz);
    }

    @Override
    public <T, R> PageResult<R> page(QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, Class<T> clazz, Class<R> rClazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.page((String)namespace.left, (String)namespace.right, queryChainWrapper, pageNum, pageSize, rClazz);
    }

    @Override
    public <T, R> PageResult<R> page(QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, Class<T> clazz, TypeReference<R> typeReference) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.page((String)namespace.left, (String)namespace.right, queryChainWrapper, pageNum, pageSize, typeReference);
    }

    @Override
    public <T, R> List<R> pageList(QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, Class<T> clazz, Class<R> rClazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.pageList((String)namespace.left, (String)namespace.right, queryChainWrapper, pageNum, pageSize, rClazz);
    }

    @Override
    public <T, R> List<R> pageList(QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, Class<T> clazz, TypeReference<R> typeReference) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.pageList((String)namespace.left, (String)namespace.right, queryChainWrapper, pageNum, pageSize, typeReference);
    }

    @Override
    public <T, R> PageResult<R> page(QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, Integer recentPageNum, Class<T> clazz, Class<R> rClazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.page((String)namespace.left, (String)namespace.right, queryChainWrapper, pageNum, pageSize, recentPageNum, rClazz);
    }

    @Override
    public <T, R> PageResult<R> page(QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, Integer recentPageNum, Class<T> clazz, TypeReference<R> typeReference) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.page((String)namespace.left, (String)namespace.right, queryChainWrapper, pageNum, pageSize, recentPageNum, typeReference);
    }

    @Override
    public <T, R> R getById(Serializable id, Class<T> clazz, Class<R> rClazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.getById((String)namespace.left, (String)namespace.right, id, rClazz);
    }

    @Override
    public <T, R> R getById(Serializable id, Class<T> clazz, TypeReference<R> typeReference) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.getById((String)namespace.left, (String)namespace.right, id, typeReference);
    }

    @Override
    public boolean isExist(Serializable id, Class<?> clazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.isExist((String)namespace.left, (String)namespace.right, id);
    }

    @Override
    public boolean isExist(QueryChainWrapper<?, ?> queryChainWrapper, Class<?> clazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.isExist((String)namespace.left, (String)namespace.right, queryChainWrapper);
    }

    @Override
    public <T, R> List<R> getByIds(Collection<? extends Serializable> ids, Class<T> clazz, Class<R> rClazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.getByIds((String)namespace.left, (String)namespace.right, ids, rClazz);
    }

    @Override
    public <T, R> List<R> getByIds(Collection<? extends Serializable> ids, Class<T> clazz, TypeReference<R> typeReference) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.getByIds((String)namespace.left, (String)namespace.right, ids, typeReference);
    }

    @Override
    public Boolean update(UpdateChainWrapper<?, ?> updateChainWrapper, Class<?> clazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.update((String)namespace.left, (String)namespace.right, updateChainWrapper);
    }

    @Override
    public Boolean remove(UpdateChainWrapper<?, ?> updateChainWrapper, Class<?> clazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.remove((String)namespace.left, (String)namespace.right, updateChainWrapper);
    }

    @Override
    public Long remove(Bson filter, Class<?> clazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.remove((String)namespace.left, (String)namespace.right, filter);
    }

    @Override
    public long count(QueryChainWrapper<?, ?> queryChainWrapper, Class<?> clazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.count((String)namespace.left, (String)namespace.right, queryChainWrapper);
    }

    @Override
    public long recentPageCount(List<CompareCondition> compareConditionList, Class<?> clazz, Integer pageNum, Integer pageSize, Integer recentPageNum) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.recentPageCount((String)namespace.left, (String)namespace.right, compareConditionList, pageNum, pageSize, recentPageNum);
    }

    @Override
    public long count(Class<?> clazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.count((String)namespace.left, (String)namespace.right);
    }

    @Override
    public <T, R> List<R> queryCommand(String command, Class<T> clazz, Class<R> rClazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.queryCommand((String)namespace.left, (String)namespace.right, command, rClazz);
    }

    @Override
    public <T, R> List<R> queryCommand(String command, Class<T> clazz, TypeReference<R> typeReference) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.queryCommand((String)namespace.left, (String)namespace.right, command, typeReference);
    }

    @Override
    public <T, R> List<R> getByColumn(String column, Object value, Class<T> clazz, Class<R> rClazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.getByColumn((String)namespace.left, (String)namespace.right, column, value, rClazz);
    }

    @Override
    public <T, R> List<R> getByColumn(String column, Object value, Class<T> clazz, TypeReference<R> typeReference) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.getByColumn((String)namespace.left, (String)namespace.right, column, value, typeReference);
    }

    @Override
    public String createIndex(Bson bson, Class<?> clazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.createIndex((String)namespace.left, (String)namespace.right, bson);
    }

    @Override
    public String createIndex(Bson bson, IndexOptions indexOptions, Class<?> clazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.createIndex((String)namespace.left, (String)namespace.right, bson, indexOptions);
    }

    @Override
    public List<String> createIndexes(List<IndexModel> indexes, Class<?> clazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.createIndexes((String)namespace.left, (String)namespace.right, indexes);
    }

    @Override
    public List<String> createIndexes(List<IndexModel> indexes, CreateIndexOptions createIndexOptions, Class<?> clazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.createIndexes((String)namespace.left, (String)namespace.right, indexes, createIndexOptions);
    }

    @Override
    public List<Document> listIndexes(Class<?> clazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        return this.listIndexes((String)namespace.left, (String)namespace.right);
    }

    @Override
    public void dropIndex(String indexName, Class<?> clazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        this.dropIndex((String)namespace.left, (String)namespace.right, indexName);
    }

    @Override
    public void dropIndex(String indexName, DropIndexOptions dropIndexOptions, Class<?> clazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        this.dropIndex((String)namespace.left, (String)namespace.right, indexName, dropIndexOptions);
    }

    @Override
    public void dropIndex(Bson keys, Class<?> clazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        this.dropIndex((String)namespace.left, (String)namespace.right, keys);
    }

    @Override
    public void dropIndex(Bson keys, DropIndexOptions dropIndexOptions, Class<?> clazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        this.dropIndex((String)namespace.left, (String)namespace.right, keys, dropIndexOptions);
    }

    @Override
    public void dropIndexes(Class<?> clazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        this.dropIndexes((String)namespace.left, (String)namespace.right);
    }

    @Override
    public void dropIndexes(DropIndexOptions dropIndexOptions, Class<?> clazz) {
        MutablePair<String, String> namespace = this.getNamespace(clazz);
        this.dropIndexes((String)namespace.left, (String)namespace.right, dropIndexOptions);
    }

    protected MutablePair<String, String> getNamespace(Class<?> clazz) {
        String database = this.mongoPlusClient.getDatabase(clazz);
        String collectionName = this.mongoPlusClient.getCollectionName(clazz);
        NamespaceAware.Namespace namespace = NamespaceAware.NamespaceBuild.builder().dataBase(database).collectionName(collectionName).entityClass(clazz).build();
        List<NamespaceAware> handlers = MongoAwareUtils.listHandlers(NamespaceAware.class);
        for (NamespaceAware aware : handlers) {
            aware.nameSpaceAware(namespace);
        }
        return new MutablePair<String, String>(database, collectionName);
    }
}

