/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.mapper;

import com.anwen.mongo.aggregate.Aggregate;
import com.anwen.mongo.conditions.interfaces.condition.CompareCondition;
import com.anwen.mongo.conditions.query.QueryChainWrapper;
import com.anwen.mongo.conditions.query.QueryWrapper;
import com.anwen.mongo.conditions.update.UpdateChainWrapper;
import com.anwen.mongo.mapper.Mapper;
import com.anwen.mongo.mapping.TypeReference;
import com.anwen.mongo.model.PageResult;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.WriteModel;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public interface BaseMapper
extends Mapper {
    public <T> boolean save(T var1);

    public <T> Boolean saveBatch(Collection<T> var1);

    public Integer bulkWrite(List<WriteModel<Document>> var1, Class<?> var2);

    public <T> Boolean update(T var1, QueryChainWrapper<T, ?> var2);

    public boolean isExist(Serializable var1, Class<?> var2);

    public boolean isExist(QueryChainWrapper<?, ?> var1, Class<?> var2);

    public Boolean update(UpdateChainWrapper<?, ?> var1, Class<?> var2);

    public Boolean remove(UpdateChainWrapper<?, ?> var1, Class<?> var2);

    public Long remove(Bson var1, Class<?> var2);

    public long count(QueryChainWrapper<?, ?> var1, Class<?> var2);

    public long recentPageCount(List<CompareCondition> var1, Class<?> var2, Integer var3, Integer var4, Integer var5);

    public <T, R> List<R> list(Class<T> var1, Class<R> var2);

    default public <T> List<T> list(Class<T> clazz) {
        return this.list(clazz, clazz);
    }

    public <T, R> List<R> list(Class<T> var1, TypeReference<R> var2);

    public <T, R> List<R> list(QueryChainWrapper<T, ?> var1, Class<T> var2, Class<R> var3);

    default public <T, R> List<R> list(QueryChainWrapper<T, ?> queryChainWrapper, Class<R> clazz) {
        return this.list(queryChainWrapper, clazz, clazz);
    }

    public <T, R> List<R> list(QueryChainWrapper<T, ?> var1, Class<T> var2, TypeReference<R> var3);

    public <T, R> List<R> aggregateList(Aggregate<?> var1, Class<T> var2, Class<R> var3);

    default public <T> List<T> aggregateList(Aggregate<?> aggregate, Class<T> clazz) {
        return this.aggregateList(aggregate, clazz, clazz);
    }

    public <T, R> List<R> aggregateList(Aggregate<?> var1, Class<T> var2, TypeReference<R> var3);

    public <T, R> R one(QueryChainWrapper<T, ?> var1, Class<T> var2, Class<R> var3);

    default public <T, R> R one(QueryChainWrapper<T, ?> queryChainWrapper, Class<R> clazz) {
        return this.one(queryChainWrapper, clazz, clazz);
    }

    public <T, R> R one(QueryChainWrapper<T, ?> var1, Class<T> var2, TypeReference<R> var3);

    public <T, R> PageResult<R> page(Integer var1, Integer var2, Class<T> var3, Class<R> var4);

    default public <T> PageResult<T> page(Integer pageNum, Integer pageSize, Class<T> clazz) {
        return this.page(pageNum, pageSize, clazz, clazz);
    }

    public <T, R> PageResult<R> page(QueryChainWrapper<T, ?> var1, Integer var2, Integer var3, Class<T> var4, Class<R> var5);

    public <T, R> PageResult<R> page(QueryChainWrapper<T, ?> var1, Integer var2, Integer var3, Class<T> var4, TypeReference<R> var5);

    default public <T, R> List<R> pageList(Integer pageNum, Integer pageSize, Class<T> clazz, Class<R> rClazz) {
        return this.pageList(new QueryWrapper(), pageNum, pageSize, clazz, rClazz);
    }

    default public <T> List<T> pageList(Integer pageNum, Integer pageSize, Class<T> clazz) {
        return this.pageList(pageNum, pageSize, clazz, clazz);
    }

    public <T, R> List<R> pageList(QueryChainWrapper<T, ?> var1, Integer var2, Integer var3, Class<T> var4, Class<R> var5);

    public <T, R> List<R> pageList(QueryChainWrapper<T, ?> var1, Integer var2, Integer var3, Class<T> var4, TypeReference<R> var5);

    default public <T, R> PageResult<R> page(Integer pageNum, Integer pageSize, Integer recentPageNum, Class<T> clazz, Class<R> rClazz) {
        return this.page(new QueryWrapper(), pageNum, pageSize, recentPageNum, clazz, rClazz);
    }

    default public <T> PageResult<T> page(Integer pageNum, Integer pageSize, Integer recentPageNum, Class<T> clazz) {
        return this.page(pageNum, pageSize, recentPageNum, clazz, clazz);
    }

    public <T, R> PageResult<R> page(QueryChainWrapper<T, ?> var1, Integer var2, Integer var3, Integer var4, Class<T> var5, Class<R> var6);

    public <T, R> PageResult<R> page(QueryChainWrapper<T, ?> var1, Integer var2, Integer var3, Integer var4, Class<T> var5, TypeReference<R> var6);

    public <T, R> List<R> getByIds(Collection<? extends Serializable> var1, Class<T> var2, Class<R> var3);

    default public <T> List<T> getByIds(Collection<? extends Serializable> ids, Class<T> clazz) {
        return this.getByIds(ids, clazz, clazz);
    }

    public <T, R> List<R> getByIds(Collection<? extends Serializable> var1, Class<T> var2, TypeReference<R> var3);

    public <T, R> R getById(Serializable var1, Class<T> var2, Class<R> var3);

    default public <T> T getById(Serializable id, Class<T> clazz) {
        return this.getById(id, clazz, clazz);
    }

    public <T, R> R getById(Serializable var1, Class<T> var2, TypeReference<R> var3);

    public <T, R> List<R> queryCommand(String var1, Class<T> var2, Class<R> var3);

    default public <T> List<T> queryCommand(String command, Class<T> clazz) {
        return this.queryCommand(command, clazz, clazz);
    }

    public <T, R> List<R> queryCommand(String var1, Class<T> var2, TypeReference<R> var3);

    public <T, R> List<R> getByColumn(String var1, Object var2, Class<T> var3, Class<R> var4);

    default public <T> List<T> getByColumn(String column, Object value, Class<T> clazz) {
        return this.getByColumn(column, value, clazz, clazz);
    }

    public <T, R> List<R> getByColumn(String var1, Object var2, Class<T> var3, TypeReference<R> var4);

    public long count(Class<?> var1);

    public String createIndex(Bson var1, Class<?> var2);

    public String createIndex(Bson var1, IndexOptions var2, Class<?> var3);

    public List<String> createIndexes(List<IndexModel> var1, Class<?> var2);

    public List<String> createIndexes(List<IndexModel> var1, CreateIndexOptions var2, Class<?> var3);

    public List<Document> listIndexes(Class<?> var1);

    public void dropIndex(String var1, Class<?> var2);

    public void dropIndex(String var1, DropIndexOptions var2, Class<?> var3);

    public void dropIndex(Bson var1, Class<?> var2);

    public void dropIndex(Bson var1, DropIndexOptions var2, Class<?> var3);

    public void dropIndexes(Class<?> var1);

    public void dropIndexes(DropIndexOptions var1, Class<?> var2);
}

