/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.mapper;

import com.anwen.mongo.aggregate.Aggregate;
import com.anwen.mongo.cache.global.InterceptorCache;
import com.anwen.mongo.cache.global.TenantCache;
import com.anwen.mongo.conditions.interfaces.condition.CompareCondition;
import com.anwen.mongo.conditions.query.QueryChainWrapper;
import com.anwen.mongo.conditions.query.QueryWrapper;
import com.anwen.mongo.conditions.update.UpdateChainWrapper;
import com.anwen.mongo.enums.SpecialConditionEnum;
import com.anwen.mongo.execute.Execute;
import com.anwen.mongo.execute.ExecutorFactory;
import com.anwen.mongo.handlers.condition.BuildCondition;
import com.anwen.mongo.logging.Log;
import com.anwen.mongo.logging.LogFactory;
import com.anwen.mongo.logic.LogicDeleteHandler;
import com.anwen.mongo.manager.MongoPlusClient;
import com.anwen.mongo.mapper.BaseMapper;
import com.anwen.mongo.mapping.MongoConverter;
import com.anwen.mongo.mapping.TypeReference;
import com.anwen.mongo.model.BaseLambdaQueryResult;
import com.anwen.mongo.model.MutablePair;
import com.anwen.mongo.model.PageParam;
import com.anwen.mongo.model.PageResult;
import com.anwen.mongo.toolkit.AggregateUtil;
import com.anwen.mongo.toolkit.Assert;
import com.anwen.mongo.toolkit.BsonUtil;
import com.anwen.mongo.toolkit.CollUtil;
import com.anwen.mongo.toolkit.ConditionUtil;
import com.anwen.mongo.toolkit.Filters;
import com.anwen.mongo.toolkit.LambdaOperate;
import com.anwen.mongo.toolkit.ObjectIdUtil;
import com.anwen.mongo.toolkit.Wrappers;
import com.mongodb.BasicDBObject;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.InsertManyResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bson.Document;
import org.bson.conversions.Bson;

public abstract class AbstractBaseMapper
implements BaseMapper {
    private final Log log = LogFactory.getLog(AbstractBaseMapper.class);
    private final MongoPlusClient mongoPlusClient;
    private final MongoConverter mongoConverter;
    private final ExecutorFactory factory;
    private final LambdaOperate lambdaOperate = new LambdaOperate();

    public AbstractBaseMapper(MongoPlusClient mongoPlusClient, MongoConverter mongoConverter, ExecutorFactory factory) {
        this.mongoPlusClient = mongoPlusClient;
        this.mongoConverter = mongoConverter;
        this.factory = factory;
    }

    @Override
    public MongoPlusClient getMongoPlusClient() {
        return this.mongoPlusClient;
    }

    @Override
    public MongoConverter getMongoConverter() {
        return this.mongoConverter;
    }

    @Override
    public Execute getExecute() {
        return this.factory.getExecute();
    }

    @Override
    public <T> boolean save(String database, String collectionName, T entity) {
        try {
            Document document = new Document();
            this.mongoConverter.writeBySave(entity, document);
            InsertManyResult insertManyResult = this.factory.getExecute().executeSave(Collections.singletonList(document), this.mongoPlusClient.getCollection(database, collectionName));
            this.mongoConverter.reSetIdValue(entity, document);
            return insertManyResult.wasAcknowledged();
        }
        catch (Exception e) {
            this.log.error("save fail , error info : {}", e.getMessage(), e);
            throw e;
        }
    }

    @Override
    public <T> Boolean saveBatch(String database, String collectionName, Collection<T> entityList) {
        try {
            Assert.notEmpty(entityList, "entityList can not be empty");
            ArrayList<Document> documentList = new ArrayList<Document>(entityList.size());
            this.mongoConverter.writeBySaveBatch(entityList, documentList);
            MongoCollection<Document> collection = this.mongoPlusClient.getCollection(database, collectionName);
            InsertManyResult insertManyResult = this.factory.getExecute().executeSave(documentList, collection);
            this.mongoConverter.batchReSetIdValue(entityList, documentList);
            return insertManyResult.getInsertedIds().size() == entityList.size();
        }
        catch (Exception e) {
            this.log.error("saveBatch fail , error info : {}", e.getMessage(), e);
            throw e;
        }
    }

    @Override
    public Long update(String database, String collectionName, Bson queryBasic, Bson updateBasic) {
        return this.factory.getExecute().executeUpdate(Collections.singletonList(new MutablePair<Bson, Bson>(queryBasic, updateBasic)), this.mongoPlusClient.getCollection(database, collectionName)).getModifiedCount();
    }

    @Override
    public Integer bulkWrite(String database, String collectionName, List<WriteModel<Document>> writeModelList) {
        Assert.notEmpty(writeModelList, "writeModelList can not be empty");
        BulkWriteResult bulkWriteResult = this.factory.getExecute().executeBulkWrite(writeModelList, this.mongoPlusClient.getCollection(database, collectionName));
        return bulkWriteResult.getModifiedCount() + bulkWriteResult.getInsertedCount();
    }

    @Override
    public <T> Boolean update(String database, String collectionName, T entity, QueryChainWrapper<T, ?> queryChainWrapper) {
        MutablePair<BasicDBObject, BasicDBObject> updatePair = ConditionUtil.getUpdateCondition(queryChainWrapper.getCompareList(), entity, this.mongoConverter);
        return this.update(database, collectionName, (Bson)updatePair.getLeft(), (Bson)updatePair.getRight()) > 0L;
    }

    @Override
    public boolean isExist(String database, String collectionName, Serializable id) {
        QueryWrapper wrapper = (QueryWrapper)Wrappers.lambdaQuery().eq("_id", (Object)id);
        return this.isExist(database, collectionName, wrapper);
    }

    @Override
    public boolean isExist(String database, String collectionName, QueryChainWrapper<?, ?> queryChainWrapper) {
        BasicDBObject basicDBObject = BuildCondition.condition().queryCondition(queryChainWrapper.getCompareList());
        return this.factory.getExecute().executeCount(basicDBObject, null, this.mongoPlusClient.getCollection(database, collectionName)) >= 1L;
    }

    @Override
    public Boolean update(String database, String collectionName, UpdateChainWrapper<?, ?> updateChainWrapper) {
        MutablePair<BasicDBObject, BasicDBObject> pair = BuildCondition.condition().updateCondition(updateChainWrapper);
        BasicDBObject targetBasicDBObject = new BasicDBObject();
        this.mongoConverter.write((Map)pair.getRight(), (Bson)targetBasicDBObject);
        return this.update(database, collectionName, (Bson)pair.getLeft(), (Bson)targetBasicDBObject) >= 1L;
    }

    @Override
    public Boolean remove(String database, String collectionName, UpdateChainWrapper<?, ?> updateChainWrapper) {
        return this.remove(database, collectionName, (Bson)BuildCondition.condition().queryCondition(updateChainWrapper.getCompareList())) >= 1L;
    }

    @Override
    public Long remove(String database, String collectionName, Bson filter) {
        return this.factory.getExecute().executeRemove(filter, this.mongoPlusClient.getCollection(database, collectionName)).getDeletedCount();
    }

    @Override
    public long count(String database, String collectionName, QueryChainWrapper<?, ?> queryChainWrapper) {
        Execute execute = this.factory.getExecute();
        MongoCollection<Document> collection = this.mongoPlusClient.getCollection(database, collectionName);
        long line = this.canEstimatedDocumentCount(collection, queryChainWrapper) ? execute.estimatedDocumentCount(collection) : execute.executeCount(BuildCondition.condition().queryCondition(queryChainWrapper.getCompareList()), null, collection);
        return line;
    }

    private boolean canEstimatedDocumentCount(MongoCollection<Document> collection, QueryChainWrapper<?, ?> queryChainWrapper) {
        return !(!LogicDeleteHandler.close(collection) || !Objects.isNull(queryChainWrapper) && !CollUtil.isEmpty(queryChainWrapper.getCompareList()) || TenantCache.getIgnoreTenant() == null && InterceptorCache.getTenant() != null);
    }

    @Override
    public long recentPageCount(String database, String collectionName, List<CompareCondition> compareConditionList, Integer pageNum, Integer pageSize, Integer recentPageNum) {
        if (recentPageNum == null || recentPageNum > 50 || recentPageNum < 5) {
            return -1L;
        }
        int limitParam = (pageNum < recentPageNum / 2 + 1 + recentPageNum % 2 ? recentPageNum : pageNum + (recentPageNum / 2 + recentPageNum % 2 - 1)) * pageSize;
        CountOptions countOptions = new CountOptions();
        countOptions.skip(limitParam).limit(1);
        MongoCollection<Document> collection = this.mongoPlusClient.getCollection(database, collectionName);
        long isExists = this.factory.getExecute().executeCount(BuildCondition.condition().queryCondition(compareConditionList), countOptions, collection);
        if (isExists == 0L) {
            CountOptions countOptionsReal = new CountOptions();
            countOptionsReal.limit(limitParam);
            return this.factory.getExecute().executeCount(BuildCondition.condition().queryCondition(compareConditionList), countOptions, collection);
        }
        return limitParam;
    }

    @Override
    public <R> List<R> list(String database, String collectionName, Class<R> rClazz) {
        return this.list(database, collectionName, new TypeReference<R>(rClazz){});
    }

    @Override
    public <R> List<R> list(String database, String collectionName, TypeReference<R> typeReference) {
        FindIterable<Document> findIterable = this.factory.getExecute().executeQuery(null, null, null, Document.class, this.mongoPlusClient.getCollection(database, collectionName));
        return this.mongoConverter.read((MongoIterable<Document>)findIterable, typeReference);
    }

    @Override
    public <T, R> List<R> list(String database, String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, Class<R> rClazz) {
        return this.list(database, collectionName, queryChainWrapper, new TypeReference<R>(rClazz){});
    }

    @Override
    public <T, R> List<R> list(String database, String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, TypeReference<R> typeReference) {
        BaseLambdaQueryResult baseLambdaQuery = this.lambdaOperate.baseLambdaQuery(queryChainWrapper.getCompareList(), queryChainWrapper.getOrderList(), queryChainWrapper.getProjectionList(), queryChainWrapper.getBasicDBObjectList());
        FindIterable<Document> documentFindIterable = this.factory.getExecute().executeQuery((Bson)baseLambdaQuery.getCondition(), baseLambdaQuery.getProjection(), baseLambdaQuery.getSort(), Document.class, this.mongoPlusClient.getCollection(database, collectionName));
        return this.mongoConverter.read((MongoIterable<Document>)documentFindIterable, typeReference);
    }

    @Override
    public <R> List<R> aggregateList(String database, String collectionName, Aggregate<?> aggregate, Class<R> rClazz) {
        return this.aggregateList(database, collectionName, aggregate, new TypeReference<R>(rClazz){});
    }

    @Override
    public <R> List<R> aggregateList(String database, String collectionName, Aggregate<?> aggregate, TypeReference<R> typeReference) {
        List<Bson> aggregateConditionList = aggregate.getAggregateConditionList();
        AggregateIterable<Document> aggregateIterable = this.factory.getExecute().executeAggregate(aggregateConditionList, Document.class, this.mongoPlusClient.getCollection(database, collectionName));
        AggregateUtil.aggregateOptions(aggregateIterable, aggregate.getAggregateOptions());
        return this.mongoConverter.read((MongoIterable<Document>)aggregateIterable, typeReference);
    }

    @Override
    public <T, R> R one(String database, String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, Class<R> rClazz) {
        return this.one(database, collectionName, queryChainWrapper, new TypeReference<R>(rClazz){});
    }

    @Override
    public <T, R> R one(String database, String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, TypeReference<R> typeReference) {
        BaseLambdaQueryResult baseLambdaQuery = this.lambdaOperate.baseLambdaQuery(queryChainWrapper.getCompareList(), queryChainWrapper.getOrderList(), queryChainWrapper.getProjectionList(), queryChainWrapper.getBasicDBObjectList());
        return this.mongoConverter.readDocument((MongoIterable<Document>)this.factory.getExecute().executeQuery((Bson)baseLambdaQuery.getCondition(), baseLambdaQuery.getProjection(), baseLambdaQuery.getSort(), Document.class, this.mongoPlusClient.getCollection(database, collectionName)).limit(1), typeReference);
    }

    @Override
    public <T, R> PageResult<R> page(String database, String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, Class<R> rClazz) {
        return this.page(database, collectionName, queryChainWrapper, pageNum, pageSize, new TypeReference<R>(rClazz){});
    }

    @Override
    public <T, R> PageResult<R> page(String database, String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, TypeReference<R> typeReference) {
        BaseLambdaQueryResult baseLambdaQuery = this.lambdaOperate.baseLambdaQuery(queryChainWrapper.getCompareList(), queryChainWrapper.getOrderList(), queryChainWrapper.getProjectionList(), queryChainWrapper.getBasicDBObjectList());
        MongoCollection<Document> collection = this.mongoPlusClient.getCollection(database, collectionName);
        long count = this.canEstimatedDocumentCount(collection, queryChainWrapper) ? this.factory.getExecute().estimatedDocumentCount(collection) : this.count(database, collectionName, queryChainWrapper);
        FindIterable<Document> iterable = this.factory.getExecute().executeQuery((Bson)baseLambdaQuery.getCondition(), baseLambdaQuery.getProjection(), baseLambdaQuery.getSort(), Document.class, collection);
        return this.lambdaOperate.getLambdaQueryResultPage(iterable, count, new PageParam(pageNum, pageSize), typeReference, this.mongoConverter);
    }

    @Override
    public <T, R> List<R> pageList(String database, String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, Class<R> rClazz) {
        return this.pageList(database, collectionName, queryChainWrapper, pageNum, pageSize, new TypeReference<R>(rClazz){});
    }

    @Override
    public <T, R> List<R> pageList(String database, String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, TypeReference<R> typeReference) {
        BaseLambdaQueryResult baseLambdaQuery = this.lambdaOperate.baseLambdaQuery(queryChainWrapper.getCompareList(), queryChainWrapper.getOrderList(), queryChainWrapper.getProjectionList(), queryChainWrapper.getBasicDBObjectList());
        FindIterable<Document> iterable = this.factory.getExecute().executeQuery((Bson)baseLambdaQuery.getCondition(), baseLambdaQuery.getProjection(), baseLambdaQuery.getSort(), Document.class, this.mongoPlusClient.getCollection(database, collectionName));
        return this.mongoConverter.read((MongoIterable<Document>)iterable.skip((pageNum - 1) * pageSize).limit(pageSize.intValue()), typeReference);
    }

    @Override
    public <T, R> PageResult<R> page(String database, String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, Integer recentPageNum, Class<R> rClazz) {
        return this.page(database, collectionName, queryChainWrapper, pageNum, pageSize, recentPageNum, new TypeReference<R>(rClazz){});
    }

    @Override
    public <T, R> PageResult<R> page(String database, String collectionName, QueryChainWrapper<T, ?> queryChainWrapper, Integer pageNum, Integer pageSize, Integer recentPageNum, TypeReference<R> typeReference) {
        BaseLambdaQueryResult baseLambdaQuery = this.lambdaOperate.baseLambdaQuery(queryChainWrapper.getCompareList(), queryChainWrapper.getOrderList(), queryChainWrapper.getProjectionList(), queryChainWrapper.getBasicDBObjectList());
        MongoCollection<Document> collection = this.mongoPlusClient.getCollection(database, collectionName);
        long count = this.canEstimatedDocumentCount(collection, queryChainWrapper) ? this.factory.getExecute().estimatedDocumentCount(collection) : this.recentPageCount(database, collectionName, queryChainWrapper.getCompareList(), pageNum, pageSize, recentPageNum);
        FindIterable<Document> iterable = this.factory.getExecute().executeQuery((Bson)baseLambdaQuery.getCondition(), baseLambdaQuery.getProjection(), baseLambdaQuery.getSort(), Document.class, collection);
        return this.lambdaOperate.getLambdaQueryResultPage(iterable, count, new PageParam(pageNum, pageSize), typeReference, this.mongoConverter);
    }

    @Override
    public <R> List<R> getByIds(String database, String collectionName, Collection<? extends Serializable> ids, Class<R> rClazz) {
        return this.getByIds(database, collectionName, ids, new TypeReference<R>(rClazz){});
    }

    @Override
    public <R> List<R> getByIds(String database, String collectionName, Collection<? extends Serializable> ids, TypeReference<R> typeReference) {
        FindIterable<Document> iterable = this.factory.getExecute().executeQuery(BsonUtil.getIdsCondition(ids), null, null, Document.class, this.mongoPlusClient.getCollection(database, collectionName));
        return this.mongoConverter.read((MongoIterable<Document>)iterable, typeReference);
    }

    @Override
    public <R> R getById(String database, String collectionName, Serializable id, Class<R> rClazz) {
        return this.getById(database, collectionName, id, new TypeReference<R>(rClazz){});
    }

    @Override
    public <R> R getById(String database, String collectionName, Serializable id, TypeReference<R> typeReference) {
        BasicDBObject queryBasic = new BasicDBObject("_id", (Object)new BasicDBObject(SpecialConditionEnum.EQ.getCondition(), ObjectIdUtil.getObjectIdValue(id)));
        return this.mongoConverter.read(this.factory.getExecute().executeQuery((Bson)queryBasic, null, null, Document.class, this.mongoPlusClient.getCollection(database, collectionName)).first(), typeReference);
    }

    @Override
    public <R> List<R> queryCommand(String database, String collectionName, String command, Class<R> rClazz) {
        return this.queryCommand(database, collectionName, command, new TypeReference<R>(rClazz){});
    }

    @Override
    public <R> List<R> queryCommand(String database, String collectionName, String command, TypeReference<R> typeReference) {
        FindIterable<Document> iterable = this.factory.getExecute().executeQuery((Bson)BasicDBObject.parse((String)command), null, null, Document.class, this.mongoPlusClient.getCollection(database, collectionName));
        return this.mongoConverter.read((MongoIterable<Document>)iterable, typeReference);
    }

    @Override
    public <R> List<R> getByColumn(String database, String collectionName, String column, Object value, Class<R> rClazz) {
        return this.getByColumn(database, collectionName, column, value, new TypeReference<R>(rClazz){});
    }

    @Override
    public <R> List<R> getByColumn(String database, String collectionName, String column, Object value, TypeReference<R> typeReference) {
        Bson filter = Filters.eq(column, ObjectIdUtil.getObjectIdValue(value));
        return this.mongoConverter.read((MongoIterable<Document>)this.factory.getExecute().executeQuery(filter, null, null, Document.class, this.mongoPlusClient.getCollection(database, collectionName)), typeReference);
    }

    @Override
    public long count(String database, String collectionName) {
        MongoCollection<Document> collection = this.mongoPlusClient.getCollection(database, collectionName);
        Execute execute = this.factory.getExecute();
        long line = this.canEstimatedDocumentCount(collection, null) ? execute.estimatedDocumentCount(collection) : execute.executeCount(null, null, collection);
        return line;
    }

    @Override
    public String createIndex(String database, String collectionName, Bson bson) {
        return this.factory.getExecute().doCreateIndex(bson, this.mongoPlusClient.getCollection(database, collectionName));
    }

    @Override
    public String createIndex(String database, String collectionName, Bson bson, IndexOptions indexOptions) {
        return this.factory.getExecute().doCreateIndex(bson, indexOptions, this.mongoPlusClient.getCollection(database, collectionName));
    }

    @Override
    public List<String> createIndexes(String database, String collectionName, List<IndexModel> indexes) {
        return this.factory.getExecute().doCreateIndexes(indexes, this.mongoPlusClient.getCollection(database, collectionName));
    }

    @Override
    public List<String> createIndexes(String database, String collectionName, List<IndexModel> indexes, CreateIndexOptions createIndexOptions) {
        return this.factory.getExecute().doCreateIndexes(indexes, createIndexOptions, this.mongoPlusClient.getCollection(database, collectionName));
    }

    @Override
    public List<Document> listIndexes(String database, String collectionName) {
        return this.factory.getExecute().doListIndexes(this.mongoPlusClient.getCollection(database, collectionName));
    }

    @Override
    public void dropIndex(String database, String collectionName, String indexName) {
        this.factory.getExecute().doDropIndex(indexName, this.mongoPlusClient.getCollection(database, collectionName));
    }

    @Override
    public void dropIndex(String database, String collectionName, String indexName, DropIndexOptions dropIndexOptions) {
        this.factory.getExecute().doDropIndex(indexName, dropIndexOptions, this.mongoPlusClient.getCollection(database, collectionName));
    }

    @Override
    public void dropIndex(String database, String collectionName, Bson keys) {
        this.factory.getExecute().doDropIndex(keys, this.mongoPlusClient.getCollection(database, collectionName));
    }

    @Override
    public void dropIndex(String database, String collectionName, Bson keys, DropIndexOptions dropIndexOptions) {
        this.factory.getExecute().doDropIndex(keys, dropIndexOptions, this.mongoPlusClient.getCollection(database, collectionName));
    }

    @Override
    public void dropIndexes(String database, String collectionName) {
        this.factory.getExecute().doDropIndexes(this.mongoPlusClient.getCollection(database, collectionName));
    }

    @Override
    public void dropIndexes(String database, String collectionName, DropIndexOptions dropIndexOptions) {
        this.factory.getExecute().doDropIndexes(dropIndexOptions, this.mongoPlusClient.getCollection(database, collectionName));
    }
}

