/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.manager;

import com.anwen.mongo.annotation.transactional.MongoReadPreference;
import com.anwen.mongo.annotation.transactional.MongoTransactional;
import com.anwen.mongo.context.MongoTransactionContext;
import com.anwen.mongo.context.MongoTransactionStatus;
import com.anwen.mongo.domain.InitMongoPlusException;
import com.anwen.mongo.enums.ReadConcernEnum;
import com.anwen.mongo.enums.ReadPreferenceEnum;
import com.anwen.mongo.enums.WriteConcernEnum;
import com.anwen.mongo.factory.MongoClientFactory;
import com.anwen.mongo.logging.Log;
import com.anwen.mongo.logging.LogFactory;
import com.mongodb.ClientSessionOptions;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class MongoTransactionalManager {
    private static final Log log = LogFactory.getLog(MongoTransactionalManager.class);

    public static MongoClient getMongoClient() {
        MongoClientFactory mongoClientFactory = MongoClientFactory.getInstance();
        if (mongoClientFactory == null) {
            throw new InitMongoPlusException("Please initialize MongoClientFactory first");
        }
        return mongoClientFactory.getMongoClient();
    }

    public static ClientSession getTransaction() {
        return MongoTransactionalManager.getTransaction(null);
    }

    public static ClientSession getTransaction(MongoTransactional transactional) {
        ClientSession session = MongoTransactionContext.getClientSessionContext();
        if (session == null) {
            ClientSessionOptions.Builder builder = ClientSessionOptions.builder();
            builder.causallyConsistent(true);
            if (Objects.nonNull(transactional)) {
                MongoTransactionalManager.config(transactional, builder);
            }
            session = MongoTransactionalManager.getMongoClient().startSession(builder.build());
        }
        return session;
    }

    public static void startTransaction() {
        MongoTransactionalManager.startTransaction(MongoTransactionalManager.getTransaction());
    }

    public static void startTransaction(TransactionOptions options) {
        MongoTransactionalManager.startTransaction(MongoTransactionalManager.getTransaction(), options);
    }

    public static void startTransaction(MongoTransactional transactional) {
        MongoTransactionalManager.startTransaction(MongoTransactionalManager.getTransaction(transactional));
    }

    public static void startTransaction(ClientSession session) {
        MongoTransactionalManager.startTransaction(session, null);
    }

    public static void startTransaction(ClientSession session, TransactionOptions options) {
        if (options == null) {
            options = TransactionOptions.builder().build();
        }
        session.startTransaction(options);
        MongoTransactionStatus status = new MongoTransactionStatus(session);
        MongoTransactionContext.setTransactionStatus(status);
        MongoTransactionContext.getMongoTransactionStatus().incrementReference();
        if (log.isDebugEnabled()) {
            log.debug("Mongo transaction created, Thread:{}, session hashcode:{}", Thread.currentThread().getName(), session.hashCode());
        }
    }

    private static void config(MongoTransactional transactional, ClientSessionOptions.Builder builder) {
        builder.causallyConsistent(transactional.causallyConsistent()).snapshot(transactional.snapshot());
        ReadConcern readConcern = MongoTransactionalManager.buildReadConcern(transactional.readConcern());
        WriteConcern writeConcern = MongoTransactionalManager.buildWriteConcern(transactional.writeConcern());
        ReadPreference readPreference = MongoTransactionalManager.buildReadPreference(transactional.preference());
        TransactionOptions.Builder tsPBuilder = TransactionOptions.builder();
        if (transactional.maxCommitTimeMS() > 0L) {
            tsPBuilder.maxCommitTime(Long.valueOf(transactional.maxCommitTimeMS()), transactional.timeUnit());
        }
        Optional.ofNullable(readConcern).ifPresent(arg_0 -> ((TransactionOptions.Builder)tsPBuilder).readConcern(arg_0));
        Optional.ofNullable(writeConcern).ifPresent(arg_0 -> ((TransactionOptions.Builder)tsPBuilder).writeConcern(arg_0));
        Optional.ofNullable(readPreference).ifPresent(arg_0 -> ((TransactionOptions.Builder)tsPBuilder).readPreference(arg_0));
        builder.defaultTransactionOptions(tsPBuilder.build());
    }

    private static ReadPreference buildReadPreference(MongoReadPreference[] preferences) {
        if (Objects.isNull(preferences) || preferences.length != 1) {
            return null;
        }
        MongoReadPreference preference = preferences[0];
        ReadPreferenceEnum preferenceEnum = preference.preferenceEnum();
        long maxStaleness = preference.maxStaleness();
        TimeUnit timeUnit = preference.timeUnit();
        if (maxStaleness > 0L) {
            return MongoTransactionalManager.getReadPreference(preferenceEnum, maxStaleness, timeUnit);
        }
        return MongoTransactionalManager.getReadPreference(preferenceEnum);
    }

    private static ReadPreference getReadPreference(ReadPreferenceEnum preferenceEnum) {
        switch (preferenceEnum) {
            case PRIMARY: {
                return ReadPreference.primary();
            }
            case PRIMARY_PREFERRED: {
                return ReadPreference.primaryPreferred();
            }
            case SECONDARY: {
                return ReadPreference.secondary();
            }
            case SECONDARY_PREFERRED: {
                return ReadPreference.secondaryPreferred();
            }
            case NEAREST: {
                return ReadPreference.nearest();
            }
        }
        return null;
    }

    private static ReadPreference getReadPreference(ReadPreferenceEnum preferenceEnum, long maxStaleness, TimeUnit timeUnit) {
        switch (preferenceEnum) {
            case PRIMARY: {
                return ReadPreference.primary();
            }
            case PRIMARY_PREFERRED: {
                return ReadPreference.primaryPreferred((long)maxStaleness, (TimeUnit)timeUnit);
            }
            case SECONDARY: {
                return ReadPreference.secondary((long)maxStaleness, (TimeUnit)timeUnit);
            }
            case SECONDARY_PREFERRED: {
                return ReadPreference.secondaryPreferred((long)maxStaleness, (TimeUnit)timeUnit);
            }
            case NEAREST: {
                return ReadPreference.nearest((long)maxStaleness, (TimeUnit)timeUnit);
            }
        }
        return null;
    }

    private static WriteConcern buildWriteConcern(WriteConcernEnum writeConcernEnum) {
        if (Objects.isNull(writeConcernEnum)) {
            return null;
        }
        switch (writeConcernEnum) {
            case ACKNOWLEDGED: {
                return WriteConcern.ACKNOWLEDGED;
            }
            case UNACKNOWLEDGED: {
                return WriteConcern.UNACKNOWLEDGED;
            }
            case MAJORITY: {
                return WriteConcern.MAJORITY;
            }
            case W1: {
                return WriteConcern.W1;
            }
            case W2: {
                return WriteConcern.W2;
            }
            case W3: {
                return WriteConcern.W3;
            }
            case JOURNALED: {
                return WriteConcern.JOURNALED;
            }
        }
        return null;
    }

    private static ReadConcern buildReadConcern(ReadConcernEnum readConcernEnum) {
        if (Objects.isNull(readConcernEnum)) {
            return null;
        }
        switch (readConcernEnum) {
            case DEFAULT: {
                return ReadConcern.DEFAULT;
            }
            case LOCAL: {
                return ReadConcern.LOCAL;
            }
            case MAJORITY: {
                return ReadConcern.MAJORITY;
            }
            case LINEARIZABLE: {
                return ReadConcern.LINEARIZABLE;
            }
            case AVAILABLE: {
                return ReadConcern.AVAILABLE;
            }
            case SNAPSHOT: {
                return ReadConcern.SNAPSHOT;
            }
        }
        return null;
    }

    public static void commitTransaction() {
        ClientSession clientSession;
        MongoTransactionStatus status = MongoTransactionContext.getMongoTransactionStatus();
        if (status == null) {
            log.warn("no session to commit.");
            return;
        }
        status.decrementReference();
        if (status.readyCommit() && (clientSession = status.getClientSession()).hasActiveTransaction()) {
            clientSession.commitTransaction();
        }
        if (log.isDebugEnabled()) {
            log.debug("Mongo transaction committed, Thread:{}, session hashcode:{}", Thread.currentThread().getName(), status.getClientSession().hashCode());
        }
    }

    public static void rollbackTransaction() {
        MongoTransactionStatus status = MongoTransactionContext.getMongoTransactionStatus();
        if (status == null) {
            log.warn("no session to rollback.");
            return;
        }
        status.clearReference();
        ClientSession clientSession = status.getClientSession();
        if (clientSession.hasActiveTransaction()) {
            clientSession.abortTransaction();
        }
        if (log.isDebugEnabled()) {
            log.debug("Mongo transaction rolled back, Thread:{}, session hashcode:{}", Thread.currentThread().getName(), status.getClientSession().hashCode());
        }
    }

    public static void closeSession() {
        MongoTransactionStatus status = MongoTransactionContext.getMongoTransactionStatus();
        if (status == null) {
            log.warn("no session to rollback.");
            return;
        }
        if (status.readyClose()) {
            try {
                ClientSession clientSession = status.getClientSession();
                if (clientSession.hasActiveTransaction()) {
                    clientSession.close();
                }
            }
            finally {
                MongoTransactionContext.clear();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Mongo transaction closed, Thread:{}, session hashcode:{}", Thread.currentThread().getName(), status.getClientSession().hashCode());
        }
    }
}

