/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.manager;

import com.anwen.mongo.cache.global.DataSourceNameCache;
import com.anwen.mongo.conn.CollectionManager;
import com.anwen.mongo.factory.MongoClientFactory;
import com.anwen.mongo.handlers.collection.AnnotationOperate;
import com.anwen.mongo.model.BaseProperty;
import com.anwen.mongo.toolkit.StringUtils;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bson.Document;

public class MongoPlusClient {
    private BaseProperty baseProperty;
    private List<MongoDatabase> mongoDatabase;
    private Map<String, Map<String, CollectionManager>> collectionManagerMap;

    public Map<String, Map<String, CollectionManager>> getCollectionManagerMap() {
        return this.collectionManagerMap;
    }

    public MongoCollection<Document> getCollection(Class<?> clazz) {
        return this.getCollectionManager(clazz).getCollection(clazz);
    }

    public MongoCollection<Document> getCollection(Class<?> clazz, String collectionName) {
        return this.getCollectionManager(clazz).getCollection(collectionName);
    }

    public MongoCollection<Document> getCollection(String database, String collectionName) {
        return this.getCollectionManager(database).getCollection(collectionName);
    }

    public MongoCollection<Document> getCollection(String database, Class<?> clazz) {
        return this.getCollectionManager(database).getCollection(clazz);
    }

    public CollectionManager getCollectionManager(Class<?> clazz) {
        return this.getCollectionManager(this.getDatabase(clazz));
    }

    public CollectionManager getCollectionManager(String database) {
        Map<String, CollectionManager> managerMap = this.getCollectionManagerMap().get(DataSourceNameCache.getDataSource());
        if (StringUtils.isBlank(database)) {
            database = (String)managerMap.keySet().stream().findFirst().get();
        }
        if (null == managerMap || null == managerMap.get(database)) {
            final CollectionManager collectionManager = new CollectionManager(database);
            this.getMongoDatabase().add(this.getMongoClient().getDatabase(database));
            final String finalDatabase = database;
            this.getCollectionManagerMap().put(DataSourceNameCache.getDataSource(), (Map<String, CollectionManager>)new ConcurrentHashMap<String, CollectionManager>(){
                {
                    this.put(finalDatabase, collectionManager);
                }
            });
        }
        return this.getCollectionManagerMap().get(DataSourceNameCache.getDataSource()).get(database);
    }

    public String getDatabase(Class<?> clazz) {
        String annotationDatabase;
        String database = DataSourceNameCache.getDatabase();
        if (database.contains(",")) {
            database = (String)Arrays.stream(database.split(",")).collect(Collectors.toList()).get(0);
        }
        if (StringUtils.isNotBlank(annotationDatabase = AnnotationOperate.getDatabase(clazz))) {
            database = annotationDatabase;
        }
        Map<String, CollectionManager> managerMap = this.getCollectionManagerMap().get(DataSourceNameCache.getDataSource());
        if (StringUtils.isBlank(database)) {
            database = (String)managerMap.keySet().stream().findFirst().get();
        }
        return database;
    }

    public MongoDatabase getMongoDatabase(String database) {
        return this.getMongoClient().getDatabase(database);
    }

    public List<String> getCollectionListByDatabase(String database) {
        return (List)this.getMongoDatabase(database).listCollectionNames().into(new ArrayList());
    }

    public String getCollectionName(Class<?> clazz) {
        return AnnotationOperate.getCollectionName(clazz);
    }

    public void setCollectionManagerMap(final String database) {
        final CollectionManager collectionManager = new CollectionManager(database);
        this.getMongoDatabase().add(this.getMongoClient().getDatabase(database));
        this.getCollectionManagerMap().put(DataSourceNameCache.getDataSource(), (Map<String, CollectionManager>)new ConcurrentHashMap<String, CollectionManager>(){
            {
                this.put(database, collectionManager);
            }
        });
    }

    public void setCollectionManagerMap(Map<String, Map<String, CollectionManager>> collectionManagerMap) {
        this.collectionManagerMap = collectionManagerMap;
    }

    public BaseProperty getBaseProperty() {
        return this.baseProperty;
    }

    public void setBaseProperty(BaseProperty baseProperty) {
        this.baseProperty = baseProperty;
    }

    public MongoClient getMongoClient() {
        return MongoClientFactory.getInstance().getMongoClient();
    }

    public List<MongoDatabase> getMongoDatabase() {
        return this.mongoDatabase;
    }

    public void setMongoDatabase(List<MongoDatabase> mongoDatabase) {
        this.mongoDatabase = mongoDatabase;
    }

    public String toString() {
        return "ConnectionManager{baseProperty=" + this.baseProperty + ", mongoDatabase=" + this.mongoDatabase + ", collectionManager=" + this.collectionManagerMap + '}';
    }
}

