/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.manager;

import com.anwen.mongo.cache.global.DataSourceNameCache;
import com.anwen.mongo.conn.CollectionManager;
import com.anwen.mongo.factory.MongoClientFactory;
import com.anwen.mongo.manager.MongoPlusClient;
import com.anwen.mongo.model.BaseProperty;
import com.anwen.mongo.toolkit.MongoUtil;
import com.mongodb.client.MongoClient;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class DataSourceManager {
    private final MongoPlusClient mongoPlusClient;
    private final MongoClientFactory mongoClientFactory;

    public DataSourceManager(MongoPlusClient mongoPlusClient, MongoClientFactory mongoClientFactory) {
        this.mongoPlusClient = mongoPlusClient;
        this.mongoClientFactory = mongoClientFactory;
    }

    public void appendTempDataSource(String dsName, final BaseProperty baseProperty, boolean isOverride) {
        MongoClient mongoClient = MongoUtil.getMongo(dsName, baseProperty);
        Boolean containsMongoClient = this.mongoClientFactory.containsMongoClient(dsName);
        if (!containsMongoClient.booleanValue() || isOverride) {
            this.mongoClientFactory.addMongoClient(dsName, mongoClient);
            this.mongoPlusClient.getCollectionManagerMap().put(dsName, (Map<String, CollectionManager>)new LinkedHashMap<String, CollectionManager>(){
                {
                    Arrays.stream(baseProperty.getDatabase().split(",")).collect(Collectors.toList()).forEach((? super T db) -> this.put(db, new CollectionManager((String)db)));
                }
            });
        }
    }

    public void changeDataSource(String dsName) {
        DataSourceNameCache.setDataSource(dsName);
    }

    public void clearDataSource() {
        DataSourceNameCache.clear();
    }

    public String currentDataSourceName() {
        return DataSourceNameCache.getDataSource();
    }
}

