/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.logic;

import com.anwen.mongo.cache.codec.MapCodecCache;
import com.anwen.mongo.cache.global.CollectionLogicDeleteCache;
import com.anwen.mongo.conditions.interfaces.condition.CompareCondition;
import com.anwen.mongo.conditions.query.QueryChainWrapper;
import com.anwen.mongo.conditions.query.QueryWrapper;
import com.anwen.mongo.config.Configuration;
import com.anwen.mongo.handlers.condition.BuildCondition;
import com.anwen.mongo.model.LogicDeleteResult;
import com.anwen.mongo.toolkit.ChainWrappers;
import com.anwen.mongo.toolkit.Filters;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;

public interface LogicDeleteHandler {
    public static boolean close(MongoCollection<Document> collection) {
        return LogicDeleteHandler.close() || Objects.isNull(LogicDeleteHandler.mapper().get(LogicDeleteHandler.getBeanClass(collection)));
    }

    public static boolean close() {
        return CollectionLogicDeleteCache.open == false;
    }

    public static Map<Class<?>, LogicDeleteResult> mapper() {
        return CollectionLogicDeleteCache.logicDeleteResultHashMap;
    }

    public static <T> Bson doBsonLogicDel(Bson query, Class<T> clazz) {
        if (LogicDeleteHandler.close()) {
            return query;
        }
        LogicDeleteResult result = LogicDeleteHandler.mapper().get(clazz);
        if (Objects.isNull(result)) {
            return query;
        }
        if (Objects.isNull(query)) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq(result.getColumn(), (Object)result.getLogicNotDeleteValue());
            return BuildCondition.condition().queryCondition(wrapper.getCompareList());
        }
        if (query instanceof BasicDBObject) {
            BasicDBObject bdb = (BasicDBObject)query;
            bdb.put((Object)result.getColumn(), (Object)new BsonString(result.getLogicNotDeleteValue()));
            return bdb;
        }
        if (query instanceof Filters.MPBson) {
            Filters.MPBson filter = (Filters.MPBson)query;
            BasicDBObject bdb = filter.getBasicDBObject();
            bdb.put((Object)result.getColumn(), (Object)new BsonString(result.getLogicNotDeleteValue()));
            return bdb;
        }
        BsonDocument bsonDocument = query.toBsonDocument(BsonDocument.class, MapCodecCache.getDefaultCodecRegistry());
        bsonDocument.append(result.getColumn(), (BsonValue)new BsonString(result.getLogicNotDeleteValue()));
        return bsonDocument;
    }

    public static List<CompareCondition> doWrapperLogicDel(Class clazz) {
        return LogicDeleteHandler.doWrapperLogicDel(null, clazz);
    }

    public static <T> List<CompareCondition> doWrapperLogicDel(QueryChainWrapper<T, ?> queryChainWrapper, Class clazz) {
        if (LogicDeleteHandler.close()) {
            if (Objects.isNull(queryChainWrapper)) {
                return null;
            }
            return queryChainWrapper.getCompareList();
        }
        LogicDeleteResult result = CollectionLogicDeleteCache.logicDeleteResultHashMap.get(clazz);
        if (Objects.isNull(result)) {
            if (Objects.isNull(queryChainWrapper)) {
                return null;
            }
            return queryChainWrapper.getCompareList();
        }
        if (Objects.isNull(queryChainWrapper)) {
            queryChainWrapper = ChainWrappers.lambdaQueryChain(null, clazz);
        }
        queryChainWrapper.eq(result.getColumn(), (Object)result.getLogicNotDeleteValue());
        return queryChainWrapper.getCompareList();
    }

    public static Class<?> getBeanClass(MongoCollection<Document> collection) {
        if (Objects.isNull(collection)) {
            return null;
        }
        Class<?> clazz = CollectionLogicDeleteCache.fullNameMap.get(collection.getNamespace().getFullName());
        if (Objects.nonNull(clazz) && !CollectionLogicDeleteCache.logicDeleteResultHashMap.containsKey(clazz)) {
            Configuration.builder().setLogicFiled(CollectionLogicDeleteCache.logicProperty, clazz);
        }
        return clazz;
    }
}

