/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.logging;

import com.anwen.mongo.cache.global.PropertyCache;
import com.anwen.mongo.logging.Log;
import com.anwen.mongo.logging.LogException;
import com.anwen.mongo.logging.commons.JakartaCommonsLoggingImpl;
import com.anwen.mongo.logging.jdk14.Jdk14LoggingImpl;
import com.anwen.mongo.logging.log4j2.Log4j2Impl;
import com.anwen.mongo.logging.nologging.NoLoggingImpl;
import com.anwen.mongo.logging.slf4j.Slf4jImpl;
import com.anwen.mongo.logging.stdout.StdOutImpl;
import com.anwen.mongo.proxy.LogProxy;
import java.lang.reflect.Constructor;
import java.util.concurrent.locks.ReentrantLock;

public final class LogFactory {
    public static final String MARKER = "MYBATIS";
    private static final ReentrantLock lock = new ReentrantLock();
    private static Constructor<? extends Log> logConstructor;

    private LogFactory() {
    }

    public static Log getLog(Class<?> clazz) {
        return LogFactory.getLog(clazz.getName());
    }

    public static Log getLog(String logger) {
        try {
            Log log = logConstructor.newInstance(logger);
            if (PropertyCache.ikun.booleanValue()) {
                return new LogProxy(log);
            }
            return log;
        }
        catch (Throwable t) {
            throw new LogException("Error creating logger for logger " + logger + ".  Cause: " + t, t);
        }
    }

    public static void useCustomLogging(Class<? extends Log> clazz) {
        LogFactory.setImplementation(clazz);
    }

    public static void useSlf4jLogging() {
        LogFactory.setImplementation(Slf4jImpl.class);
    }

    public static void useCommonsLogging() {
        LogFactory.setImplementation(JakartaCommonsLoggingImpl.class);
    }

    public static void useLog4J2Logging() {
        LogFactory.setImplementation(Log4j2Impl.class);
    }

    public static void useJdkLogging() {
        LogFactory.setImplementation(Jdk14LoggingImpl.class);
    }

    public static void useStdOutLogging() {
        LogFactory.setImplementation(StdOutImpl.class);
    }

    public static void useNoLogging() {
        LogFactory.setImplementation(NoLoggingImpl.class);
    }

    private static void tryImplementation(Runnable runnable) {
        if (logConstructor == null) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void setImplementation(Class<? extends Log> implClass) {
        lock.lock();
        try {
            Constructor<? extends Log> candidate = implClass.getConstructor(String.class);
            Log log = candidate.newInstance(LogFactory.class.getName());
            if (log.isDebugEnabled()) {
                log.debug("Logging initialized using '" + implClass + "' adapter.");
            }
            logConstructor = candidate;
        }
        catch (Throwable t) {
            throw new LogException("Error setting Log implementation.  Cause: " + t, t);
        }
        finally {
            lock.unlock();
        }
    }

    static {
        LogFactory.tryImplementation(LogFactory::useSlf4jLogging);
        LogFactory.tryImplementation(LogFactory::useCommonsLogging);
        LogFactory.tryImplementation(LogFactory::useLog4J2Logging);
        LogFactory.tryImplementation(LogFactory::useJdkLogging);
        LogFactory.tryImplementation(LogFactory::useNoLogging);
    }
}

