/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.interceptor.business;

import com.anwen.mongo.aggregate.AggregateWrapper;
import com.anwen.mongo.cache.codec.MapCodecCache;
import com.anwen.mongo.cache.global.DataSourceNameCache;
import com.anwen.mongo.cache.global.TenantCache;
import com.anwen.mongo.conditions.query.QueryChainWrapper;
import com.anwen.mongo.conditions.query.QueryWrapper;
import com.anwen.mongo.enums.AggregateEnum;
import com.anwen.mongo.handlers.TenantHandler;
import com.anwen.mongo.interceptor.Interceptor;
import com.anwen.mongo.model.MutablePair;
import com.anwen.mongo.model.QueryParam;
import com.anwen.mongo.toolkit.BsonUtil;
import com.anwen.mongo.toolkit.CollUtil;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.WriteModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;

public class TenantInterceptor
implements Interceptor {
    private final TenantHandler tenantHandler;

    public TenantInterceptor(TenantHandler tenantHandler) {
        this.tenantHandler = tenantHandler;
    }

    @Override
    public int order() {
        return 0;
    }

    @Override
    public List<Document> executeSave(List<Document> documentList, MongoCollection<Document> collection) {
        if (this.isTenantIgnored(collection) || this.tenantHandler.ignoreInsert(new ArrayList<String>(documentList.get(0).keySet()), this.tenantHandler.getTenantIdColumn())) {
            return documentList;
        }
        documentList.forEach(document -> document.putIfAbsent((Object)this.tenantHandler.getTenantIdColumn(), (Object)this.tenantHandler.getTenantId()));
        return documentList;
    }

    @Override
    public Bson executeRemove(Bson filter, MongoCollection<Document> collection) {
        return this.appendTenantFilter(filter, collection);
    }

    @Override
    public List<MutablePair<Bson, Bson>> executeUpdate(List<MutablePair<Bson, Bson>> updatePairList, MongoCollection<Document> collection) {
        if (!this.isTenantIgnored(collection)) {
            updatePairList.forEach(pair -> pair.setLeft(this.appendTenantFilter((Bson)pair.getLeft(), collection)));
        }
        return updatePairList;
    }

    @Override
    public QueryParam executeQuery(Bson queryBasic, BasicDBObject projectionList, BasicDBObject sortCond, MongoCollection<Document> collection) {
        return new QueryParam(this.appendTenantFilter(queryBasic, collection), projectionList, sortCond);
    }

    @Override
    public List<Bson> executeAggregates(List<Bson> aggregateConditionList, MongoCollection<Document> collection) {
        if (!this.isTenantIgnored(collection)) {
            Bson matchBson = ((AggregateWrapper)new AggregateWrapper().match((QueryChainWrapper)new QueryWrapper().eq(this.tenantHandler.getTenantIdColumn(), (Object)this.tenantHandler.getTenantId()))).getAggregateConditionList().get(0);
            boolean hasMatch = aggregateConditionList.stream().anyMatch(bson -> bson.toBsonDocument(BsonDocument.class, MapCodecCache.getDefaultCodecRegistry()).containsKey((Object)AggregateEnum.MATCH.getValue()));
            if (hasMatch) {
                aggregateConditionList.forEach(bson -> {
                    BsonDocument bsonDocument = bson.toBsonDocument(BsonDocument.class, MapCodecCache.getDefaultCodecRegistry());
                    if (bsonDocument.containsKey((Object)AggregateEnum.MATCH.getValue())) {
                        BsonDocument matchBsonDocument = bsonDocument.get((Object)AggregateEnum.MATCH.getValue()).asDocument();
                        matchBsonDocument.putIfAbsent((Object)this.tenantHandler.getTenantIdColumn(), (Object)this.tenantHandler.getTenantId());
                    }
                });
            } else {
                aggregateConditionList.add(0, matchBson);
            }
        }
        return aggregateConditionList;
    }

    @Override
    public MutablePair<BasicDBObject, CountOptions> executeCount(BasicDBObject queryBasic, CountOptions countOptions, MongoCollection<Document> collection) {
        return new MutablePair<BasicDBObject, CountOptions>(this.appendTenantFilter(queryBasic, collection), countOptions);
    }

    @Override
    public List<WriteModel<Document>> executeBulkWrite(List<WriteModel<Document>> writeModelList, MongoCollection<Document> collection) {
        if (!this.isTenantIgnored(collection) && CollUtil.isNotEmpty(writeModelList)) {
            List<MutablePair<Bson, Bson>> updatePairList;
            List<Document> insertDocumentList = writeModelList.stream().filter(writeModel -> writeModel instanceof InsertOneModel).map(writeModel -> (Document)((InsertOneModel)writeModel).getDocument()).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(insertDocumentList)) {
                this.executeSave(insertDocumentList, collection);
            }
            if (CollUtil.isNotEmpty(updatePairList = writeModelList.stream().filter(writeModel -> writeModel instanceof UpdateManyModel).map(writeModel -> new MutablePair<Bson, Bson>(((UpdateManyModel)writeModel).getFilter(), ((UpdateManyModel)writeModel).getUpdate())).collect(Collectors.toList()))) {
                this.executeUpdate(updatePairList, collection);
            }
        }
        return writeModelList;
    }

    private boolean isTenantIgnored(MongoCollection<Document> collection) {
        MongoNamespace namespace = collection.getNamespace();
        String collectionName = namespace.getCollectionName();
        String databaseName = namespace.getDatabaseName();
        String dataSource = DataSourceNameCache.getDataSource();
        Boolean ignoreTenant = TenantCache.getIgnoreTenant();
        return ignoreTenant != null ? ignoreTenant : this.tenantHandler.ignoreCollection(collectionName) || this.tenantHandler.ignoreDatabase(databaseName) || this.tenantHandler.ignoreDataSource(dataSource);
    }

    private <T extends Bson> T appendTenantFilter(T filter, MongoCollection<Document> collection) {
        BsonDocument filterDoc;
        if (filter == null) {
            filter = new Document();
        }
        if (!this.isTenantIgnored(collection) && !(filterDoc = filter.toBsonDocument(BsonDocument.class, MapCodecCache.getDefaultCodecRegistry())).containsKey((Object)this.tenantHandler.getTenantIdColumn())) {
            BsonUtil.addToMap(filter, this.tenantHandler.getTenantIdColumn(), this.tenantHandler.getTenantId());
        }
        return filter;
    }
}

